/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.TextCache;
import org.hsqldb.persist.TextFileReader;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowInputInterface;

public class TextTable
extends Table {
    String dataSource = "";
    boolean isReversed = false;
    boolean isConnected = false;

    TextTable(Database db, HsqlNameManager.HsqlName name, int type) {
        super(db, name, type);
        this.isWithDataSource = true;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    public void connect(Session session) {
        this.connect(session, this.isReadOnly);
    }

    private void connect(Session session, boolean withReadOnlyData) {
        if (this.dataSource.isEmpty() || this.isConnected) {
            return;
        }
        this.store = this.database.persistentStoreCollection.getStore(this);
        TextCache cache = null;
        TextFileReader reader = null;
        boolean readOnly = this.isReadOnly || this.database.isReadOnly();
        String securePath = this.database.logger.getSecurePath(this.dataSource, false, true);
        if (securePath == null) {
            throw Error.error(457, this.dataSource);
        }
        try {
            cache = (TextCache)this.database.logger.textTableManager.openTextFilePersistence(this, securePath, readOnly, this.isReversed);
            this.store.setCache(cache);
            reader = cache.getTextFileReader();
            if (cache.isIgnoreFirstLine()) {
                reader.readHeaderLine();
                cache.setHeaderInitialise(reader.getHeaderLine());
            }
            this.readDataIntoTable(session, this.store, reader, cache.getTextFileSettings());
        }
        catch (Throwable t) {
            long linenumber = reader == null ? 0L : reader.getLineNumber();
            this.store.removeAll();
            if (this.identitySequence != null) {
                this.identitySequence.reset();
            }
            if (cache != null) {
                this.database.logger.textTableManager.closeTextCache(this);
                this.store.release();
            }
            throw Error.error(t, 483, 0, new String[]{String.valueOf(linenumber), t.toString()});
        }
        this.isConnected = true;
        this.isReadOnly = withReadOnlyData;
    }

    private void readDataIntoTable(Session session, PersistentStore store, TextFileReader reader, TextFileSettings settings) {
        Row row;
        RowInputInterface rowIn;
        while ((rowIn = reader.readObject()) != null && (row = (Row)store.get(rowIn)) != null) {
            Object[] data = row.getData();
            this.systemUpdateIdentityValue(data);
            if (settings.isNullDef) {
                this.generateDefaultForNull(data);
            }
            this.enforceRowConstraints(session, data);
            store.indexRow(session, row);
        }
    }

    public void disconnect() {
        this.store = null;
        PersistentStore store = this.database.persistentStoreCollection.getStore(this);
        store.release();
        this.isConnected = false;
    }

    private void openCache(Session session, String dataSourceNew, boolean isReversedNew, boolean isReadOnlyNew) {
        String dataSourceOld = this.dataSource;
        boolean isReversedOld = this.isReversed;
        boolean isReadOnlyOld = this.isReadOnly;
        if (dataSourceNew == null) {
            dataSourceNew = "";
        }
        this.disconnect();
        this.dataSource = dataSourceNew;
        this.isReversed = isReversedNew && this.dataSource.length() > 0;
        try {
            this.connect(session, isReadOnlyNew || isReversedNew);
        }
        catch (HsqlException e) {
            this.dataSource = dataSourceOld;
            this.isReversed = isReversedOld;
            this.connect(session, isReadOnlyOld);
            throw e;
        }
    }

    void setDataSource(Session session, String dataSourceNew, boolean isReversedNew, boolean createFile) {
        if (this.getTableType() != 6) {
            session.getGrantee().checkSchemaUpdateOrGrantRights(this.getSchemaName());
        }
        dataSourceNew = dataSourceNew.trim();
        if (isReversedNew || isReversedNew != this.isReversed || !this.dataSource.equals(dataSourceNew) || !this.isConnected) {
            this.openCache(session, dataSourceNew, isReversedNew, this.isReadOnly);
        }
        if (this.isReversed) {
            this.isReadOnly = true;
        }
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String source, boolean desc) {
        this.dataSource = source;
        this.isReversed = desc;
    }

    public boolean isDescDataSource() {
        return this.isReversed;
    }

    public void setHeader(String header) {
        PersistentStore store = this.database.persistentStoreCollection.getStore(this);
        TextCache cache = (TextCache)store.getCache();
        if (cache != null && cache.isIgnoreFirstLine()) {
            cache.setHeader(header);
            return;
        }
        throw Error.error(486);
    }

    private String getHeader() {
        PersistentStore store = this.database.persistentStoreCollection.getStore(this);
        TextCache cache = (TextCache)store.getCache();
        String header = cache == null ? null : cache.getHeader();
        return header == null ? null : StringConverter.toQuotedString(header, '\'', true);
    }

    @Override
    public void checkDataReadOnly() {
        if (this.dataSource.length() == 0) {
            String name = this.getName().getSchemaQualifiedStatementName();
            throw Error.error(481, name);
        }
        if (this.isDataReadOnly()) {
            throw Error.error(456);
        }
    }

    @Override
    public boolean isDataReadOnly() {
        return !this.isConnected() || super.isDataReadOnly() || this.store.getCache().isDataReadOnly();
    }

    @Override
    public void setDataReadOnly(boolean value) {
        if (!value) {
            if (this.isReversed) {
                throw Error.error(456);
            }
            if (this.database.isFilesReadOnly()) {
                throw Error.error(455);
            }
            if (this.isConnected()) {
                this.store.getCache().close();
                this.store.getCache().open(value);
            }
        }
        this.isReadOnly = value;
    }

    @Override
    public void insertData(Session session, PersistentStore store, Object[] data, boolean enforceUnique) {
        Row row = (Row)store.getNewCachedObject(session, data, false);
        store.indexRow(session, row);
        store.commitPersistence(row);
    }

    String getDataSourceDDL() {
        String dataSource = this.getDataSource();
        if (dataSource == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("SET").append(' ').append("TABLE").append(' ');
        sb.append(this.getName().getSchemaQualifiedStatementName());
        sb.append(' ').append("SOURCE").append(' ').append('\'');
        sb.append(dataSource);
        sb.append('\'');
        return sb.toString();
    }

    String getDataSourceHeader() {
        String header = this.getHeader();
        if (header == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("SET").append(' ').append("TABLE").append(' ');
        sb.append(this.getName().getSchemaQualifiedStatementName());
        sb.append(' ').append("SOURCE").append(' ');
        sb.append("HEADER").append(' ');
        sb.append(header);
        return sb.toString();
    }
}

