/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.error.Error;
import org.hsqldb.persist.PersistentStore;

public class TransactionManager2PL
extends TransactionManagerCommon
implements TransactionManager {
    public TransactionManager2PL(Database db) {
        super(db);
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.txModel = 0;
    }

    @Override
    public long getSystemChangeNumber() {
        return this.systemChangeNumber.get();
    }

    @Override
    public void setSystemChangeNumber(long ts) {
        this.systemChangeNumber.set(ts);
    }

    @Override
    public boolean isMVRows() {
        return false;
    }

    @Override
    public boolean isMVCC() {
        return false;
    }

    @Override
    public boolean is2PL() {
        return true;
    }

    @Override
    public int getTransactionControl() {
        return 0;
    }

    @Override
    public void setTransactionControl(Session session, int mode) {
        super.setTransactionControl(session, mode);
    }

    @Override
    public void completeActions(Session session) {
        this.endActionTPL(session);
    }

    @Override
    public boolean prepareCommitActions(Session session) {
        session.actionSCN = this.getNextSystemChangeNumber();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            int limit = session.rowActionList.size();
            session.transactionEndSCN = session.actionSCN = this.getNextSystemChangeNumber();
            this.endTransaction(session);
            for (int i = 0; i < limit; ++i) {
                RowAction action = (RowAction)session.rowActionList.get(i);
                action.commit(session);
            }
            this.adjustLobUsage(session);
            this.persistCommit(session);
            session.isTransaction = false;
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
        session.tempSet.clear();
        return true;
    }

    @Override
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndSCN = session.actionSCN = this.getNextSystemChangeNumber();
            this.rollbackPartial(session, 0, session.transactionSCN);
            this.endTransaction(session);
            session.logSequences();
            session.isTransaction = false;
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int index) {
        long timestamp = session.sessionContext.savepointTimestamps.get(index);
        Integer oi = (Integer)session.sessionContext.savepoints.get(index);
        int start = oi;
        while (session.sessionContext.savepoints.size() > index + 1) {
            session.sessionContext.savepoints.removeEntry(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, start, timestamp);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionStartSCN);
        this.endActionTPL(session);
    }

    @Override
    public void rollbackPartial(Session session, int start, long timestamp) {
        int limit = session.rowActionList.size();
        if (start == limit) {
            return;
        }
        for (int i = limit - 1; i >= start; --i) {
            RowAction action = (RowAction)session.rowActionList.get(i);
            if (action == null || action.type == 0 || action.type == 3) continue;
            Row row = action.memoryRow;
            if (row == null) {
                row = (Row)action.store.get(action.getPos(), false);
            }
            if (row == null) continue;
            action.rollback(session, timestamp);
            int type = action.mergeRollback(session, timestamp);
            action.store.rollbackRow(session, row, type, this.txModel);
        }
        session.rowActionList.setSize(start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowAction addDeleteAction(Session session, Table table, PersistentStore store, Row row, int[] changedColumns) {
        RowAction action;
        Row row2 = row;
        synchronized (row2) {
            action = RowAction.addDeleteAction(session, table, store, row, changedColumns);
        }
        store.delete(session, row);
        row.rowAction = null;
        if (table.persistenceScope == 20) {
            return action;
        }
        session.rowActionList.add(action);
        return action;
    }

    @Override
    public void addInsertAction(Session session, Table table, PersistentStore store, Row row, int[] changedColumns) {
        RowAction action = row.rowAction;
        if (action == null) {
            throw Error.runtimeError(458, "null insert action ");
        }
        store.indexRow(session, row);
        row.rowAction = null;
        if (table.persistenceScope == 20) {
            return;
        }
        session.rowActionList.add(action);
    }

    @Override
    public void beginTransaction(Session session) {
        if (!session.isTransaction) {
            this.beginTransactionCommon(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginAction(Session session, Statement cs) {
        this.writeLock.lock();
        try {
            if (this.hasExpired) {
                session.redoAction = true;
                return;
            }
            if ((cs = this.updateCurrentStatement(session, cs)) == null) {
                return;
            }
            boolean canProceed = this.setWaitedSessionsTPL(session, cs);
            if (canProceed) {
                session.isPreTransaction = true;
                if (session.tempSet.isEmpty()) {
                    this.lockTablesTPL(session, cs);
                } else {
                    this.setWaitingSessionTPL(session);
                }
            } else {
                session.abortTransaction = true;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void beginActionResume(Session session) {
        if (session.isTransaction) {
            session.actionStartSCN = session.actionSCN = this.getNextSystemChangeNumber();
        } else {
            this.beginTransactionCommon(session);
        }
    }

    public void removeTransactionInfo(long id) {
    }

    @Override
    public void resetSession(Session session, Session targetSession, long statementTimestamp, int mode) {
        super.resetSession(session, targetSession, statementTimestamp, mode);
    }

    private void endTransaction(Session session) {
        if (session.isTransaction) {
            this.transactionCount.decrementAndGet();
        }
    }
}

