/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.persist.PersistentStore;

public class TransactionManagerMV2PL
extends TransactionManagerCommon
implements TransactionManager {
    HsqlDeque committedTransactions = new HsqlDeque();
    LongDeque committedTransactionSCNs = new LongDeque();

    public TransactionManagerMV2PL(Database db) {
        super(db);
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.txModel = 1;
    }

    @Override
    public long getSystemChangeNumber() {
        return this.systemChangeNumber.get();
    }

    @Override
    public void setSystemChangeNumber(long ts) {
        this.systemChangeNumber.set(ts);
    }

    @Override
    public boolean isMVRows() {
        return true;
    }

    @Override
    public boolean isMVCC() {
        return false;
    }

    @Override
    public boolean is2PL() {
        return false;
    }

    @Override
    public int getTransactionControl() {
        return 1;
    }

    @Override
    public void setTransactionControl(Session session, int mode) {
        super.setTransactionControl(session, mode);
    }

    @Override
    public void completeActions(Session session) {
        this.endActionTPL(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareCommitActions(Session session) {
        this.writeLock.lock();
        try {
            int limit = session.rowActionList.size();
            session.actionSCN = this.getNextSystemChangeNumber();
            for (int i = 0; i < limit; ++i) {
                RowAction action = (RowAction)session.rowActionList.get(i);
                action.prepareCommit(session);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            Object[] list;
            int limit = session.rowActionList.size();
            session.transactionEndSCN = session.actionSCN = this.getNextSystemChangeNumber();
            this.endTransaction(session);
            for (int i = 0; i < limit; ++i) {
                RowAction action = (RowAction)session.rowActionList.get(i);
                action.commit(session);
            }
            this.adjustLobUsage(session);
            this.persistCommit(session);
            int newLimit = session.rowActionList.size();
            if (newLimit > limit) {
                list = session.rowActionList.getArray();
                this.mergeTransaction(list, limit, newLimit, session.actionSCN);
                this.finaliseRows(session, list, limit, newLimit);
                session.rowActionList.setSize(limit);
            }
            if (session == this.lobSession || this.getFirstLiveTransactionTimestamp() > session.actionSCN) {
                list = session.rowActionList.getArray();
                this.mergeTransaction(list, 0, limit, session.actionSCN);
                this.finaliseRows(session, list, 0, limit);
            } else {
                list = session.rowActionList.toArray();
                this.addToCommittedQueue(session, list);
            }
            session.isTransaction = false;
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
            session.actionSet.clear();
        }
        return true;
    }

    @Override
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndSCN = session.actionSCN = this.getNextSystemChangeNumber();
            this.rollbackPartial(session, 0, session.transactionSCN);
            this.endTransaction(session);
            session.logSequences();
            session.isTransaction = false;
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int index) {
        long timestamp = session.sessionContext.savepointTimestamps.get(index);
        Integer oi = (Integer)session.sessionContext.savepoints.get(index);
        int start = oi;
        while (session.sessionContext.savepoints.size() > index + 1) {
            session.sessionContext.savepoints.removeEntry(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, start, timestamp);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionStartSCN);
        this.endActionTPL(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackPartial(Session session, int start, long timestamp) {
        int limit = session.rowActionList.size();
        if (start == limit) {
            return;
        }
        for (int i = limit - 1; i >= start; --i) {
            RowAction action = (RowAction)session.rowActionList.get(i);
            if (action == null || action.type == 0 || action.type == 3) continue;
            Row row = action.memoryRow;
            if (row == null) {
                row = (Row)action.store.get(action.getPos(), false);
            }
            if (row == null) continue;
            this.writeLock.lock();
            try {
                action.rollback(session, timestamp);
                int type = action.mergeRollback(session, timestamp);
                if (action.type == 3) {
                    if (action.deleteComplete) continue;
                    action.deleteComplete = true;
                }
                action.store.rollbackRow(session, row, type, this.txModel);
                continue;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        session.rowActionList.setSize(start);
    }

    @Override
    public RowAction addDeleteAction(Session session, Table table, PersistentStore store, Row row, int[] changedColumns) {
        RowAction action = store.addDeleteActionToRow(session, row, changedColumns, true);
        if (table.isTemp) {
            store.delete(session, row);
            row.rowAction = null;
            if (table.persistenceScope == 20) {
                return action;
            }
        }
        session.rowActionList.add(action);
        return action;
    }

    @Override
    public void addInsertAction(Session session, Table table, PersistentStore store, Row row, int[] changedColumns) {
        RowAction action = row.rowAction;
        if (action == null) {
            throw Error.runtimeError(458, "null insert action ");
        }
        store.indexRow(session, row);
        if (table.persistenceScope == 20) {
            row.rowAction = null;
            return;
        }
        session.rowActionList.add(action);
    }

    public boolean canRead(Session session, PersistentStore store, Row row, int mode, int[] colMap) {
        RowAction action = row.rowAction;
        if (action == null) {
            return true;
        }
        if (action.table.isTemp) {
            return true;
        }
        return action.canRead(session, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCommittedQueue(Session session, Object[] list) {
        LongDeque longDeque = this.committedTransactionSCNs;
        synchronized (longDeque) {
            this.committedTransactions.addLast(list);
            this.committedTransactionSCNs.addLast(session.actionSCN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeExpiredTransactions(Session session) {
        long timestamp = this.getFirstLiveTransactionTimestamp();
        while (true) {
            long commitTimestamp = 0L;
            Object[] actions = null;
            LongDeque longDeque = this.committedTransactionSCNs;
            synchronized (longDeque) {
                if (this.committedTransactionSCNs.isEmpty()) {
                    break;
                }
                commitTimestamp = this.committedTransactionSCNs.getFirst();
                if (commitTimestamp >= timestamp) {
                    break;
                }
                this.committedTransactionSCNs.removeFirst();
                actions = (Object[])this.committedTransactions.removeFirst();
            }
            this.mergeTransaction(actions, 0, actions.length, commitTimestamp);
            this.finaliseRows(session, actions, 0, actions.length);
        }
    }

    @Override
    public void beginTransaction(Session session) {
        this.writeLock.lock();
        try {
            if (!session.isTransaction) {
                this.beginTransactionCommon(session);
                this.liveTransactionSCNs.addLast(session.transactionSCN);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginAction(Session session, Statement cs) {
        this.writeLock.lock();
        try {
            if (this.hasExpired) {
                session.redoAction = true;
                return;
            }
            if ((cs = this.updateCurrentStatement(session, cs)) == null) {
                return;
            }
            boolean canProceed = this.setWaitedSessionsTPL(session, cs);
            if (canProceed) {
                session.isPreTransaction = true;
                if (session.tempSet.isEmpty()) {
                    this.lockTablesTPL(session, cs);
                } else {
                    this.setWaitingSessionTPL(session);
                }
            } else {
                session.abortTransaction = true;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void beginActionResume(Session session) {
        this.writeLock.lock();
        try {
            if (session.isTransaction) {
                session.actionStartSCN = session.actionSCN = this.getNextSystemChangeNumber();
            } else {
                this.beginTransactionCommon(session);
                this.liveTransactionSCNs.addLast(session.transactionSCN);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void resetSession(Session session, Session targetSession, long statementTimestamp, int mode) {
        super.resetSession(session, targetSession, statementTimestamp, mode);
    }

    private void endTransaction(Session session) {
        long timestamp = session.transactionSCN;
        int index = this.liveTransactionSCNs.indexOf(timestamp);
        if (index >= 0) {
            this.transactionCount.decrementAndGet();
            this.liveTransactionSCNs.remove(index);
            this.mergeExpiredTransactions(session);
        }
    }
}

