/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.RowActionBase;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.persist.PersistentStore;

public class TransactionManagerMVCC
extends TransactionManagerCommon
implements TransactionManager {
    HsqlDeque committedTransactions = new HsqlDeque();
    LongDeque committedTransactionSCNs = new LongDeque();
    boolean isLockedMode;
    Session catalogWriteSession;
    long lockTxTs;
    long lockSessionId;
    long unlockTxTs;
    long unlockSessionId;
    int redoCount = 0;

    public TransactionManagerMVCC(Database db) {
        super(db);
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.txModel = 2;
    }

    @Override
    public long getSystemChangeNumber() {
        return this.systemChangeNumber.get();
    }

    @Override
    public void setSystemChangeNumber(long ts) {
        this.systemChangeNumber.set(ts);
    }

    @Override
    public boolean isMVRows() {
        return true;
    }

    @Override
    public boolean isMVCC() {
        return true;
    }

    @Override
    public boolean is2PL() {
        return false;
    }

    @Override
    public int getTransactionControl() {
        return 2;
    }

    @Override
    public void setTransactionControl(Session session, int mode) {
        super.setTransactionControl(session, mode);
    }

    @Override
    public void completeActions(Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareCommitActions(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            RowAction action;
            int i;
            int limit = session.rowActionList.size();
            for (i = 0; i < limit; ++i) {
                action = (RowAction)session.rowActionList.get(i);
                if (action.canCommit(session)) continue;
                boolean bl = false;
                return bl;
            }
            session.actionSCN = this.getNextSystemChangeNumber();
            for (i = 0; i < limit; ++i) {
                action = (RowAction)session.rowActionList.get(i);
                action.prepareCommit(session);
            }
            for (i = 0; i < session.actionSet.size(); ++i) {
                Session current = ((RowActionBase)session.actionSet.get((int)i)).session;
                current.abortTransaction = true;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
            session.actionSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            Object[] list;
            RowAction action;
            int i;
            int limit = session.rowActionList.size();
            for (i = 0; i < limit; ++i) {
                action = (RowAction)session.rowActionList.get(i);
                if (action.canCommit(session)) continue;
                boolean bl = false;
                return bl;
            }
            session.transactionEndSCN = session.actionSCN = this.getNextSystemChangeNumber();
            this.endTransaction(session);
            for (i = 0; i < limit; ++i) {
                action = (RowAction)session.rowActionList.get(i);
                action.commit(session);
            }
            for (i = 0; i < session.actionSet.size(); ++i) {
                Session current = ((RowActionBase)session.actionSet.get((int)i)).session;
                current.abortTransaction = true;
            }
            this.adjustLobUsage(session);
            this.persistCommit(session);
            int newLimit = session.rowActionList.size();
            if (newLimit > limit) {
                list = session.rowActionList.getArray();
                this.mergeTransaction(list, limit, newLimit, session.actionSCN);
                this.finaliseRows(session, list, limit, newLimit);
                session.rowActionList.setSize(limit);
            }
            if (session == this.lobSession || this.getFirstLiveTransactionTimestamp() > session.actionSCN) {
                list = session.rowActionList.getArray();
                this.mergeTransaction(list, 0, limit, session.actionSCN);
                this.finaliseRows(session, list, 0, limit);
            } else if (session.rowActionList.size() > 0) {
                list = session.rowActionList.toArray();
                this.addToCommittedQueue(session, list);
            }
            this.endTransactionTPL(session);
            session.isTransaction = false;
            this.countDownLatches(session);
        }
        finally {
            session.actionSet.clear();
            this.writeLock.unlock();
        }
        return true;
    }

    @Override
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndSCN = session.actionSCN = this.getNextSystemChangeNumber();
            this.rollbackPartial(session, 0, session.transactionSCN);
            this.endTransaction(session);
            session.logSequences();
            this.endTransactionTPL(session);
            session.isTransaction = false;
            this.countDownLatches(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int index) {
        long timestamp = session.sessionContext.savepointTimestamps.get(index);
        Integer oi = (Integer)session.sessionContext.savepoints.get(index);
        int start = oi;
        while (session.sessionContext.savepoints.size() > index + 1) {
            session.sessionContext.savepoints.removeEntry(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, start, timestamp);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionStartSCN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackPartial(Session session, int start, long timestamp) {
        int limit = session.rowActionList.size();
        if (start == limit) {
            return;
        }
        for (int i = limit - 1; i >= start; --i) {
            RowAction action = (RowAction)session.rowActionList.get(i);
            if (action == null || action.type == 0 || action.type == 3) continue;
            Row row = action.memoryRow;
            if (row == null) {
                row = (Row)action.store.get(action.getPos(), false);
            }
            if (row == null) continue;
            this.writeLock.lock();
            try {
                action.rollback(session, timestamp);
                int type = action.mergeRollback(session, timestamp);
                if (action.type == 3) {
                    if (action.deleteComplete) continue;
                    action.deleteComplete = true;
                }
                action.store.rollbackRow(session, row, type, this.txModel);
                continue;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        session.rowActionList.setSize(start);
    }

    @Override
    public RowAction addDeleteAction(Session session, Table table, PersistentStore store, Row row, int[] changedColumns) {
        RowAction action = store.addDeleteActionToRow(session, row, changedColumns, true);
        if (table.isTemp) {
            store.delete(session, row);
            row.rowAction = null;
            if (table.persistenceScope == 20) {
                return action;
            }
        }
        Session actionSession = null;
        boolean redoAction = true;
        if (action == null) {
            this.writeLock.lock();
            try {
                this.rollbackAction(session);
                if (session.isolationLevel == 4 || session.isolationLevel == 8) {
                    session.actionSet.clear();
                    session.redoAction = false;
                    session.abortTransaction = session.txConflictRollback;
                    throw Error.error(4871);
                }
                if (row.rowAction != null && row.rowAction.isDeleted()) {
                    session.actionSet.clear();
                    session.redoAction = true;
                    ++this.redoCount;
                    throw Error.error(4871);
                }
                boolean bl = redoAction = !session.actionSet.isEmpty();
                if (redoAction) {
                    actionSession = ((RowActionBase)session.actionSet.get((int)0)).session;
                    session.actionSet.clear();
                    if (actionSession != null) {
                        redoAction = this.checkDeadlock(session, actionSession);
                    }
                }
                if (redoAction) {
                    session.redoAction = true;
                    if (actionSession != null) {
                        actionSession.waitingSessions.add(session);
                        session.waitedSessions.add(actionSession);
                        session.latch.setCount(session.waitedSessions.size());
                    }
                    ++this.redoCount;
                } else {
                    session.redoAction = false;
                    session.abortTransaction = session.txConflictRollback;
                }
                throw Error.error(4871);
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                throw throwable;
            }
        }
        session.rowActionList.add(action);
        return action;
    }

    @Override
    public void addInsertAction(Session session, Table table, PersistentStore store, Row row, int[] changedColumns) {
        RowAction action = row.rowAction;
        Session actionSession = null;
        boolean redoAction = false;
        boolean redoWait = true;
        HsqlException cause = null;
        if (action == null) {
            throw Error.runtimeError(458, "TXManager - null insert action ");
        }
        try {
            store.indexRow(session, row);
        }
        catch (HsqlException e) {
            if (session.actionSet.isEmpty()) {
                throw e;
            }
            redoAction = true;
            cause = e;
        }
        if (!redoAction) {
            if (table.isTemp) {
                row.rowAction = null;
                if (table.persistenceScope == 20) {
                    return;
                }
            }
            session.rowActionList.add(action);
            return;
        }
        this.writeLock.lock();
        try {
            this.rollbackAction(session);
            RowActionBase otherAction = (RowActionBase)session.actionSet.get(0);
            actionSession = otherAction.session;
            session.actionSet.clear();
            if (otherAction.commitSCN != 0L) {
                redoWait = false;
            }
            switch (session.isolationLevel) {
                case 4: 
                case 8: {
                    redoAction = false;
                    break;
                }
                default: {
                    redoAction = this.checkDeadlock(session, actionSession);
                }
            }
            if (redoAction) {
                session.redoAction = true;
                if (redoWait) {
                    actionSession.waitingSessions.add(session);
                    session.waitedSessions.add(actionSession);
                    session.latch.setCount(session.waitedSessions.size());
                }
                ++this.redoCount;
            } else {
                session.abortTransaction = session.txConflictRollback;
                session.redoAction = false;
            }
            throw Error.error(cause, 4871, null);
        }
        catch (Throwable throwable) {
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public boolean canRead(Session session, PersistentStore store, Row row, int mode, int[] colMap) {
        RowAction action = row.rowAction;
        if (action == null) {
            return true;
        }
        if (action.table.isTemp) {
            return true;
        }
        if (mode == 0) {
            return action.canRead(session, 0);
        }
        if (mode == 2) {
            return action.canRead(session, 0);
        }
        return action.canRead(session, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCommittedQueue(Session session, Object[] list) {
        LongDeque longDeque = this.committedTransactionSCNs;
        synchronized (longDeque) {
            this.committedTransactions.addLast(list);
            this.committedTransactionSCNs.addLast(session.actionSCN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeExpiredTransactions(Session session) {
        long timestamp = this.getFirstLiveTransactionTimestamp();
        while (true) {
            Object[] actions;
            long commitTimestamp;
            LongDeque longDeque = this.committedTransactionSCNs;
            synchronized (longDeque) {
                if (this.committedTransactionSCNs.isEmpty()) {
                    break;
                }
                commitTimestamp = this.committedTransactionSCNs.getFirst();
                if (commitTimestamp >= timestamp) {
                    break;
                }
                this.committedTransactionSCNs.removeFirst();
                actions = (Object[])this.committedTransactions.removeFirst();
            }
            this.mergeTransaction(actions, 0, actions.length, commitTimestamp);
            this.finaliseRows(session, actions, 0, actions.length);
        }
    }

    @Override
    public void beginTransaction(Session session) {
        this.writeLock.lock();
        try {
            if (!session.isTransaction) {
                this.beginTransactionCommon(session);
                this.liveTransactionSCNs.addLast(session.transactionSCN);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void beginAction(Session session, Statement cs) {
        if (session.isTransaction) {
            return;
        }
        if (cs == null) {
            return;
        }
        this.writeLock.lock();
        try {
            if (this.hasExpired) {
                session.redoAction = true;
                return;
            }
            if ((cs = this.updateCurrentStatement(session, cs)) == null) {
                return;
            }
            if (session.abortTransaction) {
                return;
            }
            session.isPreTransaction = true;
            if (!this.isLockedMode && !cs.isCatalogLock(this.txModel)) {
                return;
            }
            this.beginActionTPL(session, cs);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void beginActionResume(Session session) {
        this.writeLock.lock();
        try {
            if (session.isTransaction) {
                session.actionStartSCN = session.actionSCN = this.getNextSystemChangeNumber();
            } else {
                this.beginTransactionCommon(session);
                this.liveTransactionSCNs.addLast(session.transactionSCN);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void endTransaction(Session session) {
        long timestamp = session.transactionSCN;
        int index = this.liveTransactionSCNs.indexOf(timestamp);
        if (index >= 0) {
            this.transactionCount.decrementAndGet();
            this.liveTransactionSCNs.remove(index);
            this.mergeExpiredTransactions(session);
        }
    }

    private void countDownLatches(Session session) {
        for (int i = 0; i < session.waitingSessions.size(); ++i) {
            Session current = (Session)session.waitingSessions.get(i);
            current.waitedSessions.remove(session);
            current.latch.setCount(current.waitedSessions.size());
        }
        session.waitedSessions.clear();
        session.waitingSessions.clear();
    }

    @Override
    void endTransactionTPL(Session session) {
        Session current;
        int i;
        if (this.catalogWriteSession != session) {
            return;
        }
        Session nextSession = null;
        for (i = 0; i < session.waitingSessions.size(); ++i) {
            current = (Session)session.waitingSessions.get(i);
            Statement st = current.sessionContext.currentStatement;
            if (st == null || !st.isCatalogLock(this.txModel)) continue;
            nextSession = current;
            break;
        }
        if (nextSession == null) {
            this.catalogWriteSession = null;
            this.isLockedMode = false;
        } else {
            for (i = 0; i < session.waitingSessions.size(); ++i) {
                current = (Session)session.waitingSessions.get(i);
                if (current == nextSession) continue;
                current.waitedSessions.add(nextSession);
                nextSession.waitingSessions.add(current);
                current.latch.setCount(current.waitedSessions.size());
            }
            this.catalogWriteSession = nextSession;
        }
        this.unlockTxTs = session.actionSCN;
        this.unlockSessionId = session.getId();
    }

    boolean beginActionTPL(Session session, Statement cs) {
        if (session == this.catalogWriteSession) {
            return true;
        }
        session.tempSet.clear();
        if (cs.isCatalogLock(this.txModel) && this.catalogWriteSession == null) {
            this.catalogWriteSession = session;
            this.isLockedMode = true;
            this.lockTxTs = session.actionSCN;
            this.lockSessionId = session.getId();
            this.getTransactionAndPreSessions(session);
            if (!session.tempSet.isEmpty()) {
                session.waitedSessions.addAll(session.tempSet);
                this.setWaitingSessionTPL(session);
            }
            return true;
        }
        if (!this.isLockedMode) {
            return true;
        }
        if (cs.getTableNamesForWrite().length > 0 ? cs.getTableNamesForWrite()[0].schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME : cs.getTableNamesForRead().length > 0 && cs.getTableNamesForRead()[0].schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME) {
            return true;
        }
        if (session.waitingSessions.contains(this.catalogWriteSession)) {
            return true;
        }
        if (this.catalogWriteSession.waitingSessions.add(session)) {
            session.waitedSessions.add(this.catalogWriteSession);
            session.latch.setCount(session.waitedSessions.size());
        }
        return true;
    }

    @Override
    public void resetSession(Session session, Session targetSession, long statementTimestamp, int mode) {
        super.resetSession(session, targetSession, statementTimestamp, mode);
    }
}

