/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.auth;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import org.hsqldb.auth.AuthBeanMultiplexer;
import org.hsqldb.auth.DenyException;
import org.hsqldb.auth.LdapAuthBean;

public class LdapAuthBeanTester {
    public static void main(String[] sa) throws IOException {
        if (sa.length != 3) {
            throw new IllegalArgumentException("SYNTAX:  java " + AuthBeanMultiplexer.class.getName() + " path/to/file.properties <USERNAME> <PASSWORD>");
        }
        File file = new File(sa[0]);
        if (!file.isFile()) {
            throw new IllegalArgumentException("Not a file: " + file.getAbsolutePath());
        }
        Properties p = new Properties();
        p.load(new FileInputStream(file));
        String trustStore = p.getProperty("trustStore");
        String startTlsString = p.getProperty("startTls");
        String ldapPortString = p.getProperty("ldapPort");
        String roleSchemaValuePatternString = p.getProperty("roleSchemaValuePattern");
        String accessValuePatternString = p.getProperty("accessValuePattern");
        String securityMechanism = p.getProperty("securityMechanism");
        String ldapHost = p.getProperty("ldapHost");
        String principalTemplate = p.getProperty("principalTemplate");
        String initialContextFactory = p.getProperty("initialContextFactory");
        String saslRealm = p.getProperty("saslRealm");
        String parentDn = p.getProperty("parentDn");
        String rdnAttribute = p.getProperty("rdnAttribute");
        String rolesSchemaAttribute = p.getProperty("rolesSchemaAttribute");
        String accessAttribute = p.getProperty("accessAttribute");
        if (trustStore != null) {
            if (!new File(trustStore).isFile()) {
                throw new IllegalArgumentException("Specified trust store is not a file: " + trustStore);
            }
            System.setProperty("javax.net.ssl.trustStore", trustStore);
        }
        LdapAuthBean bean = new LdapAuthBean();
        if (startTlsString != null) {
            bean.setStartTls(Boolean.parseBoolean(startTlsString));
        }
        if (ldapPortString != null) {
            bean.setLdapPort(Integer.parseInt(ldapPortString));
        }
        if (roleSchemaValuePatternString != null) {
            bean.setRoleSchemaValuePatternString(roleSchemaValuePatternString);
        }
        if (accessValuePatternString != null) {
            bean.setAccessValuePatternString(accessValuePatternString);
        }
        if (securityMechanism != null) {
            bean.setSecurityMechanism(securityMechanism);
        }
        if (ldapHost != null) {
            bean.setLdapHost(ldapHost);
        }
        if (principalTemplate != null) {
            bean.setPrincipalTemplate(principalTemplate);
        }
        if (initialContextFactory != null) {
            bean.setInitialContextFactory(initialContextFactory);
        }
        if (saslRealm != null) {
            bean.setSaslRealm(saslRealm);
        }
        if (parentDn != null) {
            bean.setParentDn(parentDn);
        }
        if (rdnAttribute != null) {
            bean.setRdnAttribute(rdnAttribute);
        }
        if (rolesSchemaAttribute != null) {
            bean.setRolesSchemaAttribute(rolesSchemaAttribute);
        }
        if (accessAttribute != null) {
            bean.setAccessAttribute(accessAttribute);
        }
        bean.init();
        Object[] res = null;
        try {
            res = bean.authenticate(sa[1], sa[2]);
        }
        catch (DenyException de) {
            System.out.println("<DENY ACCESS>");
            return;
        }
        if (res == null) {
            System.out.println("<ALLOW ACCESS w/ local Roles+Schema>");
        } else {
            System.out.println(Integer.toString(res.length) + " Roles/Schema: " + Arrays.toString(res));
        }
    }
}

