/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.index;

import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.index.IndexStats;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.index.NodeAVLDisk;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.OrderedLongHashSet;
import org.hsqldb.map.BitMap;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowInputBinary;

public class IndexAVLCheck {
    public static Result checkAllTables(Session session, int type) {
        Result result = IndexStats.newEmptyResult();
        HsqlArrayList allTables = session.database.schemaManager.getAllTables(true);
        int tableCount = allTables.size();
        for (int i = 0; i < tableCount; ++i) {
            Table table = (Table)allTables.get(i);
            if (!table.isCached()) continue;
            IndexAVLCheck.checkTable(session, table, result, type);
        }
        return result;
    }

    public static Result checkTable(Session session, Table table, int type) {
        Result result = IndexStats.newEmptyResult();
        if (!table.isCached()) {
            return result;
        }
        IndexAVLCheck.checkTable(session, table, result, type);
        return result;
    }

    public static void checkTable(Session session, Table table, Result result, int type) {
        RowStoreAVL tableStore = (RowStoreAVL)table.database.persistentStoreCollection.getStore(table);
        IndexStats[] statList = tableStore.checkIndexes(session, type);
        statList[0].addTableStats(result);
        for (int j = 0; j < statList.length; ++j) {
            statList[j].addStats(result);
        }
        if (type == 8) {
            int j;
            boolean hasErrors = false;
            for (j = 0; j < statList.length; ++j) {
                if (!statList[j].hasErrors) continue;
                hasErrors = true;
            }
            if (hasErrors) {
                IndexAVLCheck.reindexTable(session, table, tableStore, statList);
                for (j = 0; j < statList.length; ++j) {
                    if (!statList[j].reindexed) continue;
                    statList[j].addReindexedStats(result);
                }
            }
        }
    }

    public static void reindexTable(Session session, Table table, PersistentStore store, IndexStats[] indexStats) {
        int i;
        Index readIndex = null;
        boolean reindex = false;
        for (i = 0; i < indexStats.length; ++i) {
            if (indexStats[i].hasErrors) continue;
            readIndex = table.getIndex(i);
            break;
        }
        if (readIndex == null) {
            session.database.logger.logSevereEvent("could not recreate damaged indexes for table: " + table.getName().statementName, null);
            return;
        }
        for (i = 0; i < indexStats.length; ++i) {
            if (!indexStats[i].hasErrors) continue;
            Index index = table.getIndex(i);
            store.reindex(session, index, readIndex);
            indexStats[i].reindexed = true;
            reindex = true;
        }
        if (reindex) {
            session.database.logger.logSevereEvent("recreated damaged indexes for table: " + table.getName().statementName, null);
        }
    }

    public static class IndexAVLProbe {
        static final int maxDepth = 16;
        final int fileBlockItemCount;
        final int cacheScale;
        final Session session;
        final PersistentStore store;
        final IndexAVL index;
        final NodeAVLDisk rootNode;
        IntKeyHashMap bitMaps;
        IntKeyHashMap bitMapsPos;
        OrderedLongHashSet badRows;
        OrderedLongHashSet loopedRows;
        OrderedLongHashSet ignoreRows;
        HsqlArrayList unorderedRows = new HsqlArrayList();
        int branchPosition;
        int leafPosition;
        long errorRowCount;
        long rowCount;
        long loopCount;
        boolean printErrors = false;

        public IndexAVLProbe(Session session, PersistentStore store, IndexAVL index, NodeAVL rootNode) {
            DataFileCache cache = store.getCache();
            this.fileBlockItemCount = cache == null ? 0 : store.getCache().spaceManager.getFileBlockItemCount();
            this.cacheScale = cache == null ? 0 : store.getCache().getDataFileScale();
            this.session = session;
            this.store = store;
            this.index = index;
            this.rootNode = cache == null ? null : (NodeAVLDisk)rootNode;
        }

        public IndexStats getStats() {
            IndexStats stats = new IndexStats();
            stats.index = this.index;
            stats.store = this.store;
            stats.errorCount = this.errorRowCount;
            stats.loopCount = this.loopCount;
            stats.goodRowCount = this.rowCount;
            stats.unorderedList = this.unorderedRows;
            stats.hasErrors = this.hasErrors();
            return stats;
        }

        public boolean hasErrors() {
            return this.errorRowCount != 0L || this.loopCount != 0L || !this.unorderedRows.isEmpty();
        }

        public void probe() {
            if (this.index == null) {
                return;
            }
            if (this.rootNode == null) {
                return;
            }
            if (this.fileBlockItemCount == 0) {
                return;
            }
            this.bitMaps = new IntKeyHashMap();
            this.bitMapsPos = new IntKeyHashMap();
            this.badRows = new OrderedLongHashSet();
            this.loopedRows = new OrderedLongHashSet();
            this.ignoreRows = new OrderedLongHashSet();
            this.unorderedRows = new HsqlArrayList();
            RowAVL row = this.rootNode.getRow(this.store);
            this.setSpaceForRow(row);
            this.getNodesFrom(0, this.rootNode, true);
            if (!this.hasErrors()) {
                this.checkIndexOrder();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkIndexOrder() {
            int errors = 0;
            this.store.readLock();
            try {
                NodeAVL p;
                NodeAVL f = null;
                for (p = this.index.getAccessor(this.store); p != null; p = p.getLeft(this.store)) {
                    f = p;
                }
                p = f;
                while (f != null) {
                    int c;
                    errors += this.checkNodes(f, this.unorderedRows);
                    NodeAVL fnext = this.index.next(this.store, f);
                    if (fnext != null && (c = this.index.compareRowForInsertOrDelete(this.session, fnext.getRow(this.store), f.getRow(this.store), true, 0)) <= 0) {
                        if (errors < 10) {
                            this.unorderedRows.add("broken index order ");
                        }
                        ++errors;
                    }
                    f = fnext;
                }
            }
            finally {
                this.store.readUnlock();
            }
        }

        int checkNodes(NodeAVL p, HsqlArrayList list) {
            NodeAVLDisk l = (NodeAVLDisk)p.getLeft(this.store);
            NodeAVLDisk r = (NodeAVLDisk)p.getRight(this.store);
            int errors = 0;
            if (l != null && l.iBalance == -2) {
                list.add("broken index - deleted");
                ++errors;
            }
            if (r != null && r.iBalance == -2) {
                list.add("broken index -deleted");
                ++errors;
            }
            if (l != null && p.getPos() != l.getParentPos()) {
                list.add("broken index - no parent");
                ++errors;
            }
            if (r != null && p.getPos() != r.getParentPos()) {
                list.add("broken index - no parent");
                ++errors;
            }
            return errors;
        }

        public TableBase getCurrentTable() {
            return this.index.getTable();
        }

        public long getErrorCount() {
            return this.errorRowCount;
        }

        public IntKeyHashMap getBitMaps() {
            return this.bitMaps;
        }

        public OrderedLongHashSet getBadRowPosList() {
            return this.badRows;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getNodesFrom(int depth, NodeAVLDisk node, boolean include) {
            NodeAVLDisk next;
            if (node == null) {
                return;
            }
            long pos = node.getPos();
            if (!this.recordRowPos(pos)) {
                this.loopedRows.add(pos);
                return;
            }
            ++this.rowCount;
            if (!include) {
                this.ignoreRows.add(pos);
            }
            long leftPos = node.getLeftPos();
            try {
                if (this.badRows.contains(leftPos)) {
                    return;
                }
                NodeAVLDisk next2 = (NodeAVLDisk)node.getLeft(this.store);
                if (next2 != null) {
                    RowAVL row = next2.getRow(this.store);
                    if (this.setSpaceForRow(row)) {
                        this.getNodesFrom(depth + 1, next2, true);
                        if (next2.getParentPos() != pos) {
                            NodeAVLDisk parentNode = (NodeAVLDisk)node.getParent(this.store);
                            ++this.loopCount;
                        }
                    } else {
                        this.badRows.add(leftPos);
                    }
                }
            }
            catch (HsqlException e) {
                RowInputBinary rowIn = (RowInputBinary)e.info;
                if (rowIn != null) {
                    rowIn.ignoreDataErrors = true;
                    try {
                        next = (NodeAVLDisk)node.getLeft(this.store);
                        this.getNodesFrom(depth + 1, next, false);
                    }
                    catch (Throwable t) {
                        this.badRows.add((int)leftPos);
                    }
                    finally {
                        rowIn.ignoreDataErrors = false;
                    }
                }
                ++this.errorRowCount;
            }
            catch (Throwable t) {
                ++this.errorRowCount;
            }
            long rightPos = node.getRightPos();
            try {
                if (this.badRows.contains(rightPos)) {
                    return;
                }
                next = (NodeAVLDisk)node.getRight(this.store);
                if (next != null) {
                    RowAVL row = next.getRow(this.store);
                    if (this.setSpaceForRow(row)) {
                        this.getNodesFrom(depth + 1, next, true);
                        if (next.getParentPos() != pos) {
                            NodeAVLDisk parentNode = (NodeAVLDisk)node.getParent(this.store);
                            ++this.loopCount;
                        }
                    } else {
                        this.badRows.add(rightPos);
                    }
                }
            }
            catch (HsqlException e) {
                RowInputBinary rowIn = (RowInputBinary)e.info;
                if (rowIn != null) {
                    rowIn.ignoreDataErrors = true;
                    try {
                        NodeAVLDisk next3 = (NodeAVLDisk)node.getRight(this.store);
                        this.getNodesFrom(depth + 1, next3, false);
                    }
                    catch (Throwable t) {
                        this.badRows.add(rightPos);
                    }
                    finally {
                        rowIn.ignoreDataErrors = false;
                    }
                }
                ++this.errorRowCount;
            }
            catch (Throwable t) {
                ++this.errorRowCount;
            }
        }

        boolean setSpaceForRow(Row object) {
            long position = object.getPos();
            int units = object.getStorageSize() / this.cacheScale;
            boolean result = true;
            while (units > 0) {
                BitMap bitMap;
                int countSet;
                int blockIndex = (int)(position / (long)this.fileBlockItemCount);
                int blockOffset = (int)(position % (long)this.fileBlockItemCount);
                int currentUnits = this.fileBlockItemCount - blockOffset;
                if (currentUnits > units) {
                    currentUnits = units;
                }
                if ((countSet = (bitMap = this.getBitMap(blockIndex)).countSet(blockOffset, currentUnits)) > 0) {
                    if (this.printErrors) {
                        System.out.println("index scan - row duplicate in file block " + blockIndex + " offset " + blockOffset);
                    }
                    result = false;
                } else {
                    bitMap.setRange(blockOffset, currentUnits);
                }
                units -= currentUnits;
                position += (long)currentUnits;
            }
            return result;
        }

        BitMap getBitMap(int blockIndex) {
            BitMap bitMap = (BitMap)this.bitMaps.get(blockIndex);
            if (bitMap == null) {
                bitMap = new BitMap(new int[this.fileBlockItemCount / 32]);
                this.bitMaps.put(blockIndex, bitMap);
            }
            return bitMap;
        }

        boolean recordRowPos(long position) {
            int blockIndex = (int)(position / (long)this.fileBlockItemCount);
            int blockOffset = (int)(position % (long)this.fileBlockItemCount);
            BitMap bitMap = this.getPosSet(blockIndex);
            if (bitMap.isSet(blockOffset)) {
                return false;
            }
            bitMap.set(blockOffset);
            return true;
        }

        BitMap getPosSet(int blockIndex) {
            BitMap bitMap = (BitMap)this.bitMapsPos.get(blockIndex);
            if (bitMap == null) {
                bitMap = new BitMap(new int[this.fileBlockItemCount / 32]);
                this.bitMapsPos.put(blockIndex, bitMap);
            }
            return bitMap;
        }
    }
}

