/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.index;

import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.Table;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class NodeAVLDiskLarge
extends NodeAVL {
    private long iLeft = -1L;
    private long iRight = -1L;
    private long iParent = -1L;
    private int iId;
    public static final int SIZE_IN_BYTE = 16;

    public NodeAVLDiskLarge(RowAVLDisk r, RowInputInterface in, int id) {
        super(r);
        this.iId = id;
        int ext = in.readInt();
        this.iBalance = (byte)ext;
        this.iLeft = (long)in.readInt() & 0xFFFFFFFFL;
        this.iRight = (long)in.readInt() & 0xFFFFFFFFL;
        this.iParent = (long)in.readInt() & 0xFFFFFFFFL;
        if (ext > 255) {
            this.iParent |= (long)ext << 8 & 0xFF00000000L;
            this.iLeft |= (long)ext << 16 & 0xFF00000000L;
            this.iRight |= (long)ext << 24 & 0xFF00000000L;
        }
        if (this.iLeft == 0L) {
            this.iLeft = -1L;
        }
        if (this.iRight == 0L) {
            this.iRight = -1L;
        }
        if (this.iParent == 0L) {
            this.iParent = -1L;
        }
    }

    public NodeAVLDiskLarge(RowAVLDisk r, int id) {
        super(r);
        this.iId = id;
    }

    @Override
    public void delete() {
        this.iLeft = -1L;
        this.iRight = -1L;
        this.iParent = -1L;
        this.iBalance = 0;
        ((RowAVLDisk)this.row).setNodesChanged();
    }

    @Override
    public boolean isInMemory() {
        return this.row.isInMemory();
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public long getPos() {
        return this.row.getPos();
    }

    @Override
    public RowAVL getRow(PersistentStore store) {
        return (RowAVLDisk)store.get((CachedObject)this.row, false);
    }

    @Override
    public Object[] getData(PersistentStore store) {
        return this.row.getData();
    }

    private NodeAVLDiskLarge findNode(PersistentStore store) {
        if (this.row.isInMemory()) {
            return this;
        }
        RowAVLDisk r = (RowAVLDisk)store.get(this.row.getPos(), false);
        if (r == null) {
            String tableName = "";
            if (this.row.getTable().getTableType() == 5) {
                tableName = ((Table)this.row.getTable()).getName().name;
            }
            store.getCache().logSevereEvent(tableName + " NodeAVLDiskLarge " + this.row.getPos(), null);
            return this;
        }
        return (NodeAVLDiskLarge)r.getNode(this.iId);
    }

    private NodeAVLDiskLarge findNode(PersistentStore store, long pos) {
        NodeAVLDiskLarge ret = null;
        RowAVLDisk r = (RowAVLDisk)store.get(pos, false);
        if (r != null) {
            ret = (NodeAVLDiskLarge)r.getNode(this.iId);
        }
        return ret;
    }

    @Override
    boolean isLeft(PersistentStore store, NodeAVL n) {
        NodeAVLDiskLarge node = this.findNode(store);
        if (n == null) {
            return node.iLeft == -1L;
        }
        return node.iLeft == n.getPos();
    }

    @Override
    boolean isRight(PersistentStore store, NodeAVL n) {
        NodeAVLDiskLarge node = this.findNode(store);
        if (n == null) {
            return node.iRight == -1L;
        }
        return node.iRight == n.getPos();
    }

    @Override
    NodeAVL getLeft(PersistentStore store) {
        NodeAVLDiskLarge node = this.findNode(store);
        if (node.iLeft == -1L) {
            return null;
        }
        return this.findNode(store, node.iLeft);
    }

    @Override
    NodeAVL getRight(PersistentStore store) {
        NodeAVLDiskLarge node = this.findNode(store);
        if (node.iRight == -1L) {
            return null;
        }
        return this.findNode(store, node.iRight);
    }

    @Override
    NodeAVL getParent(PersistentStore store) {
        NodeAVLDiskLarge node = this.findNode(store);
        if (node.iParent == -1L) {
            return null;
        }
        return this.findNode(store, this.iParent);
    }

    @Override
    public int getBalance(PersistentStore store) {
        NodeAVLDiskLarge node = this.findNode(store);
        return node.iBalance;
    }

    @Override
    boolean isRoot(PersistentStore store) {
        NodeAVLDiskLarge node = this.findNode(store);
        return node.iParent == -1L;
    }

    @Override
    boolean isFromLeft(PersistentStore store) {
        NodeAVLDiskLarge node = this.findNode(store);
        if (node.iParent == -1L) {
            return true;
        }
        NodeAVLDiskLarge temp = this.findNode(store, this.iParent);
        return this.row.getPos() == temp.iLeft;
    }

    @Override
    public NodeAVL child(PersistentStore store, boolean isleft) {
        return isleft ? this.getLeft(store) : this.getRight(store);
    }

    @Override
    NodeAVL setParent(PersistentStore store, NodeAVL n) {
        RowAVLDisk row = (RowAVLDisk)store.get((CachedObject)this.row, true);
        NodeAVLDiskLarge node = (NodeAVLDiskLarge)row.getNode(this.iId);
        row.setNodesChanged();
        node.iParent = n == null ? -1L : n.getPos();
        row.keepInMemory(false);
        return node;
    }

    @Override
    public NodeAVL setBalance(PersistentStore store, int b) {
        RowAVLDisk row = (RowAVLDisk)store.get((CachedObject)this.row, true);
        NodeAVLDiskLarge node = (NodeAVLDiskLarge)row.getNode(this.iId);
        row.setNodesChanged();
        node.iBalance = b;
        row.keepInMemory(false);
        return node;
    }

    @Override
    NodeAVL setLeft(PersistentStore store, NodeAVL n) {
        RowAVLDisk row = (RowAVLDisk)store.get((CachedObject)this.row, true);
        NodeAVLDiskLarge node = (NodeAVLDiskLarge)row.getNode(this.iId);
        node.iLeft = n == null ? -1L : n.getPos();
        row.setNodesChanged();
        row.keepInMemory(false);
        return node;
    }

    @Override
    NodeAVL setRight(PersistentStore store, NodeAVL n) {
        RowAVLDisk row = (RowAVLDisk)store.get((CachedObject)this.row, true);
        NodeAVLDiskLarge node = (NodeAVLDiskLarge)row.getNode(this.iId);
        node.iRight = n == null ? -1L : n.getPos();
        row.setNodesChanged();
        row.keepInMemory(false);
        return node;
    }

    @Override
    public NodeAVL set(PersistentStore store, boolean isLeft, NodeAVL n) {
        NodeAVL x = isLeft ? this.setLeft(store, n) : this.setRight(store, n);
        if (n != null) {
            n.setParent(store, x);
        }
        return x;
    }

    @Override
    public void replace(PersistentStore store, Index index, NodeAVL n) {
        NodeAVLDiskLarge node = this.findNode(store);
        if (node.iParent == -1L) {
            if (n != null) {
                n = n.setParent(store, null);
            }
            store.setAccessor(index, n);
        } else {
            boolean isFromLeft = node.isFromLeft(store);
            node.getParent(store).set(store, isFromLeft, n);
        }
    }

    @Override
    boolean equals(NodeAVL n) {
        if (n instanceof NodeAVLDiskLarge) {
            return this == n || this.row.getPos() == n.getPos();
        }
        return false;
    }

    @Override
    public int getRealSize(RowOutputInterface out) {
        return 16;
    }

    @Override
    public void setInMemory(boolean in) {
    }

    @Override
    public void write(RowOutputInterface out) {
        this.write(out, null);
    }

    @Override
    public void write(RowOutputInterface out, LongLookup lookup) {
        long leftTemp = NodeAVLDiskLarge.getTranslatePointer(this.iLeft, lookup);
        long rightTemp = NodeAVLDiskLarge.getTranslatePointer(this.iRight, lookup);
        long parentTemp = NodeAVLDiskLarge.getTranslatePointer(this.iParent, lookup);
        int ext = 0;
        ext |= (int)((parentTemp & 0xFF00000000L) >> 8);
        ext |= (int)((leftTemp & 0xFF00000000L) >> 16);
        ext = (ext |= (int)((rightTemp & 0xFF00000000L) >> 24)) == 0 ? this.iBalance : (ext |= this.iBalance & 0xFF);
        out.writeInt(ext);
        out.writeInt((int)leftTemp);
        out.writeInt((int)rightTemp);
        out.writeInt((int)parentTemp);
    }

    private static long getTranslatePointer(long pointer, LongLookup lookup) {
        long newPointer = 0L;
        if (pointer != -1L) {
            newPointer = lookup == null ? pointer : lookup.lookup(pointer);
        }
        return newPointer;
    }

    @Override
    public void restore() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void updateAccessCount(int count) {
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public void setStorageSize(int size) {
    }

    @Override
    public int getStorageSize() {
        return 0;
    }

    @Override
    public void setPos(long pos) {
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public void setChanged(boolean flag) {
    }

    @Override
    public boolean isKeepInMemory() {
        return false;
    }

    @Override
    public boolean keepInMemory(boolean keep) {
        return false;
    }
}

