/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.KMPSearchAlgorithm;
import org.hsqldb.lib.java.JavaSystem;

public class JDBCBlob
implements Blob {
    private static final long MIN_POS = 1L;
    private static final long MAX_POS = 0x80000000L;
    private static final byte[] NO_BYTES = new byte[0];
    private boolean m_closed;
    private byte[] m_data;
    private final boolean m_createdByConnection;

    @Override
    public long length() throws SQLException {
        return this.getData().length;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        byte[] data = this.getData();
        int dlen = data.length;
        if (pos < 1L || pos - 1L > (long)dlen) {
            throw JDBCUtil.outOfRangeArgument("pos: " + pos);
        }
        int index = (int)pos - 1;
        if (length < 0 || length > dlen - index) {
            throw JDBCUtil.outOfRangeArgument("length: " + length);
        }
        byte[] result = new byte[length];
        System.arraycopy(data, index, result, 0, length);
        return result;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.getData());
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        byte[] data = this.getData();
        int dlen = data.length;
        if (start < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + start);
        }
        if (start > (long)dlen || pattern == null) {
            return -1L;
        }
        int startIndex = (int)start - 1;
        int plen = pattern.length;
        if (plen == 0 || startIndex > dlen - plen) {
            return -1L;
        }
        int result = KMPSearchAlgorithm.search(data, pattern, KMPSearchAlgorithm.computeTable(pattern), startIndex);
        return result == -1 ? -1L : (long)(result + 1);
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        byte[] data = this.getData();
        int dlen = data.length;
        if (start < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + start);
        }
        if (start > (long)dlen || pattern == null) {
            return -1L;
        }
        int startIndex = (int)(start - 1L);
        long plen = pattern.length();
        if (plen == 0L || (long)startIndex > (long)dlen - plen) {
            return -1L;
        }
        int iplen = (int)plen;
        byte[] bytePattern = pattern instanceof JDBCBlob ? ((JDBCBlob)pattern).data() : pattern.getBytes(1L, iplen);
        int result = KMPSearchAlgorithm.search(data, bytePattern, KMPSearchAlgorithm.computeTable(bytePattern), startIndex);
        return result == -1 ? -1L : (long)(result + 1);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes == null ? 0 : bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkReadonly();
        if (bytes == null) {
            throw JDBCUtil.nullArgument("bytes");
        }
        if (offset < 0 || offset > bytes.length) {
            throw JDBCUtil.outOfRangeArgument("offset: " + offset);
        }
        if (len > bytes.length - offset) {
            throw JDBCUtil.outOfRangeArgument("len: " + len);
        }
        if (pos < 1L || pos - 1L > (long)(Integer.MAX_VALUE - len)) {
            throw JDBCUtil.outOfRangeArgument("pos: " + pos);
        }
        int index = (int)(pos - 1L);
        byte[] data = this.getData();
        int dlen = data.length;
        if (index > dlen - len) {
            byte[] temp = new byte[index + len];
            System.arraycopy(data, 0, temp, 0, dlen);
            data = temp;
            temp = null;
        }
        System.arraycopy(bytes, offset, data, index, len);
        this.setData(data);
        return len;
    }

    @Override
    public OutputStream setBinaryStream(final long pos) throws SQLException {
        this.checkReadonly();
        if (pos < 1L || pos > 0x80000000L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + pos);
        }
        this.checkClosed();
        return new ByteArrayOutputStream(){
            private boolean closed;

            @Override
            public synchronized void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                byte[] bytes = this.buf;
                int length = this.count;
                this.buf = NO_BYTES;
                this.count = 0;
                try {
                    JDBCBlob.this.setBytes(pos, bytes, 0, length);
                }
                catch (SQLException se) {
                    throw JavaSystem.toIOException(se);
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.checkReadonly();
        byte[] data = this.getData();
        if (len < 0L || len > (long)data.length) {
            throw JDBCUtil.outOfRangeArgument("len: " + len);
        }
        if (len == (long)data.length) {
            return;
        }
        byte[] newData = new byte[(int)len];
        System.arraycopy(data, 0, newData, 0, (int)len);
        this.setData(newData);
    }

    @Override
    public synchronized void free() throws SQLException {
        this.m_closed = true;
        this.m_data = null;
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        byte[] data = this.getData();
        int dlen = data.length;
        if (pos < 1L || pos > (long)dlen) {
            throw JDBCUtil.outOfRangeArgument("pos: " + pos);
        }
        int index = (int)(pos - 1L);
        if (length < 0L || length > (long)(dlen - index)) {
            throw JDBCUtil.outOfRangeArgument("length: " + length);
        }
        if (index == 0 && length == (long)dlen) {
            return new ByteArrayInputStream(data);
        }
        int ilength = (int)length;
        byte[] result = new byte[ilength];
        System.arraycopy(data, index, result, 0, ilength);
        return new ByteArrayInputStream(result);
    }

    public JDBCBlob(byte[] data) throws SQLException {
        if (data == null) {
            throw JDBCUtil.nullArgument("data");
        }
        this.m_data = data;
        this.m_createdByConnection = false;
    }

    protected JDBCBlob() {
        this.m_data = new byte[0];
        this.m_createdByConnection = true;
    }

    protected void checkReadonly() throws SQLException {
        if (!this.m_createdByConnection) {
            throw JDBCUtil.sqlException(3706, "Blob is read-only");
        }
    }

    protected synchronized void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    protected byte[] data() throws SQLException {
        return this.getData();
    }

    private synchronized byte[] getData() throws SQLException {
        this.checkClosed();
        return this.m_data;
    }

    private synchronized void setData(byte[] data) throws SQLException {
        this.checkClosed();
        this.m_data = data;
    }
}

