/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.BlobInputStream;

public class JDBCBlobClient
implements Blob {
    BlobDataID originalBlob;
    BlobDataID blob;
    SessionInterface session;
    int colIndex;
    private boolean isClosed;
    private boolean isWritable;
    JDBCResultSet resultSet;

    @Override
    public synchronized long length() throws SQLException {
        this.checkClosed();
        try {
            return this.blob.length(this.session);
        }
        catch (HsqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized byte[] getBytes(long pos, int length) throws SQLException {
        this.checkClosed();
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, pos - 1L, length)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            return this.blob.getBytes(this.session, pos - 1L, length);
        }
        catch (HsqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        this.checkClosed();
        return new BlobInputStream(this.session, this.blob, 0L, this.length());
    }

    @Override
    public synchronized long position(byte[] pattern, long start) throws SQLException {
        this.checkClosed();
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, start - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            long position = this.blob.position(this.session, pattern, start - 1L);
            if (position >= 0L) {
                ++position;
            }
            return position;
        }
        catch (HsqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized long position(Blob pattern, long start) throws SQLException {
        this.checkClosed();
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, start - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (pattern instanceof JDBCBlobClient) {
            BlobDataID searchClob = ((JDBCBlobClient)pattern).blob;
            try {
                long position = this.blob.position(this.session, searchClob, start - 1L);
                if (position >= 0L) {
                    ++position;
                }
                return position;
            }
            catch (HsqlException e) {
                throw JDBCUtil.sqlException(e);
            }
        }
        if (!JDBCBlobClient.isInLimits(Integer.MAX_VALUE, 0L, pattern.length())) {
            throw JDBCUtil.outOfRangeArgument();
        }
        byte[] bytePattern = pattern.getBytes(1L, (int)pattern.length());
        return this.position(bytePattern, start);
    }

    @Override
    public synchronized int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public synchronized int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkClosed();
        if (!JDBCBlobClient.isInLimits(bytes.length, offset, len)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, pos - 1L, len)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (!this.isWritable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        try {
            this.startUpdate();
            this.blob.setBytes(this.session, pos - 1L, bytes, offset, len);
            return len;
        }
        catch (HsqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized OutputStream setBinaryStream(long pos) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void truncate(long len) throws SQLException {
        this.checkClosed();
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, 0L, len)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            this.blob.truncate(this.session, len);
        }
        catch (HsqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized void free() throws SQLException {
        this.isClosed = true;
    }

    @Override
    public synchronized InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkClosed();
        if (!JDBCBlobClient.isInLimits(this.length(), pos - 1L, length)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        return new BlobInputStream(this.session, this.blob, pos - 1L, length);
    }

    public JDBCBlobClient(SessionInterface session, BlobDataID blob) {
        this.session = session;
        this.blob = blob;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public BlobDataID getBlob() {
        return this.blob;
    }

    public synchronized void setWritable(JDBCResultSet result, int index) {
        this.isWritable = true;
        this.resultSet = result;
        this.colIndex = index;
    }

    public synchronized void clearUpdates() {
        if (this.originalBlob != null) {
            this.blob = this.originalBlob;
            this.originalBlob = null;
        }
    }

    private void startUpdate() throws SQLException {
        if (this.originalBlob != null) {
            return;
        }
        this.originalBlob = this.blob;
        this.blob = (BlobDataID)this.blob.duplicate(this.session);
        this.resultSet.startUpdate(this.colIndex + 1);
        this.resultSet.preparedStatement.parameterValues[this.colIndex] = this.blob;
        this.resultSet.preparedStatement.parameterSet[this.colIndex] = true;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw JDBCUtil.sqlException(1852);
        }
    }

    static boolean isInLimits(long fullLength, long pos, long len) {
        return pos >= 0L && len >= 0L && pos + len <= fullLength;
    }
}

