/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.java.JavaSystem;

public class JDBCClob
implements Clob {
    private static final long MIN_POS = 1L;
    private static final long MAX_POS = 0x80000000L;
    private boolean m_closed;
    private String m_data;
    private final boolean m_createdByConnection;

    @Override
    public long length() throws SQLException {
        return this.getData().length();
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        String data = this.getData();
        int dlen = data.length();
        if (pos == 1L && length == dlen) {
            return data;
        }
        if (pos < 1L || pos > (long)dlen) {
            throw JDBCUtil.outOfRangeArgument("pos: " + pos);
        }
        long index = pos - 1L;
        if (length < 0 || (long)length > (long)dlen - index) {
            throw JDBCUtil.outOfRangeArgument("length: " + length);
        }
        return data.substring((int)index, (int)index + length);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.getData());
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        try {
            return new ByteArrayInputStream(this.getData().getBytes(JavaSystem.CS_US_ASCII));
        }
        catch (Throwable e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        String data = this.getData();
        if (start < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + start);
        }
        if (searchstr == null || start > 0x80000000L) {
            return -1L;
        }
        int position = data.indexOf(searchstr, (int)start - 1);
        return position == -1 ? -1L : (long)(position + 1);
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        long sslen;
        String data = this.getData();
        if (start < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + start);
        }
        if (searchstr == null) {
            return -1L;
        }
        long startIndex = start - 1L;
        long dlen = data.length();
        if (startIndex > dlen - (sslen = searchstr.length())) {
            return -1L;
        }
        String pattern = searchstr instanceof JDBCClob ? ((JDBCClob)searchstr).getData() : searchstr.getSubString(1L, (int)sslen);
        int index = data.indexOf(pattern, (int)startIndex);
        return index == -1 ? -1L : (long)(index + 1);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str == null ? 0 : str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        char[] chars;
        this.checkReadonly();
        String data = this.getData();
        if (str == null) {
            throw JDBCUtil.nullArgument("str");
        }
        int strlen = str.length();
        int dlen = data.length();
        int ipos = (int)(pos - 1L);
        if (offset == 0 && len == strlen && ipos == 0 && len >= dlen) {
            this.setData(str);
            return len;
        }
        if (offset < 0 || offset > strlen) {
            throw JDBCUtil.outOfRangeArgument("offset: " + offset);
        }
        if (len < 0 || len > strlen - offset) {
            throw JDBCUtil.outOfRangeArgument("len: " + len);
        }
        if (pos < 1L || pos - 1L > (long)(Integer.MAX_VALUE - len)) {
            throw JDBCUtil.outOfRangeArgument("pos: " + pos);
        }
        long endPos = pos + (long)len;
        if (pos > (long)dlen) {
            chars = new char[(int)endPos - 1];
            data.getChars(0, dlen, chars, 0);
            for (int i = dlen; i < ipos; ++i) {
                chars[i] = 32;
            }
            str.getChars(offset, offset + len, chars, ipos);
        } else if (endPos > (long)dlen) {
            chars = new char[(int)endPos - 1];
            data.getChars(0, ipos, chars, 0);
            str.getChars(offset, offset + len, chars, ipos);
        } else {
            chars = new char[dlen];
            data.getChars(0, ipos, chars, 0);
            str.getChars(offset, offset + len, chars, ipos);
            int dataOffset = ipos + len;
            data.getChars(dataOffset, dlen, chars, dataOffset);
        }
        this.setData(new String(chars));
        return len;
    }

    @Override
    public OutputStream setAsciiStream(final long pos) throws SQLException {
        this.checkReadonly();
        this.checkClosed();
        if (pos < 1L || pos > 0x80000000L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + pos);
        }
        return new ByteArrayOutputStream(){
            boolean closed = false;

            @Override
            public synchronized void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                byte[] bytes = this.buf;
                int length = this.count;
                this.buf = null;
                this.count = 0;
                try {
                    String str = new String(bytes, 0, length, JavaSystem.CS_US_ASCII);
                    JDBCClob.this.setString(pos, str);
                }
                catch (Throwable e) {
                    throw JavaSystem.toIOException(e);
                }
            }
        };
    }

    @Override
    public Writer setCharacterStream(final long pos) throws SQLException {
        this.checkReadonly();
        this.checkClosed();
        if (pos < 1L || pos > 0x80000000L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + pos);
        }
        return new StringWriter(){
            private boolean closed = false;

            @Override
            public synchronized void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                StringBuffer sb = super.getBuffer();
                try {
                    JDBCClob.this.setStringBuffer(pos, sb, 0, sb.length());
                }
                catch (SQLException se) {
                    throw JavaSystem.toIOException(se);
                }
                finally {
                    sb.setLength(0);
                    sb.trimToSize();
                }
            }
        };
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.checkReadonly();
        String data = this.getData();
        long dlen = data.length();
        if (len == dlen) {
            return;
        }
        if (len < 0L || len > dlen) {
            throw JDBCUtil.outOfRangeArgument("len: " + len);
        }
        this.setData(data.substring(0, (int)len));
    }

    @Override
    public synchronized void free() throws SQLException {
        this.m_closed = true;
        this.m_data = null;
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw JDBCUtil.outOfRangeArgument("length: " + length);
        }
        String data = this.getData();
        int dlen = data.length();
        if (pos == 1L && length == (long)dlen) {
            return new StringReader(data);
        }
        if (pos < 1L || pos > (long)dlen) {
            throw JDBCUtil.outOfRangeArgument("pos: " + pos);
        }
        long startIndex = pos - 1L;
        if (length < 0L || length > (long)dlen - startIndex) {
            throw JDBCUtil.outOfRangeArgument("length: " + length);
        }
        int endIndex = (int)(startIndex + length);
        char[] chars = new char[(int)length];
        data.getChars((int)startIndex, endIndex, chars, 0);
        return new CharArrayReader(chars);
    }

    public JDBCClob(String data) throws SQLException {
        if (data == null) {
            throw JDBCUtil.nullArgument();
        }
        this.m_data = data;
        this.m_createdByConnection = false;
    }

    protected JDBCClob() {
        this.m_data = "";
        this.m_createdByConnection = true;
    }

    protected void checkReadonly() throws SQLException {
        if (!this.m_createdByConnection) {
            throw JDBCUtil.sqlException(3706, "Clob is read-only");
        }
    }

    protected synchronized void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    synchronized String getData() throws SQLException {
        this.checkClosed();
        return this.m_data;
    }

    private synchronized void setData(String data) throws SQLException {
        this.checkClosed();
        this.m_data = data;
    }

    public int setStringBuffer(long pos, StringBuffer sb, int offset, int len) throws SQLException {
        char[] chars;
        this.checkReadonly();
        String data = this.getData();
        if (sb == null) {
            throw JDBCUtil.nullArgument("sb");
        }
        int strlen = sb.length();
        int dlen = data.length();
        int ipos = (int)(pos - 1L);
        if (offset == 0 && len == strlen && ipos == 0 && len >= dlen) {
            this.setData(sb.toString());
            return len;
        }
        if (offset < 0 || offset > strlen) {
            throw JDBCUtil.outOfRangeArgument("offset: " + offset);
        }
        if (len > strlen - offset) {
            throw JDBCUtil.outOfRangeArgument("len: " + len);
        }
        if (pos < 1L || pos - 1L > (long)(Integer.MAX_VALUE - len)) {
            throw JDBCUtil.outOfRangeArgument("pos: " + pos);
        }
        long endPos = pos + (long)len;
        if (pos > (long)dlen) {
            chars = new char[(int)endPos - 1];
            data.getChars(0, dlen, chars, 0);
            for (int i = dlen; i < ipos; ++i) {
                chars[i] = 32;
            }
            sb.getChars(offset, offset + len, chars, ipos);
        } else if (endPos > (long)dlen) {
            chars = new char[(int)endPos - 1];
            data.getChars(0, ipos, chars, 0);
            sb.getChars(offset, offset + len, chars, ipos);
        } else {
            chars = new char[dlen];
            data.getChars(0, ipos, chars, 0);
            sb.getChars(offset, offset + len, chars, ipos);
            int dataOffset = ipos + len;
            data.getChars(dataOffset, dlen, chars, dataOffset);
        }
        this.setData(new String(chars));
        return len;
    }
}

