/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.ClobInputStream;

public class JDBCClobClient
implements Clob {
    ClobDataID originalClob;
    ClobDataID clob;
    SessionInterface session;
    int colIndex;
    private boolean isClosed;
    private boolean isWritable;
    JDBCResultSet resultSet;

    @Override
    public synchronized InputStream getAsciiStream() throws SQLException {
        this.checkClosed();
        return new InputStream(){
            private Reader reader;
            {
                this.reader = JDBCClobClient.this.clob.getCharacterStream(JDBCClobClient.this.session);
            }

            @Override
            public int read() throws IOException {
                int c = this.reader.read();
                if (c < 0) {
                    return -1;
                }
                if (c >= 256) {
                    if (Character.isHighSurrogate((char)c)) {
                        this.reader.read();
                    }
                    c = 63;
                }
                return c;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int c;
                if (b == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || len < 0 || len > b.length - off) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return 0;
                }
                int bytesRead = 0;
                for (int i = 0; i < len && (c = this.reader.read()) >= 0; ++i) {
                    if (c >= 256) {
                        if (Character.isHighSurrogate((char)c)) {
                            this.reader.read();
                        }
                        c = 63;
                    }
                    b[off + i] = (byte)c;
                    ++bytesRead;
                }
                return bytesRead == 0 ? -1 : bytesRead;
            }

            @Override
            public void close() throws IOException {
                try {
                    this.reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        this.checkClosed();
        return new ClobInputStream(this.session, this.clob, 0L, this.length());
    }

    @Override
    public synchronized String getSubString(long pos, int length) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, pos - 1L, length)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            return this.clob.getSubString(this.session, pos - 1L, length);
        }
        catch (HsqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized long length() throws SQLException {
        this.checkClosed();
        try {
            return this.clob.length(this.session);
        }
        catch (HsqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized long position(String searchstr, long start) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, start - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            return this.clob.position(this.session, searchstr, start - 1L);
        }
        catch (HsqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized long position(Clob searchstr, long start) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, start - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (searchstr instanceof JDBCClobClient) {
            ClobDataID searchClob = ((JDBCClobClient)searchstr).clob;
            try {
                return this.clob.position(this.session, searchClob, start - 1L);
            }
            catch (HsqlException e) {
                throw JDBCUtil.sqlException(e);
            }
        }
        if (!JDBCClobClient.isInLimits(Integer.MAX_VALUE, 0L, searchstr.length())) {
            throw JDBCUtil.outOfRangeArgument();
        }
        return this.position(searchstr.getSubString(1L, (int)searchstr.length()), start);
    }

    @Override
    public synchronized OutputStream setAsciiStream(final long pos) throws SQLException {
        return new OutputStream(){
            Writer writer;
            {
                this.writer = JDBCClobClient.this.setCharacterStream(pos);
            }

            @Override
            public void write(int b) throws IOException {
                this.writer.write(b & 0xFF);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                if (b == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || len < 0 || len > b.length - off) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return;
                }
                char[] charArray = new char[len];
                for (int i = 0; i < len; ++i) {
                    charArray[i] = (char)b[off + i];
                }
                this.writer.write(charArray, 0, len);
            }

            @Override
            public void close() throws IOException {
                this.writer.close();
            }
        };
    }

    @Override
    public synchronized Writer setCharacterStream(final long pos) throws SQLException {
        this.checkClosed();
        if (pos < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + pos);
        }
        if (!this.isWritable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        this.startUpdate();
        return new Writer(){
            private long m_clobPosition;
            private boolean m_closed;
            {
                this.m_clobPosition = pos - 1L;
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                this.checkClosed();
                JDBCClobClient.this.clob.setChars(JDBCClobClient.this.session, this.m_clobPosition, cbuf, off, len);
                this.m_clobPosition += (long)len;
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                this.m_closed = true;
            }

            private void checkClosed() throws IOException {
                if (this.m_closed || JDBCClobClient.this.isClosed()) {
                    throw new IOException("The stream is closed");
                }
            }
        };
    }

    @Override
    public synchronized int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public synchronized int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(str.length(), offset, len)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (pos < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + pos);
        }
        if (!this.isWritable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        try {
            this.startUpdate();
            str = str.substring(offset, offset + len);
            this.clob.setString(this.session, pos - 1L, str);
            return len;
        }
        catch (HsqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized void truncate(long len) throws SQLException {
        this.checkClosed();
        if (len < 0L) {
            throw JDBCUtil.outOfRangeArgument("len: " + len);
        }
        try {
            this.clob.truncate(this.session, len);
        }
        catch (HsqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized void free() throws SQLException {
        this.isClosed = true;
        this.clob = null;
        this.session = null;
    }

    @Override
    public synchronized Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(this.length(), pos - 1L, length)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        return new ClobInputStream(this.session, this.clob, pos - 1L, length);
    }

    char[] getChars(long position, int length) throws SQLException {
        try {
            return this.clob.getChars(this.session, position - 1L, length);
        }
        catch (HsqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    public JDBCClobClient(SessionInterface session, ClobDataID clob) {
        this.session = session;
        this.clob = clob;
    }

    public ClobDataID getClob() {
        return this.clob;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void setWritable(JDBCResultSet result, int index) {
        this.isWritable = true;
        this.resultSet = result;
        this.colIndex = index;
    }

    public synchronized void clearUpdates() {
        if (this.originalClob != null) {
            this.clob = this.originalClob;
            this.originalClob = null;
        }
    }

    private void startUpdate() throws SQLException {
        if (this.originalClob != null) {
            return;
        }
        this.originalClob = this.clob;
        this.clob = (ClobDataID)this.clob.duplicate(this.session);
        this.resultSet.startUpdate(this.colIndex + 1);
        this.resultSet.preparedStatement.parameterValues[this.colIndex] = this.clob;
        this.resultSet.preparedStatement.parameterSet[this.colIndex] = true;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw JDBCUtil.sqlException(1852);
        }
    }

    static boolean isInLimits(long fullLength, long pos, long len) {
        return fullLength >= 0L && pos >= 0L && len >= 0L && pos <= fullLength - len;
    }
}

