/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.hsqldb.jdbc.JDBCBlobFile;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.List;

public class JDBCClobFile
implements Clob {
    private static final FrameworkLogger LOG = FrameworkLogger.getLog(JDBCClobFile.class);
    public static final String TEMP_FILE_PREFIX = "hsql_jdbc_clob_file_";
    public static final String TEMP_FILE_SUFFIX = ".tmp";
    private final File m_file;
    private boolean m_closed;
    private boolean m_deleteOnFree;
    private String m_encoding;
    private Charset m_charset;
    private CharsetEncoder m_encoder;
    private boolean m_fixedWidthCharset;
    private int m_maxCharWidth;
    private List m_streams = new HsqlArrayList();

    @Override
    public long length() throws SQLException {
        long l;
        this.checkClosed();
        if (this.m_fixedWidthCharset) {
            return this.m_file.length() / (long)this.m_maxCharWidth;
        }
        ReaderAdapter adapter = null;
        try {
            long length;
            adapter = new ReaderAdapter(this.m_file, 0L, Long.MAX_VALUE);
            l = length = adapter.skip(Long.MAX_VALUE);
        }
        catch (IOException ex) {
            try {
                throw JDBCUtil.sqlException(ex);
            }
            catch (Throwable throwable) {
                JDBCClobFile.closeSafely(adapter);
                throw throwable;
            }
        }
        JDBCClobFile.closeSafely(adapter);
        return l;
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        String string;
        Reader reader = null;
        int initialCapacity = Math.min(8192, length);
        try {
            reader = this.getCharacterStream(pos, length);
            CharArrayWriter writer = new CharArrayWriter(initialCapacity);
            InOutUtil.copy(reader, writer, (long)length);
            string = writer.toString();
        }
        catch (IOException ex) {
            try {
                throw JDBCUtil.sqlException(ex);
            }
            catch (Throwable throwable) {
                JDBCClobFile.closeSafely(reader);
                throw throwable;
            }
        }
        JDBCClobFile.closeSafely(reader);
        return string;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return this.getCharacterStream(1L, Long.MAX_VALUE);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        JDBCBlobFile.InputStreamAdapter stream;
        final List streams = this.m_streams;
        try {
            stream = new JDBCBlobFile.InputStreamAdapter(this.m_file, 0L, Long.MAX_VALUE){
                private boolean closed;
                private InputStream self;
                {
                    super(file, pos, length);
                    this.self = this;
                }

                @Override
                public synchronized void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    try {
                        super.close();
                    }
                    finally {
                        streams.remove(this.self);
                    }
                }
            };
        }
        catch (FileNotFoundException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        catch (IOException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        catch (SecurityException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        catch (NullPointerException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        streams.add(stream);
        return stream;
    }

    public long position(char[] pattern, long start) throws SQLException {
        if (start < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + start);
        }
        if (pattern == null || pattern.length == 0) {
            return -1L;
        }
        long length = this.length();
        if (start > length || (long)pattern.length > length || start > length - (long)pattern.length) {
            return -1L;
        }
        return this.position0(new String(pattern), start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long position0(String pattern, long start) throws SQLException {
        Scanner scanner;
        ReaderAdapter reader;
        Pattern literal;
        block13: {
            try {
                literal = Pattern.compile(Pattern.quote(pattern));
            }
            catch (PatternSyntaxException ex) {
                throw JDBCUtil.sqlException(ex);
            }
            reader = null;
            scanner = null;
            boolean gotReaderAndScanner = false;
            try {
                reader = new ReaderAdapter(this.m_file, start - 1L, this.m_file.length());
                scanner = new Scanner(reader);
                gotReaderAndScanner = true;
                if (gotReaderAndScanner) break block13;
            }
            catch (FileNotFoundException ex) {
                try {
                    throw JDBCUtil.sqlException(ex);
                    catch (IOException ex2) {
                        throw JDBCUtil.sqlException(ex2);
                    }
                    catch (SecurityException ex3) {
                        throw JDBCUtil.sqlException(ex3);
                    }
                    catch (NullPointerException ex4) {
                        throw JDBCUtil.sqlException(ex4);
                    }
                    catch (IllegalArgumentException ex5) {
                        throw JDBCUtil.sqlException(ex5);
                    }
                }
                catch (Throwable throwable) {
                    if (gotReaderAndScanner) throw throwable;
                    JDBCClobFile.closeSafely(scanner);
                    JDBCClobFile.closeSafely(reader);
                    throw throwable;
                }
            }
            JDBCClobFile.closeSafely(scanner);
            JDBCClobFile.closeSafely(reader);
        }
        int position = -1;
        try {
            if (!scanner.hasNext()) return position;
            boolean found = null != scanner.findWithinHorizon(literal, 0);
            if (!found) return position;
            MatchResult match = scanner.match();
            position = match.start() + 1;
            return position;
        }
        finally {
            JDBCClobFile.closeSafely(scanner);
            JDBCClobFile.closeSafely(reader);
        }
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        if (start < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + start);
        }
        if (searchstr == null || searchstr.isEmpty()) {
            return -1L;
        }
        long length = this.length();
        int searchstrLength = searchstr.length();
        if (start > length || (long)searchstrLength > length || start > length - (long)searchstrLength) {
            return -1L;
        }
        return this.position0(searchstr, start);
    }

    @Override
    public long position(Clob pattern, long start) throws SQLException {
        String stringPattern;
        if (start < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + start);
        }
        long patternLength = pattern == null ? 0L : pattern.length();
        if (patternLength == 0L) {
            return -1L;
        }
        if (patternLength > Integer.MAX_VALUE) {
            throw JDBCUtil.outOfRangeArgument("pattern.length(): " + patternLength);
        }
        long length = this.length();
        if (start > length || patternLength > length || start > length - patternLength) {
            return -1L;
        }
        if (pattern instanceof JDBCClob) {
            stringPattern = ((JDBCClob)pattern).getData();
        } else {
            Reader reader = null;
            StringWriter writer = new StringWriter();
            try {
                reader = pattern.getCharacterStream();
                InOutUtil.copy(reader, writer, patternLength);
            }
            catch (IOException ex) {
                throw JDBCUtil.sqlException(ex);
            }
            catch (Throwable ex) {
                throw JDBCUtil.sqlException(ex);
            }
            finally {
                JDBCClobFile.closeSafely(reader);
            }
            stringPattern = writer.toString();
        }
        return this.position0(stringPattern, start);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str == null ? 0 : str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkClosed();
        if (str == null) {
            throw JDBCUtil.nullArgument("str");
        }
        int strlen = str.length();
        if (offset < 0 || offset > strlen) {
            throw JDBCUtil.outOfRangeArgument("offset: " + offset);
        }
        if (len < 0 || len > strlen - offset) {
            throw JDBCUtil.outOfRangeArgument("len: " + len);
        }
        if (pos < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + pos);
        }
        long oldLength = this.length();
        if (pos > oldLength + 1L) {
            this.fillSpace(oldLength + 1L, pos);
        }
        Writer writer = null;
        try {
            writer = this.setCharacterStream(pos);
            writer.write(str, offset, len);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        catch (Throwable ex) {
            throw JDBCUtil.sqlException(ex);
        }
        finally {
            JDBCClobFile.closeSafely(writer);
        }
        return len;
    }

    private void fillSpace(long startPos, long endPos) throws SQLException {
        Writer writer = null;
        try {
            writer = this.setCharacterStream(startPos);
            for (long i = endPos - startPos; i >= 0L; --i) {
                writer.append(' ');
            }
        }
        catch (IOException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        catch (Throwable ex) {
            throw JDBCUtil.sqlException(ex);
        }
        finally {
            JDBCClobFile.closeSafely(writer);
        }
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        JDBCBlobFile.OutputStreamAdapter stream;
        if (pos < 1L) {
            throw JDBCUtil.invalidArgument("pos: " + pos);
        }
        this.checkClosed();
        this.createFile();
        long thisLength = this.length();
        if (pos > thisLength + 1L) {
            this.fillSpace(thisLength + 1L, pos);
        }
        try {
            stream = new JDBCBlobFile.OutputStreamAdapter(this.m_file, pos - 1L){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (FileNotFoundException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        catch (IOException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        catch (NullPointerException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        catch (SecurityException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        this.m_streams.add(stream);
        return stream;
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        BufferedWriter writer;
        WriterAdapter adapter;
        if (pos < 1L) {
            throw JDBCUtil.invalidArgument("pos: " + pos);
        }
        this.checkClosed();
        this.createFile();
        long thisLength = this.length();
        if (pos > thisLength + 1L) {
            this.fillSpace(thisLength + 1L, pos);
        }
        try {
            adapter = new WriterAdapter(this.m_file, pos - 1L){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
            writer = new BufferedWriter(adapter);
        }
        catch (IOException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        catch (Throwable ex) {
            throw JDBCUtil.sqlException(ex);
        }
        this.m_streams.add(adapter);
        return writer;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void truncate(long len) throws SQLException {
        if (len < 0L) {
            throw JDBCUtil.invalidArgument("len: " + len);
        }
        this.checkClosed();
        ReaderAdapter adapter = null;
        RandomAccessFile randomAccessFile = null;
        try {
            adapter = new ReaderAdapter(this.m_file, len, Long.MAX_VALUE);
            long filePointer = adapter.getFilePointer();
            adapter.close();
            randomAccessFile = new RandomAccessFile(this.m_file, "rw");
            randomAccessFile.setLength(filePointer);
        }
        catch (IOException ex) {
            try {
                throw JDBCUtil.sqlException(ex);
                catch (Throwable ex2) {
                    throw JDBCUtil.sqlException(ex2);
                }
            }
            catch (Throwable throwable) {
                JDBCClobFile.closeSafely(adapter);
                JDBCClobFile.closeSafely(randomAccessFile);
                throw throwable;
            }
        }
        JDBCClobFile.closeSafely(adapter);
        JDBCClobFile.closeSafely(randomAccessFile);
    }

    @Override
    public synchronized void free() throws SQLException {
        if (this.m_closed) {
            return;
        }
        this.m_closed = true;
        List streams = this.m_streams;
        this.m_streams = null;
        Iterator itr = streams.iterator();
        while (itr.hasNext()) {
            Object stream = itr.next();
            this.closeSafely(stream);
        }
        if (this.m_deleteOnFree) {
            try {
                this.m_file.delete();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        ReaderAdapter reader;
        if (pos < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + pos);
        }
        if (length < 0L) {
            throw JDBCUtil.outOfRangeArgument("length: " + length);
        }
        final List streams = this.m_streams;
        try {
            reader = new ReaderAdapter(this.m_file, pos - 1L, length){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        streams.remove(this);
                    }
                }
            };
        }
        catch (IOException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        catch (Throwable ex) {
            throw JDBCUtil.sqlException(ex);
        }
        streams.add(reader);
        return reader;
    }

    public File getFile() {
        return this.m_file;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public boolean isDeleteOnFree() {
        return this.m_deleteOnFree;
    }

    public void setDeleteOnFree(boolean deleteOnFree) {
        this.m_deleteOnFree = deleteOnFree;
    }

    public JDBCClobFile() throws SQLException {
        this((String)null);
    }

    public JDBCClobFile(String encoding) throws SQLException {
        try {
            this.setEncoding(encoding);
            this.m_file = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            this.m_deleteOnFree = true;
        }
        catch (IOException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        catch (SecurityException se) {
            throw JDBCUtil.sqlException(se);
        }
    }

    public JDBCClobFile(File file) throws SQLException {
        this(file, null);
    }

    public JDBCClobFile(File file, String encoding) throws SQLException {
        if (file == null) {
            throw JDBCUtil.nullArgument("file");
        }
        try {
            this.setEncoding(encoding);
            this.m_file = file.getCanonicalFile();
            this.checkIsFile(false);
            this.m_deleteOnFree = false;
        }
        catch (IOException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        catch (SQLException ex) {
            throw JDBCUtil.sqlException(ex);
        }
    }

    protected final void setEncoding(String encoding) throws UnsupportedEncodingException {
        boolean fixedWidthCharset;
        Charset charSet = JDBCClobFile.charsetForName(encoding);
        CharsetEncoder encoder = charSet.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        float maxBytesPerChar = encoder.maxBytesPerChar();
        float averageBytesPerChar = encoder.averageBytesPerChar();
        this.m_fixedWidthCharset = fixedWidthCharset = maxBytesPerChar == (float)Math.round(maxBytesPerChar) && maxBytesPerChar == averageBytesPerChar;
        this.m_maxCharWidth = Math.round(maxBytesPerChar);
        this.m_charset = charSet;
        this.m_encoder = encoder;
        this.m_encoding = this.m_charset.name();
    }

    protected static Charset charsetForName(String charsetName) throws UnsupportedEncodingException {
        String csn = charsetName;
        if (csn == null) {
            csn = Charset.defaultCharset().name();
        }
        try {
            if (Charset.isSupported(csn)) {
                return Charset.forName(csn);
            }
        }
        catch (IllegalCharsetNameException x) {
            LOG.warning(x.getMessage(), x);
        }
        throw new UnsupportedEncodingException(csn);
    }

    protected final void checkIsFile(boolean checkExists) throws SQLException {
        boolean exists = false;
        boolean isFile = false;
        try {
            exists = this.m_file.exists();
        }
        catch (Exception ex) {
            throw JDBCUtil.sqlException(ex);
        }
        if (exists) {
            try {
                isFile = this.m_file.isFile();
            }
            catch (Exception ex) {
                throw JDBCUtil.sqlException(ex);
            }
        }
        if (exists) {
            if (!isFile) {
                throw JDBCUtil.invalidArgument("Is not a file: " + this.m_file);
            }
        } else if (checkExists) {
            throw JDBCUtil.invalidArgument("Does not exist: " + this.m_file);
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    protected void createFile() throws SQLException {
        try {
            if (!this.m_file.exists()) {
                FileUtil.getFileUtil().makeParentDirectories(this.m_file);
                this.m_file.createNewFile();
            }
        }
        catch (IOException ex) {
            throw JDBCUtil.sqlException(ex);
        }
        catch (Throwable ex) {
            throw JDBCUtil.sqlException(ex);
        }
        this.checkIsFile(true);
    }

    private static void closeSafely(RandomAccessFile target) {
        if (target != null) {
            try {
                target.close();
            }
            catch (IOException ignoredIoe) {
                LOG.info(ignoredIoe.getMessage(), ignoredIoe);
            }
            catch (Throwable ignoredRex) {
                LOG.info(ignoredRex.getMessage(), ignoredRex);
            }
        }
    }

    private static void closeSafely(InputStream target) {
        if (target != null) {
            try {
                target.close();
            }
            catch (IOException ignoredIoe) {
                LOG.info(ignoredIoe.getMessage(), ignoredIoe);
            }
            catch (Throwable ignoredRex) {
                LOG.info(ignoredRex.getMessage(), ignoredRex);
            }
        }
    }

    private static void closeSafely(OutputStream target) {
        if (target != null) {
            try {
                target.close();
            }
            catch (IOException ignoredIoe) {
                LOG.info(ignoredIoe.getMessage(), ignoredIoe);
            }
            catch (Throwable ignoredRex) {
                LOG.info(ignoredRex.getMessage(), ignoredRex);
            }
        }
    }

    private static void closeSafely(Reader target) {
        if (target != null) {
            try {
                target.close();
            }
            catch (IOException ignoredIoe) {
                LOG.info(ignoredIoe.getMessage(), ignoredIoe);
            }
            catch (Throwable ignoredRex) {
                LOG.info(ignoredRex.getMessage(), ignoredRex);
            }
        }
    }

    private static void closeSafely(Writer target) {
        if (target != null) {
            try {
                target.close();
            }
            catch (IOException ignoredIoe) {
                LOG.info(ignoredIoe.getMessage(), ignoredIoe);
            }
            catch (Throwable ignoredRex) {
                LOG.info(ignoredRex.getMessage(), ignoredRex);
            }
        }
    }

    private static void closeSafely(Scanner target) {
        if (target != null) {
            try {
                target.close();
            }
            catch (Throwable ignoredRex) {
                LOG.info(ignoredRex.getMessage(), ignoredRex);
            }
        }
    }

    private void closeSafely(Object target) {
        if (target instanceof RandomAccessFile) {
            JDBCClobFile.closeSafely((RandomAccessFile)target);
        } else if (target instanceof InputStream) {
            JDBCClobFile.closeSafely((InputStream)target);
        } else if (target instanceof OutputStream) {
            JDBCClobFile.closeSafely((OutputStream)target);
        } else if (target instanceof Reader) {
            JDBCClobFile.closeSafely((Reader)target);
        } else if (target instanceof Writer) {
            JDBCClobFile.closeSafely((Writer)target);
        } else if (target instanceof Scanner) {
            JDBCClobFile.closeSafely((Scanner)target);
        }
    }

    protected class ReaderAdapter
    extends Reader {
        private static final int CHARBUFFER_CAPACTIY = 128;
        private final Reader m_reader;
        private long m_remaining = Long.MAX_VALUE;
        private long m_filePointer;
        private ByteBuffer m_byteBuffer;
        private CharBuffer m_charBuffer;

        protected ReaderAdapter(File file, long pos, long length) throws FileNotFoundException, IOException, NullPointerException, IllegalArgumentException, SecurityException {
            long maxCharsLength;
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (pos < 0L) {
                throw new IllegalArgumentException("pos: " + pos);
            }
            if (length < 0L) {
                throw new IllegalArgumentException("length: " + length);
            }
            long fileLength = file.length();
            long l = maxCharsLength = JDBCClobFile.this.m_fixedWidthCharset ? Math.round((double)fileLength / (double)JDBCClobFile.this.m_maxCharWidth) : fileLength;
            if (maxCharsLength - pos < 0L) {
                throw new IllegalArgumentException("pos: " + pos);
            }
            if (!JDBCClobFile.this.m_fixedWidthCharset) {
                int charCapacity = 128;
                int byteCapacity = 128 * JDBCClobFile.this.m_maxCharWidth;
                this.m_charBuffer = CharBuffer.allocate(128);
                this.m_byteBuffer = ByteBuffer.allocate(byteCapacity);
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                BufferedInputStream bis = new BufferedInputStream(fis);
                InputStreamReader isr = new InputStreamReader((InputStream)bis, JDBCClobFile.this.m_charset);
                this.m_reader = isr;
            }
            catch (FileNotFoundException ex) {
                JDBCClobFile.closeSafely(fis);
                throw ex;
            }
            catch (SecurityException ex) {
                JDBCClobFile.closeSafely(fis);
                throw ex;
            }
            catch (NullPointerException ex) {
                JDBCClobFile.closeSafely(fis);
                throw ex;
            }
            catch (RuntimeException ex) {
                JDBCClobFile.closeSafely(fis);
                throw ex;
            }
            long skipped = this.skip(pos);
            if (skipped < pos) {
                throw new IllegalArgumentException("pos: " + pos);
            }
            this.m_remaining = length;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int bytesRead;
            int charsRead;
            long l_remaining = this.m_remaining;
            if (l_remaining <= 0L) {
                return -1;
            }
            if (l_remaining < (long)len) {
                len = (int)l_remaining;
            }
            if ((charsRead = this.m_reader.read(cbuf, off, len)) == -1) {
                return -1;
            }
            if ((long)charsRead > l_remaining) {
                charsRead = (int)l_remaining;
                this.m_remaining = 0L;
            } else {
                this.m_remaining -= (long)charsRead;
            }
            if (JDBCClobFile.this.m_fixedWidthCharset) {
                bytesRead = JDBCClobFile.this.m_maxCharWidth * charsRead;
            } else {
                boolean reallocate = charsRead > this.m_charBuffer.capacity();
                CharBuffer cb = reallocate ? CharBuffer.allocate(charsRead) : this.m_charBuffer;
                ByteBuffer bb = reallocate ? ByteBuffer.allocate(charsRead * JDBCClobFile.this.m_maxCharWidth) : this.m_byteBuffer;
                cb.clear();
                bb.clear();
                cb.put(cbuf, off, charsRead);
                cb.flip();
                JDBCClobFile.this.m_encoder.encode(cb, bb, true);
                bb.flip();
                bytesRead = bb.limit();
                if (reallocate) {
                    this.m_byteBuffer = bb;
                    this.m_charBuffer = cb;
                }
            }
            this.m_filePointer += (long)bytesRead;
            return charsRead;
        }

        @Override
        public void close() throws IOException {
            this.m_reader.close();
        }

        public long getFilePointer() {
            return this.m_filePointer;
        }
    }

    protected class WriterAdapter
    extends Writer {
        protected final Writer m_writer;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected WriterAdapter(File file, long pos) throws FileNotFoundException, IOException, SecurityException, NullPointerException, IllegalArgumentException {
            long filePointer;
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (pos < 0L) {
                throw new IllegalArgumentException("pos: " + pos);
            }
            ReaderAdapter reader = null;
            try {
                reader = new ReaderAdapter(file, pos, Long.MAX_VALUE);
                filePointer = reader.getFilePointer();
            }
            catch (Throwable throwable) {
                JDBCClobFile.closeSafely(reader);
                throw throwable;
            }
            JDBCClobFile.closeSafely(reader);
            RandomAccessFile raf = null;
            boolean success = false;
            try {
                raf = new RandomAccessFile(file, "rw");
                raf.seek(filePointer);
                success = true;
            }
            finally {
                if (!success) {
                    JDBCClobFile.closeSafely(raf);
                }
            }
            JDBCBlobFile.OutputStreamAdapter osa = new JDBCBlobFile.OutputStreamAdapter(raf);
            this.m_writer = JDBCClobFile.this.m_encoding == null ? new OutputStreamWriter(osa) : new OutputStreamWriter((OutputStream)osa, JDBCClobFile.this.m_charset);
        }

        @Override
        public void flush() throws IOException {
            this.m_writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.m_writer.close();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.m_writer.write(cbuf, off, len);
        }
    }
}

