/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverAction;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.hsqldb.DatabaseURL;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.persist.HsqlProperties;

public class JDBCDriver
implements Driver {
    static final String conn_loginTimeout = "loginTimeout";
    public static final JDBCDriver driverInstance = new JDBCDriver();
    public final ThreadLocal<JDBCConnection> threadConnection = new ThreadLocal();

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url.regionMatches(true, 0, "jdbc:default:connection", 0, "jdbc:default:connection".length())) {
            JDBCConnection conn = this.threadConnection.get();
            return conn;
        }
        return JDBCDriver.getConnection(url, info);
    }

    public static Connection getConnection(String url, Properties info) throws SQLException {
        final HsqlProperties props = DatabaseURL.parseURL(url, true, false);
        if (props == null) {
            throw JDBCUtil.invalidArgument();
        }
        if (props.isEmpty()) {
            return null;
        }
        long timeout = 0L;
        if (info != null) {
            timeout = HsqlProperties.getIntegerProperty(info, conn_loginTimeout, 0);
        }
        props.addProperties(info);
        if (timeout == 0L) {
            timeout = DriverManager.getLoginTimeout();
        }
        if (timeout == 0L) {
            return new JDBCConnection(props);
        }
        String connType = props.getProperty("connection_type");
        if (DatabaseURL.isInProcessDatabaseType(connType)) {
            return new JDBCConnection(props);
        }
        final JDBCConnection[] conn = new JDBCConnection[1];
        final SQLException[] ex = new SQLException[1];
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    conn[0] = new JDBCConnection(props);
                }
                catch (SQLException se) {
                    ex[0] = se;
                }
            }
        };
        t.start();
        try {
            t.join(1000L * timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (ex[0] != null) {
            throw ex[0];
        }
        if (conn[0] != null) {
            return conn[0];
        }
        throw JDBCUtil.sqlException(1351);
    }

    @Override
    public boolean acceptsURL(String url) {
        if (url == null) {
            return false;
        }
        if (url.regionMatches(true, 0, "jdbc:hsqldb:", 0, "jdbc:hsqldb:".length())) {
            return true;
        }
        return url.regionMatches(true, 0, "jdbc:default:connection", 0, "jdbc:default:connection".length());
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        if (!this.acceptsURL(url)) {
            return new DriverPropertyInfo[0];
        }
        String[] choices = new String[]{"true", "false"};
        DriverPropertyInfo[] pinfo = new DriverPropertyInfo[6];
        if (info == null) {
            info = new Properties();
        }
        DriverPropertyInfo p = new DriverPropertyInfo("user", null);
        p.value = info.getProperty("user");
        p.required = true;
        pinfo[0] = p;
        p = new DriverPropertyInfo("password", null);
        p.value = info.getProperty("password");
        p.required = true;
        pinfo[1] = p;
        p = new DriverPropertyInfo("get_column_name", null);
        p.value = info.getProperty("get_column_name", "true");
        p.required = false;
        p.choices = choices;
        pinfo[2] = p;
        p = new DriverPropertyInfo("ifexists", null);
        p.value = info.getProperty("ifexists", "false");
        p.required = false;
        p.choices = choices;
        pinfo[3] = p;
        p = new DriverPropertyInfo("default_schema", null);
        p.value = info.getProperty("default_schema", "false");
        p.required = false;
        p.choices = choices;
        pinfo[4] = p;
        p = new DriverPropertyInfo("shutdown", null);
        p.value = info.getProperty("shutdown", "false");
        p.required = false;
        p.choices = choices;
        pinfo[5] = p;
        return pinfo;
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 7;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw (SQLFeatureNotSupportedException)JDBCUtil.notSupported();
    }

    static {
        try {
            DriverManager.registerDriver(driverInstance, new EmptyDiverAction());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class EmptyDiverAction
    implements DriverAction {
        private EmptyDiverAction() {
        }

        @Override
        public void deregister() {
        }
    }
}

