/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Wrapper;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.jdbc.pool.JDBCPooledConnection;
import org.hsqldb.jdbc.pool.JDBCPooledDataSource;

public class JDBCPool
implements DataSource,
Referenceable,
ConnectionEventListener,
StatementEventListener,
Wrapper {
    AtomicIntegerArray states;
    JDBCPooledConnection[] connections;
    JDBCPooledDataSource source = new JDBCPooledDataSource();
    volatile boolean closed;

    @Override
    public Connection getConnection() throws SQLException {
        int retries = 300;
        if (this.source.loginTimeout != 0) {
            retries = this.source.loginTimeout * 10;
        }
        if (this.closed) {
            throw new SQLException("connection pool is closed");
        }
        for (int count = 0; count < retries; ++count) {
            for (int i = 0; i < this.states.length(); ++i) {
                if (this.states.compareAndSet(i, 1, 2)) {
                    return this.connections[i].getConnection();
                }
                if (!this.states.compareAndSet(i, 0, 2)) continue;
                try {
                    JDBCPooledConnection connection = (JDBCPooledConnection)this.source.getPooledConnection();
                    connection.addConnectionEventListener(this);
                    connection.addStatementEventListener(this);
                    this.connections[i] = connection;
                    return this.connections[i].getConnection();
                }
                catch (SQLException e) {
                    this.states.set(i, 0);
                }
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw JDBCUtil.invalidArgument();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        String user = this.getUser();
        if (username == null || password == null) {
            throw JDBCUtil.nullArgument();
        }
        if (user == null) {
            this.setUser(username);
            this.setPassword(password);
        } else if (!user.equals(username)) {
            throw JDBCUtil.invalidArgument("user name does not match");
        }
        return this.getConnection();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public Reference getReference() throws NamingException {
        String cname = "org.hsqldb.jdbc.JDBCDataSourceFactory";
        Reference ref = new Reference(this.getClass().getName(), cname, null);
        ref.add(new StringRefAddr("database", this.source.getDatabase()));
        ref.add(new StringRefAddr("user", this.source.getUser()));
        ref.add(new StringRefAddr("password", this.source.password));
        ref.add(new StringRefAddr("loginTimeout", Integer.toString(this.source.loginTimeout)));
        ref.add(new StringRefAddr("poolSize", Integer.toString(this.connections.length)));
        return ref;
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        PooledConnection connection = (PooledConnection)event.getSource();
        for (int i = 0; i < this.connections.length; ++i) {
            if (this.connections[i] != connection) continue;
            this.states.set(i, 1);
            break;
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection connection = (PooledConnection)event.getSource();
        for (int i = 0; i < this.connections.length; ++i) {
            if (this.connections[i] != connection) continue;
            this.states.set(i, 2);
            this.connections[i] = null;
            this.states.set(i, 0);
            break;
        }
    }

    @Override
    public void statementClosed(StatementEvent event) {
    }

    @Override
    public void statementErrorOccurred(StatementEvent event) {
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.source.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.source.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.source.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.source.getLoginTimeout();
    }

    public String getDescription() {
        return "org.hsqldb.jdbc.JDBCPool max size " + this.connections.length;
    }

    public String getDataSourceName() {
        return "org.hsqldb.jdbc.JDBCPool";
    }

    public String getDatabaseName() {
        return this.source.getUrl();
    }

    public String getDatabase() {
        return this.source.getDatabase();
    }

    public String getUrl() {
        return this.source.getUrl();
    }

    public String getURL() {
        return this.source.getUrl();
    }

    public String getUser() {
        return this.source.getUser();
    }

    public void setDatabaseName(String databaseName) {
        this.source.setDatabaseName(databaseName);
    }

    public void setDatabase(String database) {
        this.source.setDatabase(database);
    }

    public void setUrl(String url) {
        this.source.setUrl(url);
    }

    public void setURL(String url) {
        this.source.setUrl(url);
    }

    public void setPassword(String password) {
        this.source.setPassword(password);
    }

    public void setUser(String user) {
        this.source.setUser(user);
    }

    public void setProperties(Properties props) {
        this.source.setProperties(props);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw (SQLFeatureNotSupportedException)JDBCUtil.notSupported();
    }

    public JDBCPool() {
        this(10);
    }

    public JDBCPool(int size) {
        this.connections = new JDBCPooledConnection[size];
        this.states = new AtomicIntegerArray(size);
    }

    public void close(int wait) throws SQLException {
        if (wait < 0 || wait > 60) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            Thread.sleep(1000 * wait);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (int i = 0; i < this.connections.length; ++i) {
            if (this.connections[i] == null) continue;
            this.connections[i].release();
        }
        Arrays.fill(this.connections, null);
    }

    static interface RefState {
        public static final int empty = 0;
        public static final int available = 1;
        public static final int allocated = 2;
    }
}

