/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.UUID;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCParameterMetaData;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCResultSetMetaData;
import org.hsqldb.jdbc.JDBCStatementBase;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.CharArrayWriter;
import org.hsqldb.lib.CountdownInputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.result.ResultProperties;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryUUIDType;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.BlobInputStream;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.ClobInputStream;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.JavaObjectDataInternal;
import org.hsqldb.types.Type;

public class JDBCPreparedStatement
extends JDBCStatementBase
implements PreparedStatement {
    boolean poolable = true;
    protected Object[] parameterValues;
    protected boolean[] parameterSet;
    protected Type[] parameterTypes;
    protected byte[] parameterModes;
    protected long[] streamLengths;
    protected boolean hasLOBs;
    protected boolean isBatch;
    protected ResultMetaData resultMetaData;
    protected ResultMetaData parameterMetaData;
    protected JDBCResultSetMetaData resultSetMetaData;
    protected ParameterMetaData pmd;
    protected String sql;
    protected long statementID;
    protected int statementRetType;
    protected final boolean isResult;
    protected SessionInterface session;

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        if (this.statementRetType != 2) {
            this.checkStatementType(2);
        }
        this.fetchResult();
        return this.getResultSet();
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        if (this.statementRetType != 1) {
            this.checkStatementType(1);
        }
        this.fetchResult();
        return this.resultIn.getUpdateCount();
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParameter(parameterIndex, null);
    }

    @Override
    public synchronized void setBoolean(int parameterIndex, boolean x) throws SQLException {
        Boolean b = x ? Boolean.TRUE : Boolean.FALSE;
        this.setParameter(parameterIndex, b);
    }

    @Override
    public synchronized void setByte(int parameterIndex, byte x) throws SQLException {
        this.setIntParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setShort(int parameterIndex, short x) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.setIntParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setInt(int parameterIndex, int x) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.setIntParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setLong(int parameterIndex, long x) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.setLongParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setFloat(int parameterIndex, float x) throws SQLException {
        this.setDouble(parameterIndex, x);
    }

    @Override
    public synchronized void setDouble(int parameterIndex, double x) throws SQLException {
        Double d = x;
        this.setParameter(parameterIndex, d);
    }

    @Override
    public synchronized void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setString(int parameterIndex, String x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public synchronized void setTime(int parameterIndex, Time x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, (long)length);
    }

    @Override
    @Deprecated
    public synchronized void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkSetParameterIndex(parameterIndex);
        int ver = 4;
        if (x == null) {
            throw JDBCUtil.nullArgument("x");
        }
        String encoding = "UTF8";
        StringWriter writer = new StringWriter();
        try {
            int charsRead;
            CountdownInputStream cis = new CountdownInputStream(x);
            InputStreamReader reader = new InputStreamReader((InputStream)cis, encoding);
            char[] buff = new char[1024];
            cis.setCount(length);
            while (-1 != (charsRead = reader.read(buff))) {
                writer.write(buff, 0, charsRead);
            }
        }
        catch (IOException ex) {
            throw JDBCUtil.sqlException(401, ex.toString(), ex);
        }
        this.setParameter(parameterIndex, writer.toString());
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (long)length);
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        Arrays.fill(this.parameterValues, null);
        Arrays.fill(this.parameterSet, false);
        Arrays.fill(this.streamLengths, 0, this.streamLengths.length, 0L);
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        if (x instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)x, scaleOrLength);
        } else if (x instanceof Reader) {
            this.setCharacterStream(parameterIndex, (Reader)x, scaleOrLength);
        } else {
            this.setObject(parameterIndex, x);
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x) throws SQLException {
        this.setParameter(parameterIndex, x);
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        this.fetchResult();
        return this.statementRetType == 2;
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.checkParametersSet();
        if (!this.isBatch) {
            this.resultOut.setBatchedPreparedExecuteRequest();
            this.isBatch = true;
        }
        try {
            this.performPreExecute();
        }
        catch (HsqlException e) {
            throw JDBCUtil.sqlException(e);
        }
        int len = this.parameterValues.length;
        Object[] batchParamValues = new Object[len];
        System.arraycopy(this.parameterValues, 0, batchParamValues, 0, len);
        this.resultOut.addBatchedPreparedExecuteRequest(batchParamValues);
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (long)length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkSetParameterIndex(parameterIndex);
        Type outType = this.parameterTypes[parameterIndex - 1];
        switch (outType.typeCode) {
            case 60: 
            case 61: {
                this.setBlobForBinaryParameter(parameterIndex, x);
                return;
            }
            case 30: {
                this.setBlobParameter(parameterIndex, x);
                break;
            }
            default: {
                throw JDBCUtil.invalidArgument();
            }
        }
    }

    private void setBlobForBinaryParameter(int parameterIndex, Blob x) throws SQLException {
        if (x instanceof JDBCBlob) {
            this.setParameter(parameterIndex, ((JDBCBlob)x).data());
            return;
        }
        if (x == null) {
            this.setParameter(parameterIndex, null);
            return;
        }
        long length = x.length();
        if (length > Integer.MAX_VALUE) {
            String msg = "Maximum Blob input octet length exceeded: " + length;
            throw JDBCUtil.sqlException(422, msg);
        }
        try {
            InputStream in = x.getBinaryStream();
            HsqlByteArrayOutputStream out = new HsqlByteArrayOutputStream(in, (int)length);
            this.setParameter(parameterIndex, out.toByteArray());
            out.close();
        }
        catch (Throwable e) {
            throw JDBCUtil.sqlException(422, e.toString(), e);
        }
    }

    @Override
    public synchronized void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkSetParameterIndex(parameterIndex);
        Type outType = this.parameterTypes[parameterIndex - 1];
        switch (outType.typeCode) {
            case 1: 
            case 12: {
                this.setClobForStringParameter(parameterIndex, x);
                return;
            }
            case 40: {
                this.setClobParameter(parameterIndex, x);
                return;
            }
        }
        throw JDBCUtil.invalidArgument();
    }

    private void setClobForStringParameter(int parameterIndex, Clob x) throws SQLException {
        if (x instanceof JDBCClob) {
            this.setParameter(parameterIndex, ((JDBCClob)x).getData());
            return;
        }
        if (x == null) {
            this.setParameter(parameterIndex, null);
            return;
        }
        long length = x.length();
        if (length > Integer.MAX_VALUE) {
            String msg = "Max Clob input character length exceeded: " + length;
            throw JDBCUtil.sqlException(422, msg);
        }
        try {
            Reader reader = x.getCharacterStream();
            CharArrayWriter writer = new CharArrayWriter(reader, (int)length);
            this.setParameter(parameterIndex, writer.toString());
        }
        catch (Throwable e) {
            throw JDBCUtil.sqlException(401, e.toString(), e);
        }
    }

    @Override
    public synchronized void setArray(int parameterIndex, Array x) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        int index = parameterIndex - 1;
        Type type = this.parameterMetaData.columnTypes[index];
        if (!type.isArrayType()) {
            throw JDBCUtil.sqlException(5561);
        }
        if (x == null) {
            this.parameterValues[index] = null;
            this.parameterSet[index] = true;
            return;
        }
        Object[] data = null;
        if (x instanceof JDBCArray) {
            Type baseType = type.collectionBaseType();
            Object[] array = ((JDBCArray)x).getArrayInternal();
            Type otherType = ((JDBCArray)x).arrayType;
            data = (Object[])type.convertToType(this.session, array, otherType);
        } else {
            Object object = x.getArray();
            if (object instanceof Object[]) {
                Type baseType = type.collectionBaseType();
                Object[] array = (Object[])object;
                data = new Object[array.length];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = baseType.convertJavaToSQL(this.session, array[i]);
                }
            } else {
                throw JDBCUtil.notSupported();
            }
        }
        this.parameterValues[index] = data;
        this.parameterSet[index] = true;
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (this.statementRetType != 2) {
            return null;
        }
        if (this.resultSetMetaData == null) {
            boolean isUpdatable = ResultProperties.isUpdatable(this.rsProperties);
            boolean isInsertable = isUpdatable;
            if (isInsertable) {
                for (int i = 0; i < this.resultMetaData.colIndexes.length; ++i) {
                    if (this.resultMetaData.colIndexes[i] >= 0) continue;
                    isInsertable = false;
                    break;
                }
            }
            this.resultSetMetaData = new JDBCResultSetMetaData(this.resultMetaData, isUpdatable, isInsertable, this.connection);
        }
        return this.resultSetMetaData;
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        Object value;
        this.checkSetParameterIndex(parameterIndex);
        int index = parameterIndex - 1;
        if (x == null) {
            this.parameterValues[index] = null;
            this.parameterSet[index] = true;
            return;
        }
        Type outType = this.parameterTypes[index];
        switch (outType.typeCode) {
            case 91: 
            case 93: 
            case 95: {
                break;
            }
            default: {
                throw JDBCUtil.sqlException(5561);
            }
        }
        this.parameterValues[index] = value = ((DateTimeType)outType).convertJavaToSQL(this.session, x, cal);
        this.parameterSet[index] = true;
    }

    @Override
    public synchronized void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        Object value;
        this.checkSetParameterIndex(parameterIndex);
        int index = parameterIndex - 1;
        if (x == null) {
            this.parameterValues[index] = null;
            this.parameterSet[index] = true;
            return;
        }
        Type outType = this.parameterTypes[index];
        switch (outType.typeCode) {
            case 92: 
            case 94: {
                break;
            }
            default: {
                throw JDBCUtil.sqlException(5561);
            }
        }
        this.parameterValues[index] = value = ((DateTimeType)outType).convertJavaToSQL(this.session, x, cal);
        this.parameterSet[index] = true;
    }

    @Override
    public synchronized void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        Object value;
        this.checkSetParameterIndex(parameterIndex);
        int index = parameterIndex - 1;
        if (x == null) {
            this.parameterValues[index] = null;
            this.parameterSet[index] = true;
            return;
        }
        Type outType = this.parameterTypes[index];
        switch (outType.typeCode) {
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                break;
            }
            default: {
                throw JDBCUtil.sqlException(5561);
            }
        }
        this.parameterValues[index] = value = ((DateTimeType)outType).convertJavaToSQL(this.session, x, cal);
        this.parameterSet[index] = true;
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setParameter(parameterIndex, null);
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.checkStatementType(1);
        if (!this.isBatch) {
            if (this.connection.isAllowEmptyBatch) {
                return new int[0];
            }
            throw JDBCUtil.sqlExceptionSQL(1256);
        }
        this.generatedResult = null;
        int batchCount = this.resultOut.getNavigator().getSize();
        this.resultIn = null;
        try {
            this.resultIn = this.session.execute(this.resultOut);
        }
        catch (HsqlException e) {
            throw JDBCUtil.sqlException(e);
        }
        finally {
            this.performPostExecute();
            this.resultOut.getNavigator().clear();
            this.isBatch = false;
        }
        if (this.resultIn.mode == 2) {
            throw JDBCUtil.sqlException(this.resultIn);
        }
        RowSetNavigator navigator = this.resultIn.getNavigator();
        int[] updateCounts = new int[navigator.getSize()];
        int i = 0;
        while (navigator.next()) {
            Object[] data = navigator.getCurrent();
            updateCounts[i] = (Integer)data[0];
            ++i;
        }
        if (updateCounts.length != batchCount) {
            if (this.errorResult == null) {
                throw new BatchUpdateException(updateCounts);
            }
            throw new BatchUpdateException(this.errorResult.getMainString(), this.errorResult.getSubString(), this.errorResult.getErrorCode(), updateCounts);
        }
        return updateCounts;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closeResultData();
        HsqlException he = null;
        try {
            if (!this.connection.isClosed) {
                this.session.execute(Result.newFreeStmtRequest(this.statementID));
            }
        }
        catch (HsqlException e) {
            he = e;
        }
        this.parameterValues = null;
        this.parameterSet = null;
        this.parameterTypes = null;
        this.parameterModes = null;
        this.resultMetaData = null;
        this.parameterMetaData = null;
        this.resultSetMetaData = null;
        this.pmd = null;
        this.connection = null;
        this.session = null;
        this.resultIn = null;
        this.resultOut = null;
        this.isClosed = true;
        if (he != null) {
            throw JDBCUtil.sqlException(he);
        }
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        String sql = this.sql;
        Object[] pv = this.parameterValues;
        if (sql == null || pv == null) {
            sb.append("[closed]");
            return sb.toString();
        }
        sb.append("[sql=[").append(sql).append("]");
        if (pv.length > 0) {
            sb.append(", parameters=[");
            for (int i = 0; i < pv.length; ++i) {
                sb.append('[');
                sb.append(pv[i]);
                sb.append("], ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(']');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        if (this.pmd == null) {
            this.pmd = new JDBCParameterMetaData(this.connection, this.parameterMetaData);
        }
        return this.pmd;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized boolean getMoreResults(int current) throws SQLException {
        return super.getMoreResults(current);
    }

    @Override
    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        return this.getGeneratedResultSet();
    }

    @Override
    public synchronized int getResultSetHoldability() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return ResultProperties.getJDBCHoldability(this.rsProperties);
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public synchronized void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public synchronized void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setClob(parameterIndex, value);
    }

    @Override
    public synchronized void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public synchronized void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public synchronized void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (length < 0L) {
            throw JDBCUtil.sqlException(423, "length: " + length);
        }
        this.setAscStream(parameterIndex, x, length);
    }

    void setAscStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw JDBCUtil.sqlException(3401);
        }
        if (x == null) {
            throw JDBCUtil.nullArgument("x");
        }
        try {
            String s = StringConverter.inputStreamToString(x, "US-ASCII");
            if (length >= 0L && (long)s.length() > length) {
                s = s.substring(0, (int)length);
            }
            this.setParameter(parameterIndex, s);
        }
        catch (IOException e) {
            throw JDBCUtil.sqlException(422, null, e);
        }
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (length < 0L) {
            throw JDBCUtil.sqlException(423, "length: " + length);
        }
        if (length > this.parameterTypes[parameterIndex - 1].precision) {
            throw JDBCUtil.sqlException(3401, "length: " + length);
        }
        this.setBinStream(parameterIndex, x, -1L);
    }

    private void setBinStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (this.parameterTypes[parameterIndex - 1].typeCode == 30) {
            this.setBlobParameter(parameterIndex, x, length);
            return;
        }
        if (length > Integer.MAX_VALUE) {
            String msg = "Maximum Blob input length exceeded: " + length;
            throw JDBCUtil.sqlException(422, msg);
        }
        try {
            HsqlByteArrayOutputStream output = length < 0L ? new HsqlByteArrayOutputStream(x) : new HsqlByteArrayOutputStream(x, (int)length);
            this.setParameter(parameterIndex, output.toByteArray());
        }
        catch (Throwable e) {
            throw JDBCUtil.sqlException(422, e.toString(), e);
        }
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (length < 0L) {
            throw JDBCUtil.sqlException(423, "length: " + length);
        }
        if (length > this.parameterTypes[parameterIndex - 1].precision) {
            throw JDBCUtil.sqlException(3401, "length: " + length);
        }
        this.setCharStream(parameterIndex, reader, -1L);
    }

    private void setCharStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkSetParameterIndex(parameterIndex);
        if (this.parameterTypes[parameterIndex - 1].typeCode == 40) {
            this.setClobParameter(parameterIndex, reader, length);
            return;
        }
        if (length > Integer.MAX_VALUE) {
            String msg = "Maximum Clob input length exceeded: " + length;
            throw JDBCUtil.sqlException(422, msg);
        }
        try {
            CharArrayWriter writer = length < 0L ? new CharArrayWriter(reader) : new CharArrayWriter(reader, (int)length);
            this.setParameter(parameterIndex, writer.toString());
        }
        catch (Throwable e) {
            throw JDBCUtil.sqlException(422, e.toString(), e);
        }
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setAscStream(parameterIndex, x, -1L);
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinStream(parameterIndex, x, -1L);
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharStream(parameterIndex, reader, -1L);
    }

    @Override
    public synchronized void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharStream(parameterIndex, value, -1L);
    }

    @Override
    public synchronized void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharStream(parameterIndex, reader, -1L);
    }

    @Override
    public synchronized void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBinStream(parameterIndex, inputStream, -1L);
    }

    @Override
    public synchronized void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharStream(parameterIndex, reader, -1L);
    }

    @Override
    public synchronized int getMaxFieldSize() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return 0;
    }

    @Override
    public synchronized void setMaxFieldSize(int max) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (max < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
    }

    @Override
    public synchronized int getMaxRows() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.maxRows;
    }

    @Override
    public synchronized void setMaxRows(int max) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (max < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        this.maxRows = max;
    }

    @Override
    public synchronized int getQueryTimeout() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.queryTimeout;
    }

    @Override
    public synchronized void setQueryTimeout(int seconds) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (seconds < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (seconds > Short.MAX_VALUE) {
            seconds = Short.MAX_VALUE;
        }
        this.queryTimeout = seconds;
    }

    @Override
    public synchronized void cancel() throws SQLException {
        this.checkClosed();
        String sql = this.resultOut.getMainString();
        int randomId = this.connection.sessionProxy.getRandomId();
        Result request = Result.newCancelRequest(randomId, -1L, sql);
        try {
            Result result = this.connection.sessionProxy.cancel(request);
        }
        catch (HsqlException e) {
            throw JDBCUtil.sqlException(e);
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.rootWarning;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.rootWarning = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        return super.getResultSet();
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        return super.getUpdateCount();
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw JDBCUtil.notSupported();
        }
        this.fetchDirection = direction;
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.fetchDirection;
    }

    @Override
    public synchronized void setFetchSize(int rows) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (rows < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        this.fetchSize = rows;
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.fetchSize;
    }

    @Override
    public synchronized int getResultSetConcurrency() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return ResultProperties.getJDBCConcurrency(this.rsProperties);
    }

    @Override
    public synchronized int getResultSetType() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return ResultProperties.getJDBCScrollability(this.rsProperties);
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (this.isBatch) {
            this.resultOut.getNavigator().clear();
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.connection;
    }

    @Override
    public synchronized void setPoolable(boolean poolable) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.poolable = poolable;
    }

    @Override
    public synchronized boolean isPoolable() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.poolable;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public synchronized long getLargeUpdateCount() throws SQLException {
        return super.getUpdateCount();
    }

    @Override
    public synchronized void setLargeMaxRows(long max) throws SQLException {
        int maxRows = max > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)max;
        this.setMaxRows(maxRows);
    }

    @Override
    public synchronized long getLargeMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException {
        int[] updateCounts = this.executeBatch();
        long[] longCounts = new long[updateCounts.length];
        for (int i = 0; i < updateCounts.length; ++i) {
            longCounts[i] = updateCounts[i];
        }
        return longCounts;
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        int typeNo = targetSqlType.getVendorTypeNumber();
        this.setObject(parameterIndex, x, typeNo, scaleOrLength);
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        int typeNo = targetSqlType.getVendorTypeNumber();
        this.setObject(parameterIndex, x, typeNo);
    }

    @Override
    public synchronized long executeLargeUpdate() throws SQLException {
        return this.executeUpdate();
    }

    JDBCPreparedStatement(JDBCConnection c, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int generatedKeys, int[] generatedIndexes, String[] generatedNames) throws HsqlException, SQLException {
        this.isResult = false;
        this.connection = c;
        this.connectionIncarnation = this.connection.incarnation;
        this.session = c.sessionProxy;
        sql = c.nativeSQL(sql);
        this.resultOut = Result.newPrepareStatementRequest();
        int props = ResultProperties.getValueForJDBC(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.resultOut.setPrepareOrExecuteProperties(sql, 0, 0, 0, this.queryTimeout, props, generatedKeys, generatedIndexes, generatedNames);
        Result in = this.session.execute(this.resultOut);
        if (in.mode == 2) {
            throw JDBCUtil.sqlException(in);
        }
        this.rootWarning = null;
        Result current = in;
        while (current.getChainedResult() != null) {
            if (!(current = current.getUnlinkChainedResult()).isWarning()) continue;
            SQLWarning w = JDBCUtil.sqlWarning(current);
            if (this.rootWarning == null) {
                this.rootWarning = w;
                continue;
            }
            this.rootWarning.setNextWarning(w);
        }
        this.connection.setWarnings(this.rootWarning);
        this.statementID = in.getStatementID();
        this.statementRetType = in.getStatementType();
        this.resultMetaData = in.metaData;
        this.parameterMetaData = in.parameterMetaData;
        this.parameterTypes = this.parameterMetaData.getParameterTypes();
        this.parameterModes = this.parameterMetaData.paramModes;
        this.rsProperties = in.rsProperties;
        int paramCount = this.parameterMetaData.getColumnCount();
        this.parameterValues = new Object[paramCount];
        this.parameterSet = new boolean[paramCount];
        this.streamLengths = new long[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            if (!this.parameterTypes[i].isLobType()) continue;
            this.hasLOBs = true;
            break;
        }
        this.resultOut = Result.newPreparedExecuteRequest(this.parameterTypes, this.statementID);
        this.resultOut.setStatement(in.getStatement());
        this.sql = sql;
    }

    JDBCPreparedStatement(JDBCConnection c, Result result) {
        this.isResult = true;
        this.connection = c;
        this.connectionIncarnation = this.connection.incarnation;
        this.session = c.sessionProxy;
        int paramCount = result.metaData.getExtendedColumnCount();
        this.parameterMetaData = result.metaData;
        this.parameterTypes = result.metaData.columnTypes;
        this.parameterModes = new byte[paramCount];
        this.parameterValues = new Object[paramCount];
        this.parameterSet = new boolean[paramCount];
        this.streamLengths = new long[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            this.parameterModes[i] = 1;
            if (!this.parameterTypes[i].isLobType()) continue;
            this.hasLOBs = true;
        }
        this.resultOut = Result.newUpdateResultRequest(this.parameterTypes, result.getResultId());
    }

    protected void checkStatementType(int type) throws SQLException {
        if (type != this.statementRetType) {
            if (this.statementRetType == 1) {
                throw JDBCUtil.sqlException(1254);
            }
            throw JDBCUtil.sqlException(1253);
        }
    }

    protected void checkParameterIndex(int i) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (i < 1 || i > this.parameterValues.length) {
            String msg = "parameter index out of range: " + i;
            throw JDBCUtil.outOfRangeArgument(msg);
        }
    }

    protected void checkSetParameterIndex(int parameterIndex) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (parameterIndex < 1 || parameterIndex > this.parameterValues.length) {
            String msg = "parameter index out of range: " + parameterIndex;
            throw JDBCUtil.outOfRangeArgument(msg);
        }
        if (this.parameterModes[parameterIndex - 1] == 4) {
            String msg = "Not IN or INOUT mode for parameter: " + parameterIndex;
            throw JDBCUtil.invalidArgument(msg);
        }
    }

    protected void checkGetParameterIndex(int parameterIndex) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (parameterIndex < 1 || parameterIndex > this.parameterValues.length) {
            String msg = "parameter index out of range: " + parameterIndex;
            throw JDBCUtil.outOfRangeArgument(msg);
        }
        byte mode = this.parameterModes[parameterIndex - 1];
        switch (mode) {
            case 0: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                String msg = "Not OUT or INOUT mode for parameter: " + parameterIndex;
                throw JDBCUtil.invalidArgument(msg);
            }
        }
    }

    private void checkParametersSet() throws SQLException {
        if (this.isResult) {
            return;
        }
        for (int i = 0; i < this.parameterSet.length; ++i) {
            if (this.parameterModes[i] == 4 || this.parameterSet[i]) continue;
            throw JDBCUtil.sqlException(424);
        }
    }

    void setParameter(int parameterIndex, Object o) throws SQLException {
        this.checkSetParameterIndex(parameterIndex);
        int index = parameterIndex - 1;
        if (o == null) {
            this.parameterValues[index] = null;
            this.parameterSet[index] = true;
            return;
        }
        Type outType = this.parameterTypes[index];
        switch (outType.typeCode) {
            case 1111: {
                try {
                    if (this.connection.isStoreLiveObject) {
                        o = new JavaObjectDataInternal(o);
                        break;
                    }
                    if (o instanceof Serializable) {
                        o = new JavaObjectData((Serializable)o);
                        break;
                    }
                }
                catch (HsqlException e) {
                    throw JDBCUtil.sqlException(e);
                }
                throw JDBCUtil.sqlException(5563);
            }
            case 14: 
            case 15: {
                try {
                    if (o instanceof Boolean) {
                        o = outType.convertToDefaultType(this.session, o);
                        break;
                    }
                    if (o instanceof Integer) {
                        o = outType.convertToDefaultType(this.session, o);
                        break;
                    }
                    if (o instanceof byte[]) {
                        o = outType.convertToDefaultType(this.session, o);
                        break;
                    }
                    if (o instanceof String) {
                        o = outType.convertToDefaultType(this.session, o);
                        break;
                    }
                    if (o instanceof BitSet) {
                        o = outType.convertToDefaultType(this.session, o);
                        break;
                    }
                }
                catch (HsqlException e) {
                    throw JDBCUtil.sqlException(e);
                }
                throw JDBCUtil.sqlException(5563);
            }
            case -11: 
            case 60: 
            case 61: {
                if (o instanceof byte[]) {
                    o = new BinaryData((byte[])o, !this.connection.isNetConn);
                    break;
                }
                if (o instanceof UUID) {
                    o = BinaryUUIDType.getBinary((UUID)o);
                    break;
                }
                try {
                    if (o instanceof String) {
                        o = outType.convertToDefaultType(this.session, o);
                        break;
                    }
                }
                catch (HsqlException e) {
                    throw JDBCUtil.sqlException(e);
                }
                throw JDBCUtil.sqlException(5563);
            }
            case 50: {
                if (o instanceof Array) {
                    this.setArray(parameterIndex, (Array)o);
                    return;
                }
                if (o instanceof ArrayList) {
                    o = ((ArrayList)o).toArray();
                }
                if (o instanceof Object[]) {
                    Type baseType = outType.collectionBaseType();
                    Object array = o;
                    Object[] data = new Object[((Object[])array).length];
                    for (int j = 0; j < data.length; ++j) {
                        data[j] = baseType.convertJavaToSQL(this.session, array[j]);
                    }
                    o = data;
                    break;
                }
                throw JDBCUtil.sqlException(5563);
            }
            case 30: {
                this.setBlobParameter(parameterIndex, o);
                return;
            }
            case 40: {
                this.setClobParameter(parameterIndex, o);
                return;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                try {
                    if (o instanceof String) {
                        o = outType.convertToType(this.session, o, Type.SQL_VARCHAR);
                        break;
                    }
                    o = outType.convertJavaToSQL(this.session, o);
                    break;
                }
                catch (HsqlException e) {
                    throw JDBCUtil.sqlException(e);
                }
            }
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                try {
                    if (o instanceof String) {
                        o = outType.convertToType(this.session, o, Type.SQL_VARCHAR);
                        break;
                    }
                    if (o instanceof Boolean) {
                        boolean value = (Boolean)o;
                        o = value ? Integer.valueOf(1) : Integer.valueOf(0);
                    }
                    o = outType.convertToDefaultType(this.session, o);
                    break;
                }
                catch (HsqlException e) {
                    throw JDBCUtil.sqlException(e);
                }
            }
            case 12: {
                if (o instanceof String) break;
                try {
                    o = outType.convertToDefaultType(this.session, o);
                    break;
                }
                catch (HsqlException e) {
                    throw JDBCUtil.sqlException(e);
                }
            }
            case 1: {
                if (o instanceof String) break;
                if (outType.precision == 1L) {
                    if (o instanceof Character) {
                        o = String.valueOf(((Character)o).charValue());
                        break;
                    }
                    if (o instanceof Boolean) {
                        o = (Boolean)o != false ? "1" : "0";
                        break;
                    }
                }
                try {
                    o = outType.convertToDefaultType(this.session, o);
                    break;
                }
                catch (HsqlException e) {
                    throw JDBCUtil.sqlException(e);
                }
            }
            default: {
                try {
                    if (outType.isIntervalType()) {
                        o = outType.convertJavaToSQL(this.session, o);
                        break;
                    }
                    o = outType.convertToDefaultType(this.session, o);
                    break;
                }
                catch (HsqlException e) {
                    throw JDBCUtil.sqlException(e);
                }
            }
        }
        this.parameterValues[index] = o;
        this.parameterSet[index] = true;
    }

    void setClobParameter(int i, Object o) throws SQLException {
        this.setClobParameter(i, o, 0L);
    }

    void setClobParameter(int i, Object o, long streamLength) throws SQLException {
        if (o instanceof JDBCClobClient) {
            JDBCClobClient clob = (JDBCClobClient)o;
            if (!clob.session.getDatabaseUniqueName().equals(this.session.getDatabaseUniqueName())) {
                streamLength = clob.length();
                Reader is = clob.getCharacterStream();
                this.parameterValues[i - 1] = is;
                this.streamLengths[i - 1] = streamLength;
                this.parameterSet[i - 1] = true;
                return;
            }
            this.parameterValues[i - 1] = o;
            this.parameterSet[i - 1] = Boolean.TRUE;
            return;
        }
        if (o instanceof Clob) {
            this.parameterValues[i - 1] = o;
            this.parameterSet[i - 1] = Boolean.TRUE;
            return;
        }
        if (o instanceof ClobInputStream) {
            ClobInputStream is = (ClobInputStream)o;
            if (is.session.getDatabaseUniqueName().equals(this.session.getDatabaseUniqueName())) {
                throw JDBCUtil.sqlException(423, "invalid Reader");
            }
            this.parameterValues[i - 1] = o;
            this.streamLengths[i - 1] = streamLength;
            this.parameterSet[i - 1] = true;
            return;
        }
        if (o instanceof Reader) {
            this.parameterValues[i - 1] = o;
            this.streamLengths[i - 1] = streamLength;
            this.parameterSet[i - 1] = true;
            return;
        }
        if (o instanceof String) {
            JDBCClob clob = new JDBCClob((String)o);
            this.parameterValues[i - 1] = clob;
            this.parameterSet[i - 1] = true;
            return;
        }
        throw JDBCUtil.invalidArgument();
    }

    void setBlobParameter(int i, Object o) throws SQLException {
        this.setBlobParameter(i, o, 0L);
    }

    void setBlobParameter(int i, Object o, long streamLength) throws SQLException {
        if (o instanceof JDBCBlobClient) {
            JDBCBlobClient blob = (JDBCBlobClient)o;
            if (!blob.session.getDatabaseUniqueName().equals(this.session.getDatabaseUniqueName())) {
                streamLength = blob.length();
                InputStream is = blob.getBinaryStream();
                this.parameterValues[i - 1] = is;
                this.streamLengths[i - 1] = streamLength;
                this.parameterSet[i - 1] = true;
                return;
            }
            this.parameterValues[i - 1] = o;
            this.parameterSet[i - 1] = Boolean.TRUE;
            return;
        }
        if (o instanceof Blob) {
            this.parameterValues[i - 1] = o;
            this.parameterSet[i - 1] = true;
            return;
        }
        if (o instanceof BlobInputStream) {
            BlobInputStream is = (BlobInputStream)o;
            if (is.session.getDatabaseUniqueName().equals(this.session.getDatabaseUniqueName())) {
                throw JDBCUtil.sqlException(423, "invalid Reader");
            }
            this.parameterValues[i - 1] = o;
            this.streamLengths[i - 1] = streamLength;
            this.parameterSet[i - 1] = true;
            return;
        }
        if (o instanceof InputStream) {
            this.parameterValues[i - 1] = o;
            this.streamLengths[i - 1] = streamLength;
            this.parameterSet[i - 1] = true;
            return;
        }
        if (o instanceof byte[]) {
            JDBCBlob blob = new JDBCBlob((byte[])o);
            this.parameterValues[i - 1] = blob;
            this.parameterSet[i - 1] = true;
            return;
        }
        throw JDBCUtil.invalidArgument();
    }

    void setIntParameter(int parameterIndex, int value) throws SQLException {
        this.checkSetParameterIndex(parameterIndex);
        int index = parameterIndex - 1;
        int outType = this.parameterTypes[index].typeCode;
        switch (outType) {
            case -6: 
            case 4: 
            case 5: {
                Integer o = value;
                this.parameterValues[index] = o;
                this.parameterSet[index] = true;
                break;
            }
            case 25: {
                Long o = value;
                this.parameterValues[index] = o;
                this.parameterSet[index] = true;
                break;
            }
            case 60: 
            case 61: 
            case 1111: {
                throw JDBCUtil.sqlException(5563);
            }
            default: {
                this.setParameter(parameterIndex, value);
            }
        }
    }

    void setLongParameter(int parameterIndex, long value) throws SQLException {
        this.checkSetParameterIndex(parameterIndex);
        int index = parameterIndex - 1;
        int outType = this.parameterTypes[index].typeCode;
        switch (outType) {
            case 25: {
                Long o = value;
                this.parameterValues[index] = o;
                this.parameterSet[index] = true;
                break;
            }
            case 60: 
            case 61: 
            case 1111: {
                throw JDBCUtil.sqlException(5563);
            }
            default: {
                this.setParameter(parameterIndex, value);
            }
        }
    }

    private void performPreExecute() throws SQLException, HsqlException {
        if (!this.hasLOBs) {
            return;
        }
        for (int i = 0; i < this.parameterValues.length; ++i) {
            ResultLob resultLob;
            ResultLob resultLob2;
            long length;
            long id;
            Object value = this.parameterValues[i];
            if (value == null) continue;
            if (this.parameterTypes[i].typeCode == 30) {
                BlobDataID blob = null;
                if (value instanceof JDBCBlobClient) {
                    blob = ((JDBCBlobClient)value).blob;
                    id = blob.getId();
                } else if (value instanceof Blob) {
                    length = ((Blob)value).length();
                    blob = this.session.createBlob(length);
                    id = blob.getId();
                    InputStream stream = ((Blob)value).getBinaryStream();
                    resultLob2 = ResultLob.newLobCreateBlobRequest(this.session.getId(), id, stream, length);
                    this.session.allocateResultLob(resultLob2);
                    this.resultOut.addLobResult(resultLob2);
                } else if (value instanceof InputStream) {
                    length = this.streamLengths[i];
                    long createLength = length > 0L ? length : 0L;
                    blob = this.session.createBlob(createLength);
                    id = blob.getId();
                    InputStream stream = (InputStream)value;
                    resultLob = ResultLob.newLobCreateBlobRequest(this.session.getId(), id, stream, length);
                    this.session.allocateResultLob(resultLob);
                    this.resultOut.addLobResult(resultLob);
                } else if (value instanceof BlobDataID) {
                    blob = (BlobDataID)value;
                }
                this.parameterValues[i] = blob;
                continue;
            }
            if (this.parameterTypes[i].typeCode != 40) continue;
            ClobDataID clob = null;
            if (value instanceof JDBCClobClient) {
                clob = ((JDBCClobClient)value).clob;
                id = clob.getId();
            } else if (value instanceof Clob) {
                length = ((Clob)value).length();
                Reader reader = ((Clob)value).getCharacterStream();
                clob = this.session.createClob(length);
                id = clob.getId();
                resultLob2 = ResultLob.newLobCreateClobRequest(this.session.getId(), id, reader, length);
                this.session.allocateResultLob(resultLob2);
                this.resultOut.addLobResult(resultLob2);
            } else if (value instanceof Reader) {
                length = this.streamLengths[i];
                long createLength = length > 0L ? length : 0L;
                clob = this.session.createClob(createLength);
                id = clob.getId();
                Reader reader = (Reader)value;
                resultLob = ResultLob.newLobCreateClobRequest(this.session.getId(), id, reader, length);
                this.session.allocateResultLob(resultLob);
                this.resultOut.addLobResult(resultLob);
            } else if (value instanceof ClobDataID) {
                clob = (ClobDataID)value;
            }
            this.parameterValues[i] = clob;
        }
    }

    void fetchResult() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.closeResultData();
        this.checkParametersSet();
        if (this.isBatch) {
            throw JDBCUtil.sqlExceptionSQL(1255);
        }
        if (this.isResult) {
            this.resultOut.setPreparedResultUpdateProperties(this.parameterValues);
        } else {
            this.resultOut.setPreparedExecuteProperties(this.parameterValues, this.maxRows, this.fetchSize, this.rsProperties, this.queryTimeout);
        }
        try {
            this.performPreExecute();
            this.resultIn = this.session.execute(this.resultOut);
        }
        catch (HsqlException e) {
            throw JDBCUtil.sqlException(e);
        }
        finally {
            this.performPostExecute();
        }
        if (this.resultIn.mode == 2) {
            throw JDBCUtil.sqlException(this.resultIn);
        }
        if (this.resultIn.isData()) {
            this.currentResultSet = new JDBCResultSet(this.connection, this, this.resultIn, this.resultIn.metaData);
        } else if (this.statementRetType == 2) {
            this.getMoreResults();
        }
    }

    @Override
    void performPostExecute() throws SQLException {
        super.performPostExecute();
    }

    public String getSQL() {
        return this.sql;
    }

    public long getStatementID() {
        return this.statementID;
    }

    public boolean isRowCount() {
        return this.statementRetType == 1;
    }

    public JDBCResultSetMetaData getResultSetMetaData() {
        return this.resultSetMetaData;
    }

    public ResultMetaData getParameterMetaDataDirect() {
        return this.parameterMetaData;
    }
}

