/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLWarning;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;

public final class JDBCUtil {
    public static SQLException sqlException(HsqlException e) {
        return JDBCUtil.sqlException(e.getMessage(), e.getSQLState(), e.getErrorCode(), e);
    }

    public static SQLException sqlException(HsqlException e, Throwable cause) {
        return JDBCUtil.sqlException(e.getMessage(), e.getSQLState(), e.getErrorCode(), cause);
    }

    public static SQLException sqlException(int id) {
        return JDBCUtil.sqlException(Error.error(id));
    }

    public static SQLException sqlExceptionSQL(int id) {
        return JDBCUtil.sqlException(Error.error(id));
    }

    public static SQLException sqlException(int id, String message) {
        return JDBCUtil.sqlException(Error.error(id, message));
    }

    public static SQLException sqlException(int id, String message, Throwable cause) {
        return JDBCUtil.sqlException(Error.error(id, message), cause);
    }

    public static SQLException sqlException(int id, int add) {
        return JDBCUtil.sqlException(Error.error(id, add));
    }

    static SQLException sqlException(int id, int subId, String[] add) {
        return JDBCUtil.sqlException(Error.error(null, id, subId, add));
    }

    static SQLException notSupported() {
        HsqlException e = Error.error(1500);
        return new SQLFeatureNotSupportedException(e.getMessage(), e.getSQLState(), -1500);
    }

    static SQLException notUpdatableColumn() {
        return JDBCUtil.sqlException(2500);
    }

    public static SQLException nullArgument() {
        return JDBCUtil.sqlException(423);
    }

    static SQLException nullArgument(String name) {
        return JDBCUtil.sqlException(423, name + ": null");
    }

    public static SQLException invalidArgument() {
        return JDBCUtil.sqlException(423);
    }

    public static SQLException invalidArgument(String name) {
        return JDBCUtil.sqlException(423, name);
    }

    public static SQLException invalidArgument(int id) {
        String message = Error.getMessage(id);
        return JDBCUtil.sqlException(423, message);
    }

    public static SQLException outOfRangeArgument() {
        return JDBCUtil.sqlException(423);
    }

    public static SQLException outOfRangeArgument(String name) {
        return JDBCUtil.sqlException(423, name);
    }

    public static SQLException connectionClosedException() {
        return JDBCUtil.sqlException(1303);
    }

    public static SQLWarning sqlWarning(Result r) {
        return new SQLWarning(r.getMainString(), r.getSubString(), r.getErrorCode());
    }

    public static SQLException sqlException(Throwable t) {
        return new SQLException(t);
    }

    public static SQLException sqlException(Result r) {
        return JDBCUtil.sqlException(r.getMainString(), r.getSubString(), r.getErrorCode(), r.getException());
    }

    public static SQLException sqlException(String msg, String sqlstate, int code, Throwable cause) {
        if (sqlstate.startsWith("08")) {
            if (!sqlstate.endsWith("3")) {
                return new SQLTransientConnectionException(msg, sqlstate, code, cause);
            }
            return new SQLNonTransientConnectionException(msg, sqlstate, code, cause);
        }
        if (sqlstate.startsWith("22")) {
            return new SQLDataException(msg, sqlstate, code, cause);
        }
        if (sqlstate.startsWith("23")) {
            return new SQLIntegrityConstraintViolationException(msg, sqlstate, code, cause);
        }
        if (sqlstate.startsWith("28")) {
            return new SQLInvalidAuthorizationSpecException(msg, sqlstate, code, cause);
        }
        if (sqlstate.startsWith("42") || sqlstate.startsWith("37") || sqlstate.startsWith("2A")) {
            return new SQLSyntaxErrorException(msg, sqlstate, code, cause);
        }
        if (sqlstate.startsWith("40")) {
            return new SQLTransactionRollbackException(msg, sqlstate, code, cause);
        }
        if (sqlstate.startsWith("0A")) {
            return new SQLFeatureNotSupportedException(msg, sqlstate, code, cause);
        }
        return new SQLException(msg, sqlstate, code, cause);
    }
}

