/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCConnectionEventListener;
import org.hsqldb.lib.OrderedHashSet;

public class JDBCPooledConnection
implements PooledConnection,
JDBCConnectionEventListener {
    protected OrderedHashSet listeners = new OrderedHashSet();
    protected JDBCConnection connection;
    protected JDBCConnection userConnection;
    protected boolean isInUse;

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (this.isInUse) {
            throw new SQLException("Connection in use");
        }
        this.isInUse = true;
        this.userConnection = new JDBCConnection(this.connection, this);
        return this.userConnection;
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.closeFully();
            this.connection = null;
        }
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
    }

    @Override
    public synchronized void connectionClosed() {
        ConnectionEvent event = new ConnectionEvent(this);
        this.userConnection = null;
        this.reset();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.listeners.get(i);
            connectionEventListener.connectionClosed(event);
        }
    }

    @Override
    public synchronized void connectionErrorOccurred(SQLException e) {
        ConnectionEvent event = new ConnectionEvent(this, e);
        this.reset();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.listeners.get(i);
            connectionEventListener.connectionErrorOccurred(event);
        }
    }

    public synchronized boolean isInUse() {
        return this.isInUse;
    }

    public synchronized void reset() {
        if (this.userConnection != null) {
            try {
                this.userConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            this.connection.reset();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.isInUse = false;
    }

    public synchronized void release() {
        if (this.userConnection != null) {
            try {
                this.userConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.isInUse = false;
    }

    public JDBCPooledConnection(JDBCConnection connection) {
        this.connection = connection;
    }
}

