/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

public final class ArrayCounter {
    public static int[] countSegments(int[] array, int elementCount, int segments, int interval, int start, int limit) {
        int[] counts = new int[segments];
        if (interval <= 0) {
            return counts;
        }
        for (int i = 0; i < elementCount; ++i) {
            int index;
            int element = array[i];
            if (element < start || element >= limit) continue;
            int n = index = (element - start) / interval;
            counts[n] = counts[n] + 1;
        }
        return counts;
    }

    public static int rank(int[] array, int elements, int target, int start, int limit, int margin) {
        int segments = 256;
        int elementCount = 0;
        int currentLimit = limit;
        while (true) {
            int interval = ArrayCounter.calcInterval(256, start, currentLimit);
            int[] counts = ArrayCounter.countSegments(array, elements, 256, interval, start, currentLimit);
            for (int i = 0; i < counts.length && elementCount + counts[i] < target; ++i) {
                elementCount += counts[i];
                start += interval;
            }
            if (elementCount + margin >= target) {
                return start;
            }
            if (interval <= 1) {
                return start;
            }
            currentLimit = start + interval < limit ? start + interval : limit;
        }
    }

    static int calcInterval(int segments, int start, int limit) {
        int range = limit - start;
        if (range <= 0) {
            return 0;
        }
        int partSegment = range % segments == 0 ? 0 : 1;
        return range / segments + partSegment;
    }
}

