/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Objects;

public class AsciiInputStream
extends InputStream {
    public static final int ASCII_BITS = 7;
    public static final int ASCII_MASK = 127;
    public static final int ASCII_MAX = 127;
    public static final int NON_ASCII_MIN = 128;
    public static final int NON_ASCII_REPLACEMENT = 63;
    private boolean hasNextChar = false;
    private int nextChar = 0;
    private final Reader reader;

    public AsciiInputStream(Reader reader) {
        this.reader = Objects.requireNonNull(reader, "reader must not be null");
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.hasNextChar) {
            this.hasNextChar = false;
            return this.nextChar;
        }
        int c = this.reader.read();
        if (c < 0) {
            return -1;
        }
        if (Character.isHighSurrogate((char)c)) {
            int nc = this.reader.read();
            boolean bl = this.hasNextChar = !Character.isLowSurrogate((char)nc);
            if (this.hasNextChar) {
                this.nextChar = nc < 128 ? nc & 0x7F : 63;
            }
        }
        return c < 128 ? c & 0x7F : 63;
    }
}

