/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Objects;

public class AsciiOutputStream
extends OutputStream {
    public static final int ASCII_BITS = 7;
    public static final int ASCII_MASK = 127;
    public static final int ASCII_MAX = 127;
    public static final int NON_ASCII_MIN = 128;
    public static final int NON_ASCII_REPLACEMENT = 65533;
    private final Writer writer;

    public AsciiOutputStream(Writer writer) {
        this.writer = Objects.requireNonNull(writer, "writer must not be null.");
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.writer.write(b < 128 ? b & 0x7F : 65533);
    }
}

