/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.ObjectComparator;

abstract class BaseList<E> {
    protected ObjectComparator comparator = ObjectComparator.defaultComparator;
    protected int elementCount;

    BaseList() {
    }

    public abstract E get(int var1);

    public abstract E remove(int var1);

    public abstract boolean add(E var1);

    public abstract int size();

    public boolean contains(Object element) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E current = this.get(i);
            if (!this.comparator.equals(current, element)) continue;
            return true;
        }
        return false;
    }

    public boolean remove(Object element) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E current = this.get(i);
            if (!this.comparator.equals(current, element)) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    public int indexOf(E element) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E current = this.get(i);
            if (!this.comparator.equals(current, element)) continue;
            return i;
        }
        return -1;
    }

    public boolean addAll(Collection<? extends E> other) {
        boolean result = false;
        Iterator<E> it = other.iterator();
        while (it.hasNext()) {
            result = true;
            this.add(it.next());
        }
        return result;
    }

    public boolean addAll(E[] array) {
        boolean result = false;
        for (E object : array) {
            result = true;
            this.add(object);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32 + this.elementCount * 3);
        sb.append("List : size=");
        sb.append(this.elementCount);
        sb.append(' ');
        sb.append('{');
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    public Iterator<E> iterator() {
        return new BaseListIterator();
    }

    private class BaseListIterator
    implements Iterator<E> {
        int counter = 0;
        boolean removed;

        private BaseListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.counter < BaseList.this.elementCount;
        }

        @Override
        public E next() {
            if (this.counter < BaseList.this.elementCount) {
                this.removed = false;
                Object returnValue = BaseList.this.get(this.counter);
                ++this.counter;
                return returnValue;
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextInt() {
            throw new NoSuchElementException();
        }

        @Override
        public long nextLong() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.removed) {
                throw new NoSuchElementException("Iterator");
            }
            this.removed = true;
            if (this.counter != 0) {
                BaseList.this.remove(this.counter - 1);
                --this.counter;
                return;
            }
            throw new NoSuchElementException();
        }
    }
}

