/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CountUpDownLatch {
    private final Sync sync;

    public CountUpDownLatch() {
        this(0);
    }

    public CountUpDownLatch(int initialCount) {
        if (initialCount < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        this.sync = new Sync(initialCount);
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    public boolean countUp() {
        return this.sync.countUp();
    }

    public boolean countUp(int amount) {
        return this.sync.countUp(amount);
    }

    public boolean countDown() {
        return this.sync.countDown();
    }

    public boolean countDown(int amount) {
        return this.sync.countDown(amount);
    }

    public int getCount() {
        return this.sync.getCount();
    }

    public boolean setCount(int newCount) {
        return this.sync.setCount(newCount);
    }

    public String toString() {
        return String.format("%s[count=%d]", super.toString(), this.sync.getCount());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(CountUpDownLatch other) {
        return this == other;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    private static class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 7224851200740908493L;

        Sync(int count) {
            this.setState(count);
        }

        @Override
        protected boolean tryReleaseShared(int arg) {
            return arg == 0;
        }

        int getCount() {
            return this.getState();
        }

        @Override
        protected int tryAcquireShared(int ignored) {
            return this.getState() == 0 ? 1 : -1;
        }

        boolean setCount(int newCount) {
            int c;
            if (newCount < 0) {
                throw new IllegalArgumentException(String.format("amount must be non-negative: %d", newCount));
            }
            boolean requestedZero = newCount == 0;
            do {
                c = this.getState();
                if (!requestedZero || c != 0) continue;
                return false;
            } while (!this.compareAndSetState(c, newCount));
            return requestedZero ? this.releaseShared(0) : false;
        }

        boolean countDown() {
            int nextc;
            int c;
            do {
                if ((c = this.getState()) != 0) continue;
                return false;
            } while (!super.compareAndSetState(c, nextc = c - 1));
            if (nextc == 0) {
                return this.releaseShared(0);
            }
            return false;
        }

        boolean countDown(int amount) {
            int nextc;
            int c;
            if (amount < 1) {
                throw new IllegalArgumentException(String.format("Amount must be positive: %d", amount));
            }
            do {
                if ((c = this.getState()) != 0) continue;
                return false;
            } while (!super.compareAndSetState(c, nextc = amount >= c ? 0 : c - amount));
            return nextc == 0 ? this.releaseShared(0) : false;
        }

        boolean countUp() {
            int nextc;
            int c;
            do {
                if ((c = this.getState()) != Integer.MAX_VALUE) continue;
                throw new ArithmeticException(String.format("integer overflow: %d + 1", c));
            } while (!super.compareAndSetState(c, nextc = c + 1));
            return c == 0;
        }

        boolean countUp(int amount) {
            int nextc;
            int c;
            if (amount < 1) {
                throw new IllegalArgumentException(String.format("amount must be positive: %d", amount));
            }
            do {
                if (amount <= Integer.MAX_VALUE - (c = this.getState())) continue;
                throw new ArithmeticException(String.format("integer overflow: %d", amount));
            } while (!super.compareAndSetState(c, nextc = c + amount));
            return c == 0;
        }
    }
}

