/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.LongLookup;

public final class DoubleLongIndex
implements LongLookup {
    private int count = 0;
    private int capacity;
    private boolean sorted = true;
    private long[] keys;
    private long[] values;
    private long targetSearchValue;

    public DoubleLongIndex(int capacity) {
        this.capacity = capacity;
        this.keys = new long[capacity];
        this.values = new long[capacity];
    }

    @Override
    public long getLongKey(int i) {
        if (i < 0 || i >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.keys[i];
    }

    @Override
    public long getLongValue(int i) {
        if (i < 0 || i >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[i];
    }

    @Override
    public void setLongValue(int i, long value) {
        if (i < 0 || i >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        this.values[i] = value;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public long getTotalValues() {
        long total = 0L;
        for (int i = 0; i < this.count; ++i) {
            total += this.values[i];
        }
        return total;
    }

    public void setSize(int newSize) {
        this.count = newSize;
    }

    @Override
    public boolean addUnsorted(long key, long value) {
        if (this.count == this.capacity) {
            this.doubleCapacity();
        }
        if (this.sorted && this.count != 0 && key < this.keys[this.count - 1]) {
            this.sorted = false;
        }
        this.keys[this.count] = key;
        this.values[this.count] = value;
        ++this.count;
        return true;
    }

    @Override
    public int add(long key, long value) {
        if (this.count == this.capacity) {
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = key;
        int i = this.binarySlotSearch(true);
        if (this.count != i) {
            this.moveRows(i, i + 1, this.count - i);
        }
        this.keys[i] = key;
        this.values[i] = value;
        ++this.count;
        return i;
    }

    @Override
    public long lookup(long key) throws NoSuchElementException {
        int i = this.findFirstEqualKeyIndex(key);
        if (i == -1) {
            throw new NoSuchElementException();
        }
        return this.getLongValue(i);
    }

    @Override
    public long lookup(long key, long def) {
        int i = this.findFirstEqualKeyIndex(key);
        if (i == -1) {
            return def;
        }
        return this.getLongValue(i);
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, 0L);
        Arrays.fill(this.values, 0L);
        this.count = 0;
        this.sorted = true;
    }

    @Override
    public LongLookup duplicate() {
        DoubleLongIndex duplicate = new DoubleLongIndex(this.capacity);
        this.copyTo(duplicate);
        return duplicate;
    }

    public int findFirstGreaterEqualKeyIndex(long value) {
        int index = this.findFirstGreaterEqualSlotIndex(value);
        return index == this.count ? -1 : index;
    }

    public int findFirstEqualKeyIndex(long value) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = value;
        return this.binaryFirstSearch();
    }

    public int findFirstGreaterEqualSlotIndex(long value) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = value;
        return this.binarySlotSearch(false);
    }

    @Override
    public boolean compactLookupAsIntervals() {
        int i;
        if (this.size() == 0) {
            return false;
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        int base = 0;
        for (i = 1; i < this.count; ++i) {
            long limit = this.keys[base] + this.values[base];
            if (limit == this.keys[i]) {
                int n = base;
                this.values[n] = this.values[n] + this.values[i];
                continue;
            }
            this.keys[++base] = this.keys[i];
            this.values[base] = this.values[i];
        }
        for (i = base + 1; i < this.count; ++i) {
            this.keys[i] = 0L;
            this.values[i] = 0L;
        }
        if (this.count != base + 1) {
            this.setSize(base + 1);
            return true;
        }
        return false;
    }

    private int binaryFirstSearch() {
        int low = 0;
        int high = this.count;
        int mid = 0;
        int compare = 0;
        int found = this.count;
        while (low < high) {
            mid = low + high >>> 1;
            compare = this.compare(mid);
            if (compare < 0) {
                high = mid;
                continue;
            }
            if (compare > 0) {
                low = mid + 1;
                continue;
            }
            high = mid;
            found = mid;
        }
        return found == this.count ? -1 : found;
    }

    private int binarySlotSearch(boolean fullCompare) {
        int low = 0;
        int high = this.count;
        int mid = 0;
        int compare = 0;
        while (low < high) {
            mid = low + high >>> 1;
            compare = this.compare(mid);
            if (compare <= 0) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return low;
    }

    @Override
    public void sort() {
        if (this.count <= 16384) {
            this.fastQuickSortRecursive();
        } else {
            this.fastQuickSort();
        }
    }

    private void fastQuickSort() {
        DoubleIntIndex indices = new DoubleIntIndex(32768);
        int threshold = 16;
        indices.push(0, this.count - 1);
        while (indices.size() > 0) {
            int start = indices.peekKey();
            int end = indices.peekValue();
            indices.pop();
            if (end - start < threshold) continue;
            int pivot = this.partition(start, end);
            indices.push(start, pivot - 1);
            indices.push(pivot + 1, end);
        }
        this.insertionSort(0, this.count - 1);
        this.sorted = true;
    }

    private int partition(int start, int end) {
        int pivot = start + end >>> 1;
        if (this.keys[pivot] < this.keys[start + pivot >>> 1]) {
            this.swap(pivot, start + pivot >>> 1);
        }
        if (this.keys[end + pivot >>> 1] < this.keys[start + pivot >>> 1]) {
            this.swap(end + pivot >>> 1, start + pivot >>> 1);
        }
        if (this.keys[end + pivot >>> 1] < this.keys[pivot]) {
            this.swap(end + pivot >>> 1, pivot);
        }
        long pivotValue = this.keys[pivot];
        int i = start - 1;
        int j = end;
        this.swap(pivot, end);
        while (true) {
            if (this.keys[++i] < pivotValue) {
                continue;
            }
            while (pivotValue < this.keys[--j]) {
            }
            if (j < i) break;
            this.swap(i, j);
        }
        this.swap(i, end);
        return i;
    }

    private void fastQuickSortRecursive() {
        this.quickSort(0, this.count - 1);
        this.insertionSort(0, this.count - 1);
        this.sorted = true;
    }

    private void quickSort(int l, int r) {
        int M = 16;
        if (r - l > M) {
            int i = r + l >>> 1;
            if (this.lessThan(i, l)) {
                this.swap(l, i);
            }
            if (this.lessThan(r, l)) {
                this.swap(l, r);
            }
            if (this.lessThan(r, i)) {
                this.swap(i, r);
            }
            int j = r - 1;
            this.swap(i, j);
            i = l;
            int v = j;
            while (true) {
                if (this.lessThan(++i, v)) {
                    continue;
                }
                while (this.lessThan(v, --j)) {
                }
                if (j < i) break;
                this.swap(i, j);
            }
            this.swap(i, r - 1);
            this.quickSort(l, j);
            this.quickSort(i + 1, r);
        }
    }

    private void insertionSort(int lo0, int hi0) {
        for (int i = lo0 + 1; i <= hi0; ++i) {
            int j;
            for (j = i; j > lo0 && this.lessThan(i, j - 1); --j) {
            }
            if (i == j) continue;
            this.moveAndInsertRow(i, j);
        }
    }

    private void moveAndInsertRow(int i, int j) {
        long col1 = this.keys[i];
        long col2 = this.values[i];
        this.moveRows(j, j + 1, i - j);
        this.keys[j] = col1;
        this.values[j] = col2;
    }

    private void swap(int i1, int i2) {
        long col1 = this.keys[i1];
        long col2 = this.values[i1];
        this.keys[i1] = this.keys[i2];
        this.values[i1] = this.values[i2];
        this.keys[i2] = col1;
        this.values[i2] = col2;
    }

    private int compare(int i) {
        if (this.targetSearchValue > this.keys[i]) {
            return 1;
        }
        if (this.targetSearchValue < this.keys[i]) {
            return -1;
        }
        return 0;
    }

    private boolean lessThan(int i, int j) {
        return this.keys[i] < this.keys[j];
    }

    private void moveRows(int fromIndex, int toIndex, int rows) {
        System.arraycopy(this.keys, fromIndex, this.keys, toIndex, rows);
        System.arraycopy(this.values, fromIndex, this.values, toIndex, rows);
    }

    private void doubleCapacity() {
        this.keys = (long[])ArrayUtil.resizeArray(this.keys, this.capacity * 2);
        this.values = (long[])ArrayUtil.resizeArray(this.values, this.capacity * 2);
        this.capacity *= 2;
    }

    public void copyTo(DoubleLongIndex other) {
        System.arraycopy(this.keys, 0, other.keys, 0, this.count);
        System.arraycopy(this.values, 0, other.values, 0, this.count);
        other.setSize(this.count);
    }

    @Override
    public boolean addUnsorted(LongLookup other) {
        if (!this.ensureCapacityToAdd(other.size())) {
            return false;
        }
        this.sorted = false;
        for (int i = 0; i < other.size(); ++i) {
            long key = other.getLongKey(i);
            long value = other.getLongValue(i);
            this.addUnsorted(key, value);
        }
        return true;
    }

    private boolean ensureCapacityToAdd(int extra) {
        if (this.count + extra > this.capacity) {
            while (this.count + extra > this.capacity) {
                this.doubleCapacity();
            }
        }
        return true;
    }
}

