/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.hsqldb.lib.EventLogInterface;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileAccessRes;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.java.JavaSystem;

public class FileUtil
implements FileAccess {
    private static FileUtil fileUtil = new FileUtil();
    private static FileAccessRes fileAccessRes = new FileAccessRes();
    public final boolean fsIsIgnoreCase = new File("A").equals(new File("a"));
    public final boolean fsNormalizesPosixSeparator = new File("/").getPath().endsWith(File.separator);
    final Random random = new Random(System.currentTimeMillis());
    static int discardSuffixLength = 9;

    FileUtil() {
    }

    public static FileUtil getFileUtil() {
        return fileUtil;
    }

    public static FileAccess getFileAccess(boolean isResource) {
        return isResource ? fileAccessRes : fileUtil;
    }

    @Override
    public boolean isStreamElement(String elementName) {
        return new File(elementName).exists();
    }

    @Override
    public InputStream openInputStreamElement(String streamName) throws IOException {
        try {
            return new FileInputStream(streamName);
        }
        catch (Throwable e) {
            throw JavaSystem.toIOException(e);
        }
    }

    @Override
    public void createParentDirs(String filename) {
        this.makeParentDirectories(new File(filename));
    }

    @Override
    public boolean removeElement(String filename) {
        if (this.isStreamElement(filename)) {
            return this.delete(filename);
        }
        return true;
    }

    @Override
    public boolean renameElement(String oldName, String newName) {
        return this.renameWithOverwrite(oldName, newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renameElementOrCopy(String oldName, String newName, EventLogInterface logger) {
        if (this.renameWithOverwrite(oldName, newName)) {
            return true;
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = this.openInputStreamElement(oldName);
            outputStream = this.openOutputStreamElement(newName);
            InOutUtil.copy(inputStream, outputStream);
            this.getFileSync(outputStream).sync();
        }
        catch (IOException e) {
            String message = String.format("Platform does not allow renaming files and failed to copy file contents from %s to %s", oldName, newName);
            logger.logSevereEvent(message, e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                logger.logWarningEvent("Failed to dispose streams", e);
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                logger.logDetailEvent("Failed to dispose streams");
            }
        }
        if (!this.delete(oldName)) {
            logger.logWarningEvent("Failed to delete renamed file " + oldName, null);
        }
        String message = String.format("Platform does not allow renaming files. Copied file from %s to %s instead", oldName, newName);
        logger.logDetailEvent(message);
        return true;
    }

    @Override
    public OutputStream openOutputStreamElement(String streamName) throws IOException {
        return new FileOutputStream(streamName, false);
    }

    @Override
    public OutputStream openOutputStreamElementAppend(String streamName) throws IOException {
        return new FileOutputStream(streamName, true);
    }

    public boolean delete(String filename) {
        return new File(filename).delete();
    }

    public void deleteOnExit(File f) {
        f.deleteOnExit();
    }

    public boolean exists(String filename) {
        return new File(filename).exists();
    }

    public boolean exists(String fileName, boolean resource, Class cla) {
        if (fileName == null || fileName.isEmpty()) {
            return false;
        }
        return resource ? null != cla.getResource(fileName) : FileUtil.getFileUtil().exists(fileName);
    }

    private boolean renameWithOverwrite(String oldname, String newname) {
        File file = new File(oldname);
        this.delete(newname);
        boolean renamed = file.renameTo(new File(newname));
        if (renamed) {
            return true;
        }
        this.delete(newname);
        if (this.exists(newname)) {
            new File(newname).renameTo(new File(FileUtil.newDiscardFileName(newname)));
        }
        return file.renameTo(new File(newname));
    }

    public String absolutePath(String path) {
        return new File(path).getAbsolutePath();
    }

    public File canonicalFile(File f) throws IOException {
        return new File(f.getCanonicalPath());
    }

    public File canonicalFile(String path) throws IOException {
        return new File(new File(path).getCanonicalPath());
    }

    public String canonicalPath(File f) throws IOException {
        return f.getCanonicalPath();
    }

    public String canonicalPath(String path) throws IOException {
        return new File(path).getCanonicalPath();
    }

    public String canonicalOrAbsolutePath(String path) {
        try {
            return this.canonicalPath(path);
        }
        catch (Exception e) {
            return this.absolutePath(path);
        }
    }

    public void makeParentDirectories(File f) {
        String parent = f.getParent();
        if (parent != null) {
            new File(parent).mkdirs();
        } else {
            parent = f.getPath();
            int index = parent.lastIndexOf(47);
            if (index > 0) {
                parent = parent.substring(0, index);
                new File(parent).mkdirs();
            }
        }
    }

    public static String makeDirectories(String path) {
        try {
            File file = new File(path);
            file.mkdirs();
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public FileAccess.FileSync getFileSync(OutputStream os) throws IOException {
        return new FileSync((FileOutputStream)os);
    }

    public static boolean deleteOrRenameDatabaseFiles(String dbNamePath) {
        int i;
        DatabaseFilenameFilter filter = new DatabaseFilenameFilter(dbNamePath);
        File[] fileList = filter.getExistingFileListInDirectory();
        for (int i2 = 0; i2 < fileList.length; ++i2) {
            fileList[i2].delete();
        }
        File tempDir = new File(filter.canonicalFile.getPath() + ".tmp");
        if (tempDir.isDirectory()) {
            File[] tempList = tempDir.listFiles();
            if (tempList != null) {
                for (int i3 = 0; i3 < tempList.length; ++i3) {
                    tempList[i3].delete();
                }
            }
            tempDir.delete();
        }
        if ((fileList = filter.getExistingMainFileSetList()).length == 0) {
            return true;
        }
        for (i = 0; i < fileList.length; ++i) {
            fileList[i].delete();
        }
        fileList = filter.getExistingMainFileSetList();
        for (i = 0; i < fileList.length; ++i) {
            fileList[i].renameTo(new File(FileUtil.newDiscardFileName(fileList[i].getPath())));
        }
        return true;
    }

    public static File[] getDatabaseFileList(String dbNamePath) {
        DatabaseFilenameFilter filter = new DatabaseFilenameFilter(dbNamePath);
        return filter.getExistingFileListInDirectory();
    }

    public static File[] getDatabaseMainFileList(String dbNamePath) {
        DatabaseFilenameFilter filter = new DatabaseFilenameFilter(dbNamePath, false);
        return filter.getExistingFileListInDirectory();
    }

    public static String newDiscardFileName(String filename) {
        String timestamp = StringUtil.toPaddedString(Integer.toHexString((int)System.currentTimeMillis()), discardSuffixLength - 1, '0', true);
        String discardName = filename + "." + timestamp + ".old";
        return discardName;
    }

    static class DatabaseFilenameFilter
    implements FilenameFilter {
        String[] suffixes = new String[]{".backup", ".properties", ".script", ".data", ".log", ".lobs"};
        String[] extraSuffixes = new String[]{".lck", ".sql.log", ".app.log"};
        private String dbName;
        private File parent;
        private File canonicalFile;
        private boolean extraFiles;

        DatabaseFilenameFilter(String dbNamePath) {
            this(dbNamePath, true);
        }

        DatabaseFilenameFilter(String dbNamePath, boolean extras) {
            this.canonicalFile = new File(dbNamePath);
            try {
                this.canonicalFile = this.canonicalFile.getCanonicalFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dbName = this.canonicalFile.getName();
            this.parent = this.canonicalFile.getParentFile();
            this.extraFiles = extras;
        }

        public File[] getCompleteMainFileSetList() {
            File[] fileList = new File[this.suffixes.length];
            for (int i = 0; i < this.suffixes.length; ++i) {
                fileList[i] = new File(this.canonicalFile.getPath() + this.suffixes[i]);
            }
            return fileList;
        }

        public File[] getExistingMainFileSetList() {
            File[] fileList = this.getCompleteMainFileSetList();
            HsqlArrayList<File> list = new HsqlArrayList<File>();
            for (int i = 0; i < fileList.length; ++i) {
                if (!fileList[i].exists()) continue;
                list.add(fileList[i]);
            }
            fileList = new File[list.size()];
            list.toArray(fileList);
            return fileList;
        }

        public File[] getExistingFileListInDirectory() {
            File[] list = this.parent.listFiles(this);
            return list == null ? new File[]{} : list;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (this.parent.equals(dir) && name.indexOf(this.dbName) == 0) {
                int i;
                String suffix = name.substring(this.dbName.length());
                if (this.extraFiles) {
                    for (i = 0; i < this.extraSuffixes.length; ++i) {
                        if (!suffix.equals(this.extraSuffixes[i])) continue;
                        return true;
                    }
                }
                for (i = 0; i < this.suffixes.length; ++i) {
                    if (suffix.equals(this.suffixes[i])) {
                        return true;
                    }
                    if (!this.extraFiles || !suffix.startsWith(this.suffixes[i]) || !(name.endsWith(".new") ? suffix.length() == this.suffixes[i].length() + 4 : name.endsWith(".old") && suffix.length() == this.suffixes[i].length() + discardSuffixLength + 4)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class FileSync
    implements FileAccess.FileSync {
        FileDescriptor outDescriptor;

        FileSync(FileOutputStream os) throws IOException {
            this.outDescriptor = os.getFD();
        }

        @Override
        public void sync() throws IOException {
            this.outDescriptor.sync();
        }
    }
}

