/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class HashMap<K, V>
extends BaseHashMap
implements Map<K, V> {
    private Set<K> keySet;
    private Collection<V> values;
    private Set<Map.Entry<K, V>> entries;

    public HashMap() {
        this(8);
    }

    public HashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 3, 3, false);
    }

    public HashMap(int initialCapacity, ObjectComparator comparator) throws IllegalArgumentException {
        this(initialCapacity);
        this.comparator = comparator;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        int hash = this.comparator.hashCode(key);
        int lookup = this.getLookup(key, hash);
        if (lookup != -1) {
            return (V)this.objectValueTable[lookup];
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        return (V)super.addOrUpdate(0L, 0L, key, value);
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return (V)super.remove(0L, 0L, key, null, false, false);
    }

    public boolean remove(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        Object result = super.remove(0L, 0L, key, value, true, false);
        return result != null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (key == null) continue;
            this.put(key, m.get(key));
        }
    }

    public <T> T[] keysToArray(T[] array) {
        return this.toArray(array, true);
    }

    public <T> T[] valuesToArray(T[] array) {
        return this.toArray(array, false);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<V>
    extends AbstractReadOnlyCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            HashMap hashMap = HashMap.this;
            hashMap.getClass();
            return new BaseHashMap.BaseHashIterator(hashMap, false);
        }

        @Override
        public int size() {
            return HashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            return HashMap.this.toArray(false);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return HashMap.this.toArray(array, false);
        }
    }

    private class KeySet<K>
    extends AbstractReadOnlyCollection<K>
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            HashMap hashMap = HashMap.this;
            hashMap.getClass();
            return new BaseHashMap.BaseHashIterator(hashMap, true);
        }

        @Override
        public int size() {
            return HashMap.this.size();
        }

        @Override
        public boolean contains(Object key) {
            return HashMap.this.containsKey(key);
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            return HashMap.this.toArray(true);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return HashMap.this.toArray(array, true);
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(HashMap.this, true);
        }

        @Override
        public Map.Entry<K, V> next() {
            Object key = super.next();
            Object value = HashMap.this.objectValueTable[this.lookup];
            return new MapEntry<Object, Object>(key, value);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return HashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

