/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class HashSet<E>
extends BaseHashMap
implements Set<E> {
    public HashSet() {
        this(8);
    }

    public HashSet(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 3, 0, false);
    }

    public HashSet(int initialCapacity, ObjectComparator comparator) throws IllegalArgumentException {
        this(initialCapacity);
        this.comparator = comparator;
    }

    public HashSet(Object[] valueList) {
        this(valueList.length);
        for (int i = 0; i < valueList.length; ++i) {
            this.add(valueList[i]);
        }
    }

    @Override
    public boolean contains(Object key) {
        return super.containsKey(key);
    }

    public boolean containsAll(Collection<?> col) {
        Iterator<?> it = col.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public E getOrAdd(E key) {
        if (key == null) {
            throw new NullPointerException();
        }
        E value = this.get(key);
        if (value == null) {
            value = key;
            this.add(key);
        }
        return value;
    }

    public E get(E key) {
        if (key == null) {
            throw new NullPointerException();
        }
        int lookup = this.getLookup(key);
        if (lookup < 0) {
            return null;
        }
        return (E)this.objectKeyTable[lookup];
    }

    @Override
    public boolean add(E key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return (Boolean)super.addOrUpdate(0L, 0L, key, null);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        Iterator<E> it = c.iterator();
        while (it.hasNext()) {
            changed |= this.add(it.next());
        }
        return changed;
    }

    public boolean addAll(E[] keys) {
        boolean changed = false;
        for (int i = 0; i < keys.length; ++i) {
            changed |= this.add(keys[i]);
        }
        return changed;
    }

    public boolean addAll(E[] keys, int start, int limit) {
        boolean changed = false;
        for (int i = start; i < keys.length && i < limit; ++i) {
            changed |= this.add(keys[i]);
        }
        return changed;
    }

    @Override
    public boolean remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return (Boolean)super.remove(0L, 0L, key, null, false, false);
    }

    public boolean removeAll(Collection<?> c) {
        Iterator<?> it = c.iterator();
        boolean result = true;
        while (it.hasNext()) {
            result &= this.remove(it.next());
        }
        return result;
    }

    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    public boolean removeAll(E[] keys) {
        boolean result = true;
        for (int i = 0; i < keys.length; ++i) {
            result &= this.remove(keys[i]);
        }
        return result;
    }

    public int getCommonElementCount(Set<E> other) {
        int count = 0;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (!other.contains(it.next())) continue;
            ++count;
        }
        return count;
    }

    public <T> T[] toArray(T[] a) {
        return this.toArray(a, true);
    }

    public Object[] toArray() {
        return this.toArray(true);
    }

    @Override
    public Iterator<E> iterator() {
        return new BaseHashMap.BaseHashIterator(this, true);
    }

    public String toString() {
        Iterator<E> it = this.iterator();
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(", ");
            } else {
                sb.append('[');
            }
            sb.append(it.next());
        }
        return sb.toString() + ']';
    }
}

