/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.BaseList;
import org.hsqldb.lib.List;

public class HsqlArrayList<E>
extends BaseList<E>
implements List<E> {
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final float DEFAULT_RESIZE_FACTOR = 2.0f;
    E[] elementData;
    E[] reserveElementData;
    private boolean minimizeOnClear;

    public HsqlArrayList(E[] data, int count) {
        this.elementData = data;
        this.elementCount = count;
    }

    public HsqlArrayList() {
        this.elementData = new Object[8];
    }

    public HsqlArrayList(int initialCapacity, boolean minimize) {
        if (initialCapacity < 8) {
            initialCapacity = 8;
        }
        this.elementData = new Object[initialCapacity];
        this.minimizeOnClear = minimize;
    }

    public HsqlArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new NegativeArraySizeException("Invalid initial capacity given");
        }
        if (initialCapacity < 8) {
            initialCapacity = 8;
        }
        this.elementData = new Object[initialCapacity];
    }

    @Override
    public void add(int index, E element) {
        if (index > this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + ">" + this.elementCount);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " < 0");
        }
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        if (index < this.elementCount) {
            System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        }
        this.elementData[index] = element;
        ++this.elementCount;
    }

    @Override
    public boolean add(E element) {
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        this.elementData[this.elementCount] = element;
        ++this.elementCount;
        return true;
    }

    @Override
    public E get(int index) {
        if (index >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " >= " + this.elementCount);
        }
        return this.elementData[index];
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            if (!this.comparator.equals(o, this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public E remove(int index) {
        if (index >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " >= " + this.elementCount);
        }
        E removedObj = this.elementData[index];
        if (index < this.elementCount - 1) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, this.elementCount - 1 - index);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
        if (this.elementCount == 0) {
            this.clear();
        }
        return removedObj;
    }

    @Override
    public E set(int index, E element) {
        if (index >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " >= " + this.elementCount);
        }
        E replacedObj = this.elementData[index];
        this.elementData[index] = element;
        return replacedObj;
    }

    @Override
    public final int size() {
        return this.elementCount;
    }

    private void increaseCapacity() {
        int baseSize = this.elementData.length == 0 ? 1 : this.elementData.length;
        baseSize = (int)((float)baseSize * 2.0f);
        this.resize(baseSize);
    }

    private void resize(int baseSize) {
        if (baseSize == this.elementData.length) {
            return;
        }
        Object[] newArray = (Object[])Array.newInstance(this.elementData.getClass().getComponentType(), baseSize);
        int count = this.elementData.length > newArray.length ? newArray.length : this.elementData.length;
        System.arraycopy(this.elementData, 0, newArray, 0, count);
        if (this.minimizeOnClear && this.reserveElementData == null) {
            Arrays.fill(this.elementData, (Object)0);
            this.reserveElementData = this.elementData;
        }
        this.elementData = newArray;
    }

    public void trim() {
        this.resize(this.elementCount);
    }

    @Override
    public void clear() {
        if (this.minimizeOnClear && this.reserveElementData != null) {
            this.elementData = this.reserveElementData;
            this.reserveElementData = null;
            this.elementCount = 0;
            return;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public void setSize(int newSize) {
        if (newSize == 0) {
            this.clear();
            return;
        }
        if (newSize <= this.elementCount) {
            for (int i = newSize; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
            this.elementCount = newSize;
            return;
        }
        while (newSize > this.elementData.length) {
            this.increaseCapacity();
        }
        this.elementCount = newSize;
    }

    public Object[] toArray() {
        Object[] newArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, newArray, 0, this.elementCount);
        return newArray;
    }

    public <T> T[] toArray(T[] array) {
        if (array.length < this.elementCount) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.elementCount);
        }
        System.arraycopy(this.elementData, 0, array, 0, this.elementCount);
        return array;
    }

    public void toArraySlice(E[] array, int start, int limit) {
        System.arraycopy(this.elementData, start, array, 0, limit - start);
    }

    public E[] getArray() {
        return this.elementData;
    }

    public void sort(Comparator<? super E> c) {
        if (this.elementCount < 2) {
            return;
        }
        ArraySort.sort(this.elementData, this.elementCount, c);
    }

    public int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.elementCount - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = this.elementCount - 1; i >= 0; --i) {
            if (!this.comparator.equals(o, this.elementData[i])) continue;
            return i;
        }
        return -1;
    }
}

