/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.hsqldb.lib.BaseList;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.List;

public class HsqlDeque<E>
extends BaseList<E>
implements List<E> {
    private E[] list = new Object[16];
    private int firstindex = 0;
    private int endindex = 0;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public boolean offer(E e) {
        return this.add(e);
    }

    public E remove() {
        return this.removeFirst();
    }

    public E poll() {
        if (this.elementCount == 0) {
            return null;
        }
        return this.removeFirst();
    }

    public E element() {
        return this.getFirst();
    }

    public E peek() {
        if (this.elementCount == 0) {
            return null;
        }
        return this.getFirst();
    }

    public void push(E e) {
        this.addFirst(e);
    }

    public E pop() {
        return this.removeFirst();
    }

    public E getFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.firstindex];
    }

    public E getLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.endindex - 1];
    }

    @Override
    public E get(int i) throws IndexOutOfBoundsException {
        int index = this.getInternalIndex(i);
        return this.list[index];
    }

    @Override
    public void add(int i, E o) throws IndexOutOfBoundsException {
        if (i == this.elementCount) {
            this.add(o);
            return;
        }
        this.resetCapacity();
        int index = this.getInternalIndex(i);
        if (index < this.endindex && this.endindex < this.list.length) {
            System.arraycopy(this.list, index, this.list, index + 1, this.endindex - index);
            ++this.endindex;
        } else {
            System.arraycopy(this.list, this.firstindex, this.list, this.firstindex - 1, index - this.firstindex);
            --this.firstindex;
            --index;
        }
        this.list[index] = o;
        ++this.elementCount;
    }

    @Override
    public E set(int i, E o) throws IndexOutOfBoundsException {
        int index = this.getInternalIndex(i);
        E result = this.list[index];
        this.list[index] = o;
        return result;
    }

    public E removeFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        E o = this.list[this.firstindex];
        this.list[this.firstindex] = null;
        ++this.firstindex;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.firstindex == this.list.length) {
            this.firstindex = 0;
        }
        return o;
    }

    public E removeLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        --this.endindex;
        E o = this.list[this.endindex];
        this.list[this.endindex] = null;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.endindex == 0) {
            this.endindex = this.list.length;
        }
        return o;
    }

    public E peekFirst() {
        return this.getFirst();
    }

    public E peekLast() {
        return this.getLast();
    }

    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    public E pollFirst() {
        if (this.elementCount == 0) {
            return null;
        }
        return this.removeFirst();
    }

    public E pollLast() {
        if (this.elementCount == 0) {
            return null;
        }
        return this.removeLast();
    }

    public boolean removeFirstOccurrence(Object o) {
        int index = this.indexOf(o);
        if (index < 1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public boolean removeLastOccurrence(Object o) {
        int index = this.lastIndexOf(o);
        if (index < 1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public Iterator<E> descendingIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E o) {
        this.resetCapacity();
        if (this.endindex == this.list.length) {
            this.endindex = 0;
        }
        this.list[this.endindex] = o;
        ++this.elementCount;
        ++this.endindex;
        return true;
    }

    public void addLast(E o) {
        this.add(o);
    }

    public void addFirst(E o) {
        this.resetCapacity();
        --this.firstindex;
        if (this.firstindex < 0) {
            this.firstindex = this.list.length - 1;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        this.list[this.firstindex] = o;
        ++this.elementCount;
    }

    @Override
    public void clear() {
        if (this.elementCount == 0) {
            return;
        }
        this.elementCount = 0;
        this.endindex = 0;
        this.firstindex = 0;
        Arrays.fill(this.list, null);
    }

    @Override
    public int indexOf(Object value) {
        for (int i = 0; i < this.elementCount; ++i) {
            int index = this.firstindex + i;
            if (index >= this.list.length) {
                index -= this.list.length;
            }
            if (this.list[index] == value) {
                return i;
            }
            if (value == null || !this.comparator.equals(value, this.list[index])) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object value) {
        for (int i = this.elementCount - 1; i >= 0; --i) {
            int index = this.firstindex + i;
            if (index < 0) {
                index += this.list.length;
            }
            if (this.list[index] == value) {
                return i;
            }
            if (value == null || !this.comparator.equals(value, this.list[index])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public E remove(int index) {
        int target = this.getInternalIndex(index);
        E value = this.list[target];
        if (target == this.firstindex) {
            this.list[this.firstindex] = null;
            ++this.firstindex;
            if (this.firstindex == this.list.length) {
                this.firstindex = 0;
            }
        } else if (target > this.firstindex) {
            System.arraycopy(this.list, this.firstindex, this.list, this.firstindex + 1, target - this.firstindex);
            this.list[this.firstindex] = null;
            ++this.firstindex;
            if (this.firstindex == this.list.length) {
                this.firstindex = 0;
            }
        } else {
            System.arraycopy(this.list, target + 1, this.list, target, this.endindex - target - 1);
            --this.endindex;
            this.list[this.endindex] = null;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        }
        return value;
    }

    private int getInternalIndex(int i) throws IndexOutOfBoundsException {
        if (i < 0 || i >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        int index = this.firstindex + i;
        if (index >= this.list.length) {
            index -= this.list.length;
        }
        return index;
    }

    private void resetCapacity() {
        if (this.elementCount < this.list.length) {
            return;
        }
        Object[] newList = new Object[this.list.length * 2];
        System.arraycopy(this.list, this.firstindex, newList, this.firstindex, this.list.length - this.firstindex);
        if (this.endindex <= this.firstindex) {
            System.arraycopy(this.list, 0, newList, this.list.length, this.endindex);
            this.endindex = this.list.length + this.endindex;
        }
        this.list = newList;
    }

    public <T> T[] toArray(T[] array) {
        int tempCount;
        if (array.length < this.elementCount) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.elementCount);
        }
        if ((tempCount = this.list.length - this.firstindex) > this.elementCount) {
            tempCount = this.elementCount;
        }
        System.arraycopy(this.list, this.firstindex, array, 0, tempCount);
        if (this.endindex <= this.firstindex) {
            System.arraycopy(this.list, 0, array, tempCount, this.endindex);
        }
        return array;
    }

    public Object[] toArray() {
        Object[] newArray = new Object[this.elementCount];
        return this.toArray(newArray);
    }

    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }
}

