/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.map.BaseHashMap;

public class IntHashSet
extends BaseHashMap {
    public IntHashSet() {
        this(8);
    }

    public IntHashSet(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 1, 0, false);
    }

    public IntHashSet(int[] elements) {
        super(elements.length, 1, 0, false);
        this.addAll(elements);
    }

    public IntHashSet(int[] elementsA, int[] elementsB) {
        super(elementsA.length + elementsB.length, 1, 0, false);
        this.addAll(elementsA);
        this.addAll(elementsB);
    }

    public boolean contains(Object o) {
        if (o instanceof Integer) {
            int intKey = (Integer)o;
            return this.containsKey(intKey);
        }
        if (o == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public boolean contains(int key) {
        return super.containsKey(key);
    }

    public boolean add(Integer e) {
        if (e == null) {
            throw new NullPointerException();
        }
        int intKey = e;
        return this.add(intKey);
    }

    public boolean add(int key) {
        return (Boolean)super.addOrUpdate(key, 0L, null, null);
    }

    public boolean remove(Object o) {
        if (o instanceof Integer) {
            int intKey = (Integer)o;
            return this.remove(intKey);
        }
        if (o == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public boolean remove(int key) {
        return (Boolean)super.remove(key, 0L, null, null, false, false);
    }

    public int getStartMatchCount(int[] array) {
        int i;
        for (i = 0; i < array.length && super.containsKey(array[i]); ++i) {
        }
        return i;
    }

    public boolean addAll(Collection<? extends Integer> col) {
        int oldSize = this.size();
        Iterator<? extends Integer> it = col.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return oldSize != this.size();
    }

    public boolean addAll(IntHashSet s) {
        boolean result = false;
        PrimitiveIterator<Integer> it = s.iterator();
        while (it.hasNext()) {
            result |= this.add(it.nextInt());
        }
        return result;
    }

    public boolean addAll(int[] elements) {
        int oldSize = this.size();
        for (int i = 0; i < elements.length; ++i) {
            this.add(elements[i]);
        }
        return oldSize != this.size();
    }

    public boolean containsAll(Collection<?> c) {
        Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(Collection<?> c) {
        int oldSize = this.size();
        BaseHashMap.BaseHashIterator it = new BaseHashMap.BaseHashIterator(this, true);
        while (it.hasNext()) {
            if (c.contains(it.nextInt())) continue;
            it.remove();
        }
        return oldSize != this.size();
    }

    public boolean removeAll(Collection<?> c) {
        int oldSize = this.size();
        Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Integer)) continue;
            this.remove(o);
        }
        return oldSize != this.size();
    }

    public int[] toArray() {
        int[] array = new int[this.size()];
        return this.toIntArray(array, true);
    }

    public int[] toArray(int[] array) {
        return this.toIntArray(array, true);
    }

    public PrimitiveIterator<Integer> iterator() {
        return new BaseHashMap.BaseHashIterator(this, true);
    }
}

