/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class IntKeyHashMap<V>
extends BaseHashMap
implements Map<Integer, V> {
    private Set<Integer> keySet;
    private Collection<V> values;
    private Set<Map.Entry<Integer, V>> entries;

    public IntKeyHashMap() {
        this(8);
    }

    public IntKeyHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 1, 3, false);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Integer) {
            int intKey = (Integer)key;
            return this.containsKey(intKey);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsKey(int key) {
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    @Override
    public V get(Object key) {
        if (key instanceof Integer) {
            int intKey = (Integer)key;
            return this.get(intKey);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public V get(int key) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return (V)this.objectValueTable[lookup];
        }
        return null;
    }

    @Override
    public V put(Integer key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        int intKey = key;
        return this.put(intKey, value);
    }

    @Override
    public V put(int key, V value) {
        return (V)super.addOrUpdate(key, 0L, null, value);
    }

    @Override
    public V remove(Object key) {
        if (key instanceof Integer) {
            int intKey = (Integer)key;
            return this.remove(intKey);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public V remove(int key) {
        return (V)super.remove(key, 0L, null, null, false, false);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> other) {
        Iterator it = other.keySet().iterator();
        while (it.hasNext()) {
            Integer key = (Integer)it.next();
            if (key == null) continue;
            int intKey = key;
            this.put(intKey, other.get(key));
        }
    }

    public void putAll(IntKeyHashMap other) {
        PrimitiveIterator it = (PrimitiveIterator)other.keySet().iterator();
        while (it.hasNext()) {
            int key = it.nextInt();
            this.put(key, other.get(key));
        }
    }

    public int[] keysToArray(int[] array) {
        return this.toIntArray(array, true);
    }

    public Object[] valuesToArray() {
        return this.toArray(false);
    }

    public <T> T[] valuesToArray(T[] array) {
        return this.toArray(array, false);
    }

    @Override
    public Set<Integer> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet<Integer>();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<V>
    extends AbstractReadOnlyCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            IntKeyHashMap intKeyHashMap = IntKeyHashMap.this;
            intKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(intKeyHashMap, false);
        }

        @Override
        public int size() {
            return IntKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            return IntKeyHashMap.this.toArray(false);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return IntKeyHashMap.this.toArray(array, false);
        }
    }

    private class KeySet<Integer>
    extends AbstractReadOnlyCollection<Integer>
    implements Set<Integer> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Integer> iterator() {
            IntKeyHashMap intKeyHashMap = IntKeyHashMap.this;
            intKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(intKeyHashMap, true);
        }

        @Override
        public int size() {
            return IntKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(IntKeyHashMap.this, true);
        }

        @Override
        public Map.Entry<Integer, V> next() {
            Integer key = super.nextInt();
            Object value = IntKeyHashMap.this.objectValueTable[this.lookup];
            return new MapEntry<Integer, Object>(key, value);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Integer, V>>
    implements Set<Map.Entry<Integer, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return IntKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

