/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class IntKeyHashMapConcurrent<V>
extends BaseHashMap
implements Map<Integer, V> {
    private Set<Integer> keySet;
    private Collection<V> values;
    private Set<Map.Entry<Integer, V>> entries;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

    public IntKeyHashMapConcurrent() {
        this(8);
    }

    public IntKeyHashMapConcurrent(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 1, 3, false);
    }

    public Lock getWriteLock() {
        return this.writeLock;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Integer) {
            int intKey = (Integer)key;
            return super.containsKey(intKey);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsKey(int key) {
        try {
            this.readLock.lock();
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            this.readLock.lock();
            boolean bl = super.containsValue(value);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V get(Object key) {
        if (key instanceof Integer) {
            int intKey = (Integer)key;
            return this.get(intKey);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(int key) {
        try {
            this.readLock.lock();
            int lookup = this.getLookup(key);
            if (lookup != -1) {
                Object object = this.objectValueTable[lookup];
                return (V)object;
            }
            V v = null;
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V put(Integer key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        int intKey = key;
        return this.put(intKey, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(int key, V value) {
        try {
            this.writeLock.lock();
            Object object = super.addOrUpdate(key, 0L, null, value);
            return (V)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public V remove(Object key) {
        if (key instanceof Integer) {
            int intKey = (Integer)key;
            return this.remove(intKey);
        }
        return null;
    }

    public V remove(int key) {
        try {
            this.writeLock.lock();
            Object object = super.remove(key, 0L, null, null, false, false);
            return (V)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends Integer, ? extends V> other) {
        try {
            this.writeLock.lock();
            Iterator it = other.keySet().iterator();
            while (it.hasNext()) {
                Integer key = (Integer)it.next();
                int intKey = key;
                this.put(intKey, other.get(key));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(IntKeyHashMap other) {
        try {
            this.writeLock.lock();
            PrimitiveIterator it = (PrimitiveIterator)other.keySet().iterator();
            while (it.hasNext()) {
                int intKey = it.nextInt();
                this.put(intKey, (V)other.get(intKey));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrderedKeyMatchCount(int[] array) {
        try {
            int i;
            this.readLock.lock();
            for (i = 0; i < array.length && super.containsKey(array[i]); ++i) {
            }
            int n = i;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int[] keysToArray(int[] array) {
        try {
            this.readLock.lock();
            int[] nArray = this.toIntArray(array, true);
            return nArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public <T> T[] valuesToArray(T[] array) {
        try {
            this.readLock.lock();
            T[] TArray = this.toArray(array, false);
            return TArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<Integer> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet<Integer>();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<V>
    extends AbstractReadOnlyCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            IntKeyHashMapConcurrent intKeyHashMapConcurrent = IntKeyHashMapConcurrent.this;
            intKeyHashMapConcurrent.getClass();
            return new BaseHashMap.BaseHashIterator(intKeyHashMapConcurrent, false);
        }

        @Override
        public int size() {
            return IntKeyHashMapConcurrent.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[this.size()];
            return IntKeyHashMapConcurrent.this.valuesToArray(array);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return IntKeyHashMapConcurrent.this.valuesToArray(a);
        }
    }

    private class KeySet<Integer>
    extends AbstractReadOnlyCollection<Integer>
    implements Set<Integer> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Integer> iterator() {
            IntKeyHashMapConcurrent intKeyHashMapConcurrent = IntKeyHashMapConcurrent.this;
            intKeyHashMapConcurrent.getClass();
            return new BaseHashMap.BaseHashIterator(intKeyHashMapConcurrent, true);
        }

        @Override
        public int size() {
            return IntKeyHashMapConcurrent.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(IntKeyHashMapConcurrent.this, true);
        }

        @Override
        public Map.Entry<Integer, V> next() {
            Integer key = super.nextInt();
            Object value = IntKeyHashMapConcurrent.this.objectValueTable[this.lookup];
            return new MapEntry<Integer, Object>(key, value);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Integer, V>>
    implements Set<Map.Entry<Integer, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return IntKeyHashMapConcurrent.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

