/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class IntKeyIntValueHashMap
extends BaseHashMap
implements Map<Integer, Integer> {
    private Set<Integer> keySet;
    private Collection<Integer> values;
    private Set<Map.Entry<Integer, Integer>> entries;

    public IntKeyIntValueHashMap() {
        this(8);
    }

    public IntKeyIntValueHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 1, 1, false);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Integer) {
            int intKey = (Integer)key;
            return super.containsKey(intKey);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsKey(int key) {
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            return super.containsValue(intValue);
        }
        if (value == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsValue(int value) {
        return super.containsValue(value);
    }

    @Override
    public Integer get(Object key) {
        if (key instanceof Integer) {
            int intKey = (Integer)key;
            try {
                int intVal = this.get(intKey);
                return intVal;
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public int get(int key) throws NoSuchElementException {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.intValueTable[lookup];
        }
        throw new NoSuchElementException();
    }

    public int get(int key, int defaultValue) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.intValueTable[lookup];
        }
        return defaultValue;
    }

    public boolean get(int key, int[] value) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            value[0] = this.intValueTable[lookup];
            return true;
        }
        return false;
    }

    @Override
    public Integer put(Integer key, Integer value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        int oldSize = this.size();
        super.addOrUpdate(key.intValue(), value.intValue(), null, null);
        if (oldSize == this.size()) {
            return null;
        }
        return value;
    }

    @Override
    public boolean put(int key, int value) {
        int oldSize = this.size();
        super.addOrUpdate(key, value, null, null);
        return oldSize != this.size();
    }

    @Override
    public Integer remove(Object key) {
        if (key instanceof Integer) {
            int intKey = (Integer)key;
            return (Integer)super.remove(intKey, 0L, null, null, false, false);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public boolean remove(int key) {
        Integer value = (Integer)super.remove(key, 0L, null, null, false, false);
        return value != null;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Integer> other) {
        Iterator it = other.keySet().iterator();
        while (it.hasNext()) {
            Integer key = (Integer)it.next();
            int intKey = key;
            Integer value = other.get(key);
            int intValue = value;
            this.put(intKey, intValue);
        }
    }

    public void putAll(IntKeyIntValueHashMap other) {
        PrimitiveIterator it = (PrimitiveIterator)other.keySet().iterator();
        while (it.hasNext()) {
            int key = it.nextInt();
            int value = other.get(key);
            this.put(key, value);
        }
    }

    public int[] keysToArray(int[] array) {
        return this.toIntArray(array, true);
    }

    public int[] valuesToArray(int[] array) {
        return this.toIntArray(array, false);
    }

    @Override
    public Set<Integer> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet<Integer>();
        }
        return this.keySet;
    }

    @Override
    public Collection<Integer> values() {
        if (this.values == null) {
            this.values = new Values<Integer>();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Integer, Integer>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<Integer>
    extends AbstractReadOnlyCollection<Integer> {
        private Values() {
        }

        @Override
        public PrimitiveIterator<Integer> iterator() {
            IntKeyIntValueHashMap intKeyIntValueHashMap = IntKeyIntValueHashMap.this;
            intKeyIntValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(intKeyIntValueHashMap, false);
        }

        @Override
        public int size() {
            return IntKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet<Integer>
    extends AbstractReadOnlyCollection<Integer>
    implements Set<Integer> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Integer> iterator() {
            IntKeyIntValueHashMap intKeyIntValueHashMap = IntKeyIntValueHashMap.this;
            intKeyIntValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(intKeyIntValueHashMap, true);
        }

        @Override
        public int size() {
            return IntKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(IntKeyIntValueHashMap.this, true);
        }

        @Override
        public Map.Entry<Integer, Integer> next() {
            Integer key = super.nextInt();
            Integer value = IntKeyIntValueHashMap.this.intValueTable[this.lookup];
            return new MapEntry<Integer, Integer>(key, value);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Integer, Integer>>
    implements Set<Map.Entry<Integer, Integer>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, Integer>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return IntKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

