/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class IntKeyLongValueHashMap
extends BaseHashMap
implements Map<Integer, Long> {
    private Set<Integer> keySet;
    private Collection<Long> values;
    private Set<Map.Entry<Integer, Long>> entries;

    public IntKeyLongValueHashMap() {
        this(8);
    }

    public IntKeyLongValueHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 1, 2, false);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Integer) {
            int intKey = (Integer)key;
            return super.containsKey(intKey);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsKey(int key) {
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Long) {
            long longValue = (Long)value;
            return super.containsValue(longValue);
        }
        if (value == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsValue(int value) {
        return super.containsValue(value);
    }

    @Override
    public Long get(Object key) {
        if (key instanceof Integer) {
            int intKey = (Integer)key;
            try {
                long longVal = this.get(intKey);
                return longVal;
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public long get(int key) throws NoSuchElementException {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.longValueTable[lookup];
        }
        throw new NoSuchElementException();
    }

    public long get(int key, long defaultValue) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.longValueTable[lookup];
        }
        return defaultValue;
    }

    public boolean get(int key, long[] value) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            value[0] = this.longValueTable[lookup];
            return true;
        }
        return false;
    }

    @Override
    public Long put(Integer key, Long value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        int oldSize = this.size();
        super.addOrUpdate(key.intValue(), value, null, null);
        if (oldSize == this.size()) {
            return null;
        }
        return value;
    }

    @Override
    public boolean put(int key, long value) {
        int oldSize = this.size();
        super.addOrUpdate(key, value, null, null);
        return oldSize != this.size();
    }

    @Override
    public Long remove(Object key) {
        if (key instanceof Integer) {
            int intKey = (Integer)key;
            return (Long)super.remove(intKey, 0L, null, null, false, false);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public boolean remove(int key) {
        Long value = (Long)super.remove(key, 0L, null, null, false, false);
        return value != null;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Long> other) {
        Iterator it = other.keySet().iterator();
        while (it.hasNext()) {
            Integer key = (Integer)it.next();
            int intKey = key;
            Long value = other.get(key);
            long longValue = value;
            this.put(intKey, longValue);
        }
    }

    public void putAll(IntKeyIntValueHashMap other) {
        PrimitiveIterator it = (PrimitiveIterator)other.keySet().iterator();
        while (it.hasNext()) {
            int intKey = it.nextInt();
            int intValue = other.get(intKey);
            this.put(intKey, intValue);
        }
    }

    public int[] keysToArray(int[] array) {
        return this.toIntArray(array, true);
    }

    public long[] valuesToArray(long[] array) {
        return this.toLongArray(array, false);
    }

    @Override
    public Set<Integer> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<Long> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Integer, Long>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values
    extends AbstractReadOnlyCollection<Long> {
        private Values() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            IntKeyLongValueHashMap intKeyLongValueHashMap = IntKeyLongValueHashMap.this;
            intKeyLongValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(intKeyLongValueHashMap, false);
        }

        @Override
        public int size() {
            return IntKeyLongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet
    extends AbstractReadOnlyCollection<Integer>
    implements Set<Integer> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Integer> iterator() {
            IntKeyLongValueHashMap intKeyLongValueHashMap = IntKeyLongValueHashMap.this;
            intKeyLongValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(intKeyLongValueHashMap, true);
        }

        @Override
        public int size() {
            return IntKeyLongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(IntKeyLongValueHashMap.this, true);
        }

        @Override
        public Map.Entry<Integer, Long> next() {
            Integer key = super.nextInt();
            Long value = IntKeyLongValueHashMap.this.longValueTable[this.lookup];
            return new MapEntry<Integer, Long>(key, value);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Integer, Long>>
    implements Set<Map.Entry<Integer, Long>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, Long>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return IntKeyLongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

