/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class IntValueHashMap<K>
extends BaseHashMap {
    private Set<K> keySet;
    private Collection<Integer> values;
    private Set<Map.Entry<K, Integer>> entries;

    public IntValueHashMap() {
        this(8);
    }

    public IntValueHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 3, 1, false);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            return super.containsValue(intValue);
        }
        if (value == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsValue(int value) {
        return super.containsValue(value);
    }

    public int get(Object key) throws NoSuchElementException {
        if (key == null) {
            throw new NullPointerException();
        }
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.intValueTable[lookup];
        }
        throw new NoSuchElementException();
    }

    public int get(Object key, int defaultValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.intValueTable[lookup];
        }
        return defaultValue;
    }

    public boolean get(Object key, int[] value) {
        if (key == null) {
            throw new NullPointerException();
        }
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            value[0] = this.intValueTable[lookup];
            return true;
        }
        return false;
    }

    public Object getKey(int value) {
        BaseHashMap.BaseHashIterator it = new BaseHashMap.BaseHashIterator(this, false);
        while (it.hasNext()) {
            int i = it.nextInt();
            if (i != value) continue;
            return this.objectKeyTable[it.getLookup()];
        }
        return null;
    }

    public boolean put(Object key, int value) {
        if (key == null) {
            throw new NullPointerException();
        }
        int oldSize = this.size();
        super.addOrUpdate(0L, value, key, null);
        return oldSize != this.size();
    }

    public boolean remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        int oldSize = this.size();
        super.remove(0L, 0L, key, null, false, false);
        return oldSize != this.size();
    }

    public void putAll(Map<? extends K, ? extends Integer> other) {
        Iterator it = other.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Integer value = other.get(key);
            int intValue = value;
            this.put(key, intValue);
        }
    }

    public void putAll(IntValueHashMap other) {
        Iterator it = other.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            this.put(key, other.get(key));
        }
    }

    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection<Integer> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    public Set<Map.Entry<K, Integer>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    class Values
    extends AbstractReadOnlyCollection<Integer> {
        Values() {
        }

        @Override
        public Iterator<Integer> iterator() {
            IntValueHashMap intValueHashMap = IntValueHashMap.this;
            intValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(intValueHashMap, false);
        }

        @Override
        public int size() {
            return IntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    class KeySet
    extends AbstractReadOnlyCollection<K>
    implements Set<K> {
        KeySet() {
        }

        @Override
        public PrimitiveIterator<K> iterator() {
            IntValueHashMap intValueHashMap = IntValueHashMap.this;
            intValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(intValueHashMap, true);
        }

        @Override
        public int size() {
            return IntValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return IntValueHashMap.this.containsKey(o);
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            return IntValueHashMap.this.toArray(true);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return IntValueHashMap.this.toArray(a, true);
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(IntValueHashMap.this, true);
        }

        @Override
        public Map.Entry<K, Long> next() {
            Object key = super.next();
            Integer value = IntValueHashMap.this.intValueTable[this.lookup];
            return new MapEntry<Object, Integer>(key, value);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<K, Integer>>
    implements Set<Map.Entry<K, Integer>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, Integer>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return IntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

