/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class KMPSearchAlgorithm {
    public static long search(InputStream inputStream, byte[] pattern, int[] table) throws IOException {
        int currentByte;
        if (inputStream == null || pattern == null || pattern.length == 0) {
            return -1L;
        }
        int patternLength = pattern.length;
        long streamIndex = -1L;
        if (patternLength == 1) {
            int currentByte2;
            byte byteToFind = pattern[0];
            while (-1 != (currentByte2 = inputStream.read())) {
                ++streamIndex;
                if (currentByte2 != byteToFind) continue;
                return streamIndex;
            }
            return -1L;
        }
        int patternIndex = 0;
        if (table == null) {
            table = KMPSearchAlgorithm.computeTable(pattern);
        }
        while (-1 != (currentByte = inputStream.read())) {
            ++streamIndex;
            if (currentByte == pattern[patternIndex]) {
                ++patternIndex;
            } else if (patternIndex > 0) {
                patternIndex = table[patternIndex];
                ++patternIndex;
            }
            if (patternIndex != patternLength) continue;
            return streamIndex - (long)(patternLength - 1);
        }
        return -1L;
    }

    public static long search(Reader reader, char[] pattern, int[] table) throws IOException {
        int currentCharacter;
        if (reader == null || pattern == null || pattern.length == 0) {
            return -1L;
        }
        int patternLength = pattern.length;
        long streamIndex = -1L;
        if (patternLength == 1) {
            int currentCharacter2;
            char characterToFind = pattern[0];
            while (-1 != (currentCharacter2 = reader.read())) {
                ++streamIndex;
                if (currentCharacter2 != characterToFind) continue;
                return streamIndex;
            }
            return -1L;
        }
        int patternIndex = 0;
        if (table == null) {
            table = KMPSearchAlgorithm.computeTable(pattern);
        }
        while (-1 != (currentCharacter = reader.read())) {
            ++streamIndex;
            if (currentCharacter == pattern[patternIndex]) {
                ++patternIndex;
            } else if (patternIndex > 0) {
                patternIndex = table[patternIndex];
                ++patternIndex;
            }
            if (patternIndex != patternLength) continue;
            return streamIndex - (long)(patternLength - 1);
        }
        return -1L;
    }

    public static int search(byte[] source, byte[] pattern, int[] table, int start) {
        int sourceIndex;
        if (source == null || pattern == null || pattern.length == 0) {
            return -1;
        }
        int sourceLength = source.length;
        int patternLength = pattern.length;
        if (patternLength == 1) {
            byte byteToFind = pattern[0];
            for (sourceIndex = start; sourceIndex < sourceLength; ++sourceIndex) {
                if (source[sourceIndex] != byteToFind) continue;
                return sourceIndex;
            }
            return -1;
        }
        int matchStart = start;
        int patternIndex = 0;
        if (table == null) {
            table = KMPSearchAlgorithm.computeTable(pattern);
        }
        while (sourceIndex < sourceLength && patternIndex < patternLength) {
            if (source[sourceIndex] == pattern[patternIndex]) {
                ++patternIndex;
            } else {
                int tableValue = table[patternIndex];
                matchStart += patternIndex - tableValue;
                if (patternIndex > 0) {
                    patternIndex = tableValue;
                }
                ++patternIndex;
            }
            sourceIndex = matchStart + patternIndex;
        }
        if (patternIndex == patternLength) {
            return matchStart;
        }
        return -1;
    }

    public static int search(char[] source, char[] pattern, int[] table, int start) {
        int sourceIndex;
        if (source == null || pattern == null || pattern.length == 0) {
            return -1;
        }
        int sourceLength = source.length;
        int patternLength = pattern.length;
        if (patternLength == 1) {
            char characterToFind = pattern[0];
            for (sourceIndex = start; sourceIndex < sourceLength; ++sourceIndex) {
                if (source[sourceIndex] != characterToFind) continue;
                return sourceIndex;
            }
            return -1;
        }
        int matchStart = start;
        int patternIndex = 0;
        if (table == null) {
            table = KMPSearchAlgorithm.computeTable(pattern);
        }
        while (sourceIndex < sourceLength && patternIndex < patternLength) {
            if (source[sourceIndex] == pattern[patternIndex]) {
                ++patternIndex;
            } else {
                int tableValue = table[patternIndex];
                matchStart += patternIndex - tableValue;
                if (patternIndex > 0) {
                    patternIndex = tableValue;
                }
                ++patternIndex;
            }
            sourceIndex = matchStart + patternIndex;
        }
        if (patternIndex == patternLength) {
            return matchStart;
        }
        return -1;
    }

    public static int search(String source, String pattern, int[] table, int start) {
        if (source == null || pattern == null || pattern.isEmpty()) {
            return -1;
        }
        int patternLength = pattern.length();
        if (patternLength == 1) {
            return source.indexOf(pattern, start);
        }
        int sourceLength = source.length();
        int matchStart = start;
        int sourceIndex = start;
        int patternIndex = 0;
        if (table == null) {
            table = KMPSearchAlgorithm.computeTable(pattern);
        }
        while (sourceIndex < sourceLength && patternIndex < patternLength) {
            if (source.charAt(sourceIndex) == pattern.charAt(patternIndex)) {
                ++patternIndex;
            } else {
                int tableValue = table[patternIndex];
                matchStart += patternIndex - tableValue;
                if (patternIndex > 0) {
                    patternIndex = tableValue;
                }
                ++patternIndex;
            }
            sourceIndex = matchStart + patternIndex;
        }
        if (patternIndex == patternLength) {
            return matchStart;
        }
        return -1;
    }

    public static int[] computeTable(byte[] pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern must  not be null.");
        }
        if (pattern.length < 2) {
            throw new IllegalArgumentException("Pattern length must be > 1.");
        }
        int[] table = new int[pattern.length];
        int i = 2;
        int j = 0;
        table[0] = -1;
        table[1] = 0;
        while (i < pattern.length) {
            if (pattern[i - 1] == pattern[j]) {
                table[i] = j + 1;
                ++j;
                ++i;
                continue;
            }
            if (j > 0) {
                j = table[j];
                continue;
            }
            table[i] = 0;
            ++i;
            j = 0;
        }
        return table;
    }

    public static int[] computeTable(char[] pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern must  not be null.");
        }
        if (pattern.length < 2) {
            throw new IllegalArgumentException("Pattern length must be > 1.");
        }
        int[] table = new int[pattern.length];
        int i = 2;
        int j = 0;
        table[0] = -1;
        table[1] = 0;
        while (i < pattern.length) {
            if (pattern[i - 1] == pattern[j]) {
                table[i] = j + 1;
                ++j;
                ++i;
                continue;
            }
            if (j > 0) {
                j = table[j];
                continue;
            }
            table[i] = 0;
            ++i;
            j = 0;
        }
        return table;
    }

    public static int[] computeTable(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern must  not be null.");
        }
        if (pattern.length() < 2) {
            throw new IllegalArgumentException("Pattern length must be > 1.");
        }
        int patternLength = pattern.length();
        int[] table = new int[patternLength];
        int i = 2;
        int j = 0;
        table[0] = -1;
        table[1] = 0;
        while (i < patternLength) {
            if (pattern.charAt(i - 1) == pattern.charAt(j)) {
                table[i] = j + 1;
                ++j;
                ++i;
                continue;
            }
            if (j > 0) {
                j = table[j];
                continue;
            }
            table[i] = 0;
            ++i;
            j = 0;
        }
        return table;
    }
}

