/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class LongKeyHashMap<V>
extends BaseHashMap
implements Map<Long, V> {
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private Set<Long> keySet;
    private Collection<V> values;
    private Set<Map.Entry<Long, V>> entries;

    public LongKeyHashMap() {
        this(16);
    }

    public LongKeyHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 2, 3, false);
    }

    public Lock getReadLock() {
        return this.readLock;
    }

    public Lock getWriteLock() {
        return this.writeLock;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Long) {
            long longKey = (Long)key;
            return this.containsKey(longKey);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(long key) {
        this.readLock.lock();
        try {
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        this.readLock.lock();
        try {
            boolean bl = super.containsValue(value);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V get(Object key) {
        if (key instanceof Long) {
            long longKey = (Long)key;
            return this.get(longKey);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(long key) {
        this.readLock.lock();
        try {
            int lookup = this.getLookup(key);
            if (lookup == -1) {
                V v = null;
                return v;
            }
            Object object = this.objectValueTable[lookup];
            return (V)object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V put(Long key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        long longKey = key;
        return this.put(longKey, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(long key, V value) {
        this.writeLock.lock();
        try {
            Object object = super.addOrUpdate(key, 0L, null, value);
            return (V)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public V remove(Object key) {
        if (key instanceof Long) {
            long longKey = (Long)key;
            return this.remove(longKey);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(long key) {
        this.writeLock.lock();
        try {
            Object object = super.remove(key, 0L, null, null, false, false);
            return (V)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            super.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = super.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = super.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends Long, ? extends V> other) {
        Iterator it = other.keySet().iterator();
        this.writeLock.lock();
        try {
            while (it.hasNext()) {
                Long key = (Long)it.next();
                long longKey = key;
                this.put(longKey, other.get(key));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(LongKeyHashMap other) {
        this.writeLock.lock();
        try {
            PrimitiveIterator it = (PrimitiveIterator)other.keySet().iterator();
            while (it.hasNext()) {
                long key = it.nextLong();
                this.put(key, other.get(key));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long[] keysToArray(long[] array) {
        this.readLock.lock();
        try {
            long[] lArray = this.toLongArray(array, true);
            return lArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Object[] valuesToArray() {
        this.readLock.lock();
        try {
            Object[] objectArray = this.toArray(false);
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public <T> T[] valuesToArray(T[] array) {
        this.readLock.lock();
        try {
            T[] TArray = this.toArray(array, false);
            return TArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<Long> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet<Long>();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<V>
    extends AbstractReadOnlyCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            LongKeyHashMap longKeyHashMap = LongKeyHashMap.this;
            longKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longKeyHashMap, false);
        }

        @Override
        public int size() {
            return LongKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            return LongKeyHashMap.this.toArray(false);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return LongKeyHashMap.this.toArray(a, false);
        }
    }

    private class KeySet<Long>
    extends AbstractReadOnlyCollection<Long>
    implements Set<Long> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            LongKeyHashMap longKeyHashMap = LongKeyHashMap.this;
            longKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longKeyHashMap, true);
        }

        @Override
        public int size() {
            return LongKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(LongKeyHashMap.this, true);
        }

        @Override
        public Map.Entry<Long, V> next() {
            Long key = super.nextLong();
            Object value = LongKeyHashMap.this.objectValueTable[this.lookup];
            return new MapEntry<Long, Object>(key, value);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Long, V>>
    implements Set<Map.Entry<Long, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Long, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return LongKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

