/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class LongKeyIntValueHashMap
extends BaseHashMap
implements Map<Long, Integer> {
    private Set<Long> keySet;
    private Collection<Integer> values;
    private Set<Map.Entry<Long, Integer>> entries;

    public LongKeyIntValueHashMap() {
        this(8);
    }

    public LongKeyIntValueHashMap(boolean minimize) {
        this(8);
        this.minimizeOnEmpty = minimize;
    }

    public LongKeyIntValueHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 2, 1, false);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Long) {
            long longKey = (Long)key;
            return super.containsKey(longKey);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsKey(long key) {
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            return super.containsValue(intValue);
        }
        if (value == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsValue(int value) {
        return super.containsValue(value);
    }

    @Override
    public Integer get(Object key) {
        if (key instanceof Long) {
            long longKey = (Long)key;
            try {
                int intVal = this.get(longKey);
                return intVal;
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public int get(long key) throws NoSuchElementException {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.intValueTable[lookup];
        }
        throw new NoSuchElementException();
    }

    public int get(long key, int defaultValue) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.intValueTable[lookup];
        }
        return defaultValue;
    }

    public boolean get(long key, int[] value) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            value[0] = this.intValueTable[lookup];
            return true;
        }
        return false;
    }

    @Override
    public int getLookup(long key) {
        return super.getLookup(key);
    }

    @Override
    public Integer put(Long key, Integer value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        int oldSize = this.size();
        super.addOrUpdate(key, value.intValue(), null, null);
        if (oldSize == this.size()) {
            return null;
        }
        return value;
    }

    @Override
    public boolean put(long key, int value) {
        int oldSize = this.size();
        super.addOrUpdate(key, value, null, null);
        return oldSize != this.size();
    }

    @Override
    public Integer remove(Object key) {
        if (key instanceof Long) {
            long longKey = (Long)key;
            return (Integer)super.remove(longKey, 0L, null, null, false, false);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public boolean remove(long key) {
        Integer value = (Integer)super.remove(key, 0L, null, null, false, false);
        return value != null;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Integer> other) {
        Iterator it = other.keySet().iterator();
        while (it.hasNext()) {
            Long key = (Long)it.next();
            long longKey = key;
            Integer value = other.get(key);
            int intValue = value;
            this.put(longKey, intValue);
        }
    }

    public void putAll(LongKeyIntValueHashMap other) {
        PrimitiveIterator it = (PrimitiveIterator)other.keySet().iterator();
        while (it.hasNext()) {
            long key = it.nextLong();
            int value = other.get(key);
            this.put(key, value);
        }
    }

    public long[] keysToArray(long[] array) {
        return this.toLongArray(array, true);
    }

    public int[] valuesToArray(int[] array) {
        return this.toIntArray(array, false);
    }

    @Override
    public Set<Long> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet<Long>();
        }
        return this.keySet;
    }

    @Override
    public Collection<Integer> values() {
        if (this.values == null) {
            this.values = new Values<Integer>();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Long, Integer>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<Integer>
    extends AbstractReadOnlyCollection<Integer> {
        private Values() {
        }

        @Override
        public PrimitiveIterator<Integer> iterator() {
            LongKeyIntValueHashMap longKeyIntValueHashMap = LongKeyIntValueHashMap.this;
            longKeyIntValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longKeyIntValueHashMap, false);
        }

        @Override
        public int size() {
            return LongKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet<Long>
    extends AbstractReadOnlyCollection<Long>
    implements Set<Long> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            LongKeyIntValueHashMap longKeyIntValueHashMap = LongKeyIntValueHashMap.this;
            longKeyIntValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longKeyIntValueHashMap, true);
        }

        @Override
        public int size() {
            return LongKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(LongKeyIntValueHashMap.this, true);
        }

        @Override
        public Map.Entry<Long, Integer> next() {
            Long key = super.nextLong();
            Integer value = LongKeyIntValueHashMap.this.intValueTable[this.lookup];
            return new MapEntry<Long, Integer>(key, value);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Long, Integer>>
    implements Set<Map.Entry<Long, Integer>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Long, Integer>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return LongKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

