/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class LongKeyLongValueHashMap
extends BaseHashMap
implements Map<Long, Long> {
    private Set<Long> keySet;
    private Collection<Long> values;
    private Set<Map.Entry<Long, Long>> entries;

    public LongKeyLongValueHashMap() {
        this(8);
    }

    public LongKeyLongValueHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 2, 2, false);
    }

    public LongKeyLongValueHashMap(boolean minimize) {
        this(8);
        this.minimizeOnEmpty = minimize;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Long) {
            long longKey = (Long)key;
            return super.containsKey(longKey);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsKey(long key) {
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Long) {
            long longValue = (Long)value;
            return super.containsValue(longValue);
        }
        if (value == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsValue(long value) {
        return super.containsValue(value);
    }

    @Override
    public Long get(Object key) {
        if (key instanceof Long) {
            long longKey = ((Long)key).intValue();
            try {
                long longVal = this.get(longKey);
                return longVal;
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public long get(long key) throws NoSuchElementException {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.longValueTable[lookup];
        }
        throw new NoSuchElementException();
    }

    public long get(long key, long defaultValue) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.longValueTable[lookup];
        }
        return defaultValue;
    }

    public boolean get(long key, long[] value) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            value[0] = this.longValueTable[lookup];
            return true;
        }
        return false;
    }

    @Override
    public Long put(Long key, Long value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        int oldSize = this.size();
        super.addOrUpdate(key, value, null, null);
        if (oldSize == this.size()) {
            return null;
        }
        return value;
    }

    @Override
    public boolean put(long key, long value) {
        int oldSize = this.size();
        super.addOrUpdate(key, value, null, null);
        return oldSize != this.size();
    }

    @Override
    public Long remove(Object key) {
        if (key instanceof Long) {
            long longKey = (Long)key;
            return (Long)super.remove(longKey, 0L, null, null, false, false);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public boolean remove(long key) {
        Long value = (Long)super.remove(key, 0L, null, null, false, false);
        return value != null;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Long> other) {
        Iterator it = other.keySet().iterator();
        while (it.hasNext()) {
            Long key = (Long)it.next();
            long longKey = key;
            Long value = other.get(key);
            long longValue = value;
            this.put(longKey, longValue);
        }
    }

    public void putAll(IntKeyIntValueHashMap other) {
        PrimitiveIterator it = (PrimitiveIterator)other.keySet().iterator();
        while (it.hasNext()) {
            long longKey = it.nextLong();
            int longValue = other.get(longKey);
            this.put(longKey, longValue);
        }
    }

    public long[] keysToArray(long[] array) {
        return this.toLongArray(array, true);
    }

    public long[] valuesToArray(long[] array) {
        return this.toLongArray(array, false);
    }

    @Override
    public Set<Long> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet<Long>();
        }
        return this.keySet;
    }

    @Override
    public Collection<Long> values() {
        if (this.values == null) {
            this.values = new Values<Long>();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Long, Long>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<Long>
    extends AbstractReadOnlyCollection<Long> {
        private Values() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            LongKeyLongValueHashMap longKeyLongValueHashMap = LongKeyLongValueHashMap.this;
            longKeyLongValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longKeyLongValueHashMap, false);
        }

        @Override
        public int size() {
            return LongKeyLongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet<Long>
    extends AbstractReadOnlyCollection<Long>
    implements Set<Long> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            LongKeyLongValueHashMap longKeyLongValueHashMap = LongKeyLongValueHashMap.this;
            longKeyLongValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longKeyLongValueHashMap, true);
        }

        @Override
        public int size() {
            return LongKeyLongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(LongKeyLongValueHashMap.this, true);
        }

        @Override
        public Map.Entry<Long, Long> next() {
            Long key = super.nextLong();
            Long value = LongKeyLongValueHashMap.this.longValueTable[this.lookup];
            return new MapEntry<Long, Long>(key, value);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Long, Long>>
    implements Set<Map.Entry<Long, Long>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Long, Long>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return LongKeyLongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

