/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class LongValueHashMap<K>
extends BaseHashMap {
    private Set<K> keySet;
    private Collection<Long> values;
    private Set<Map.Entry<K, Long>> entries;

    public LongValueHashMap() {
        this(8);
    }

    public LongValueHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 3, 2, false);
    }

    public LongValueHashMap(int initialCapacity, ObjectComparator comparator) {
        this(initialCapacity);
        this.comparator = comparator;
    }

    public long get(Object key) throws NoSuchElementException {
        if (key == null) {
            throw new NullPointerException();
        }
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.longValueTable[lookup];
        }
        throw new NoSuchElementException();
    }

    public long get(Object key, int defaultValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.longValueTable[lookup];
        }
        return defaultValue;
    }

    public boolean get(Object key, long[] value) {
        if (key == null) {
            throw new NullPointerException();
        }
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            value[0] = this.longValueTable[lookup];
            return true;
        }
        return false;
    }

    public Object getKey(long value) {
        BaseHashMap.BaseHashIterator it = new BaseHashMap.BaseHashIterator(this, false);
        while (it.hasNext()) {
            long i = it.nextLong();
            if (i != value) continue;
            return this.objectKeyTable[it.getLookup()];
        }
        return null;
    }

    public boolean put(Object key, long value) {
        if (key == null) {
            throw new NullPointerException();
        }
        int oldSize = this.size();
        super.addOrUpdate(0L, value, key, null);
        return oldSize != this.size();
    }

    public boolean remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        int oldSize = this.size();
        super.remove(0L, 0L, key, null, false, false);
        return oldSize != this.size();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return super.containsKey(key);
    }

    public void putAll(LongValueHashMap t) {
        Iterator it = t.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            this.put(key, t.get(key));
        }
    }

    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection<Long> values() {
        if (this.values == null) {
            this.values = new Values<Long>();
        }
        return this.values;
    }

    public Set<Map.Entry<K, Long>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<Long>
    extends AbstractReadOnlyCollection<Long> {
        private Values() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            LongValueHashMap longValueHashMap = LongValueHashMap.this;
            longValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longValueHashMap, false);
        }

        @Override
        public int size() {
            return LongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet<K>
    extends AbstractReadOnlyCollection<K>
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            LongValueHashMap longValueHashMap = LongValueHashMap.this;
            longValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longValueHashMap, true);
        }

        @Override
        public int size() {
            return LongValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object key) {
            return LongValueHashMap.this.containsKey(key);
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            return LongValueHashMap.this.toArray(true);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return LongValueHashMap.this.toArray(array, true);
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(LongValueHashMap.this, true);
        }

        @Override
        public Map.Entry<K, Long> next() {
            Object key = super.next();
            Long value = LongValueHashMap.this.longValueTable[this.lookup];
            return new MapEntry<Object, Long>(key, value);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<K, Long>>
    implements Set<Map.Entry<K, Long>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, Long>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return LongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

