/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.HashMap;

public class OrderedHashMap<K, V>
extends HashMap<K, V> {
    public OrderedHashMap() {
        this(8);
    }

    public OrderedHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity);
        this.isList = true;
    }

    public K getKeyAt(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        return (K)this.objectKeyTable[index];
    }

    public V getValueAt(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        return (V)this.objectValueTable[index];
    }

    public V get(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        return (V)this.objectValueTable[index];
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return (V)super.remove(0L, 0L, key, null, false, true);
    }

    public void removeEntry(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        Object key = this.objectKeyTable[index];
        super.remove(0L, 0L, key, null, false, true);
    }

    public boolean add(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        int lookup = this.getLookup(key);
        if (lookup >= 0) {
            return false;
        }
        super.put(key, value);
        return true;
    }

    public V setValueAt(int index, V value) throws IndexOutOfBoundsException {
        this.checkRange(index);
        Object returnValue = this.objectValueTable[index];
        this.objectValueTable[index] = value;
        return (V)returnValue;
    }

    public boolean insert(int index, K key, V value) throws IndexOutOfBoundsException {
        if (key == null) {
            throw new NullPointerException();
        }
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int lookup = this.getLookup(key);
        if (lookup >= 0) {
            return false;
        }
        if (index < this.size()) {
            super.insertRow(index);
        }
        super.put(key, value);
        return true;
    }

    public boolean set(int index, K key, V value) throws IndexOutOfBoundsException {
        if (key == null) {
            throw new NullPointerException();
        }
        this.checkRange(index);
        if (this.keySet().contains(key) && this.getIndex(key) != index) {
            return false;
        }
        super.remove(0L, 0L, this.objectKeyTable[index], null, false, false);
        super.put(key, value);
        return true;
    }

    public boolean setKeyAt(int index, K key) throws IndexOutOfBoundsException {
        if (key == null) {
            throw new NullPointerException();
        }
        this.checkRange(index);
        Object value = this.objectValueTable[index];
        return this.set(index, key, value);
    }

    public int getIndex(K key) {
        return this.getLookup(key);
    }

    private void checkRange(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

