/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.List;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.Set;

public class OrderedHashSet<E>
extends HashSet<E>
implements List<E>,
Set<E> {
    public OrderedHashSet() {
        super(8);
        this.isList = true;
    }

    public OrderedHashSet(int initialCapacity) {
        super(initialCapacity);
        this.isList = true;
    }

    public OrderedHashSet(int initialCapacity, ObjectComparator<E> comparator) {
        super(initialCapacity, comparator);
        this.isList = true;
    }

    public OrderedHashSet(Object[] valueList) {
        this(valueList.length);
        for (int i = 0; i < valueList.length; ++i) {
            this.add(valueList[i]);
        }
    }

    @Override
    public boolean remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return (Boolean)super.remove(0L, 0L, key, null, false, true);
    }

    @Override
    public E remove(int index) {
        this.checkRange(index);
        Object key = this.objectKeyTable[index];
        super.remove(0L, 0L, key, null, false, true);
        return (E)key;
    }

    public void removeEntry(int index) throws IndexOutOfBoundsException {
        this.remove(index);
    }

    public boolean insert(int index, E key) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.contains(key)) {
            return false;
        }
        if (index < this.size()) {
            super.insertRow(index);
        }
        return this.add(key);
    }

    @Override
    public E set(int index, E key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.checkRange(index);
        if (this.contains(key) && this.getIndex(key) != index) {
            throw new IllegalArgumentException();
        }
        Object oldKey = this.objectKeyTable[index];
        super.remove(0L, 0L, oldKey, null, false, false);
        this.add(key);
        return (E)oldKey;
    }

    @Override
    public void add(int index, E key) {
        boolean result = this.insert(index, key);
        if (!result) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public E get(int index) {
        this.checkRange(index);
        return (E)this.objectKeyTable[index];
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        return this.toArray(array);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        System.arraycopy(this.objectKeyTable, 0, array, 0, array.length);
        return array;
    }

    public int indexOf(Object key) {
        return this.getLookup(key);
    }

    public int getIndex(Object key) {
        return this.getLookup(key);
    }

    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    public int getLargestIndex(OrderedHashSet<E> other) {
        int max = -1;
        int size = other.size();
        for (int i = 0; i < size; ++i) {
            int index = this.indexOf(other.get(i));
            if (index <= max) continue;
            max = index;
        }
        return max;
    }

    public int getSmallestIndex(OrderedHashSet<E> other) {
        int min = -1;
        int size = other.size();
        for (int i = 0; i < size; ++i) {
            int index = this.indexOf(other.get(i));
            if (index == -1 || min != -1 && index >= min) continue;
            min = index;
        }
        return min;
    }

    @Override
    public int getCommonElementCount(Set<E> other) {
        int count = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!other.contains(this.objectKeyTable[i])) continue;
            ++count;
        }
        return count;
    }

    public static <E> OrderedHashSet<E> addAll(OrderedHashSet<E> first, OrderedHashSet<E> second) {
        if (second == null) {
            return first;
        }
        if (first == null) {
            first = new OrderedHashSet<E>();
        }
        first.addAll(second);
        return first;
    }

    public static <E> OrderedHashSet<E> add(OrderedHashSet<E> first, E value) {
        if (value == null) {
            return first;
        }
        if (first == null) {
            first = new OrderedHashSet<E>();
        }
        first.add(value);
        return first;
    }

    private void checkRange(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

