/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.IntHashSet;

public class OrderedIntHashSet
extends IntHashSet {
    public OrderedIntHashSet() {
        this(8);
    }

    public OrderedIntHashSet(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity);
        this.isList = true;
    }

    public OrderedIntHashSet(int[] elements) {
        super(elements.length);
        this.isList = true;
        this.addAll(elements);
    }

    public OrderedIntHashSet(int[] elementsA, int[] elementsB) {
        super(elementsA.length + elementsB.length);
        this.isList = true;
        this.addAll(elementsA);
        this.addAll(elementsB);
    }

    public boolean insert(int index, int key) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.contains(key)) {
            return false;
        }
        if (index < this.size()) {
            super.insertRow(index);
        }
        return this.add(key);
    }

    @Override
    public boolean remove(int key) {
        return (Boolean)super.remove(key, 0L, null, null, false, true);
    }

    public void removeEntry(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        int key = this.intKeyTable[index];
        super.remove(key, 0L, null, null, false, true);
    }

    public int get(int index) {
        this.checkRange(index);
        return this.intKeyTable[index];
    }

    public int getIndex(int value) {
        return this.getLookup(value);
    }

    public int getOrderedStartMatchCount(int[] array) {
        int i;
        for (i = 0; i < array.length && i < this.size() && this.get(i) == array[i]; ++i) {
        }
        return i;
    }

    public boolean addAll(OrderedIntHashSet set) {
        int oldSize = this.size();
        int setSize = set.size();
        for (int i = 0; i < setSize; ++i) {
            int value = set.get(i);
            this.add(value);
        }
        return oldSize != this.size();
    }

    private void checkRange(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

