/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Map;

public class OrderedIntKeyHashMap<V>
extends IntKeyHashMap<V>
implements Map<Integer, V> {
    public OrderedIntKeyHashMap() {
        this(8);
    }

    public OrderedIntKeyHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity);
        this.isList = true;
    }

    public int getKeyAt(int lookup, int def) {
        if (lookup >= 0 && lookup < this.size()) {
            return this.intKeyTable[lookup];
        }
        return def;
    }

    public Object getValueAt(int index) {
        this.checkRange(index);
        return this.objectValueTable[index];
    }

    public Object setValueAt(int index, Object value) {
        this.checkRange(index);
        Object oldValue = this.objectValueTable[index];
        this.objectValueTable[index] = value;
        return oldValue;
    }

    public boolean set(int index, int key, V value) throws IndexOutOfBoundsException {
        this.checkRange(index);
        if (this.keySet().contains(key) && this.getIndex(key) != index) {
            return false;
        }
        super.remove(this.intKeyTable[index], 0L, null, null, false, false);
        this.put(key, value);
        return true;
    }

    public boolean insert(int index, int key, V value) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int lookup = this.getLookup(key);
        if (lookup >= 0) {
            return false;
        }
        if (index < this.size()) {
            super.insertRow(index);
        }
        super.put(key, value);
        return true;
    }

    public boolean setKeyAt(int index, int key) throws IndexOutOfBoundsException {
        this.checkRange(index);
        Object value = this.objectValueTable[index];
        return this.set(index, key, value);
    }

    public int getIndex(int key) {
        return this.getLookup(key);
    }

    @Override
    public V remove(int key) {
        return (V)super.remove(key, 0L, null, null, false, true);
    }

    public void removeEntry(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        int key = this.intKeyTable[index];
        super.remove(key, 0L, null, null, false, true);
    }

    private void checkRange(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

