/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.map.BaseHashMap;

public class OrderedLongHashSet
extends BaseHashMap {
    public OrderedLongHashSet() {
        this(8);
    }

    public OrderedLongHashSet(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 2, 0, false);
        this.isList = true;
    }

    public boolean contains(long key) {
        return super.containsKey(key);
    }

    public boolean add(long key) {
        int oldSize = this.size();
        super.addOrUpdate(key, 0L, null, null);
        return oldSize != this.size();
    }

    public boolean insert(int index, long key) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.contains(key)) {
            return false;
        }
        if (index < this.size()) {
            super.insertRow(index);
        }
        return this.add(key);
    }

    public boolean remove(long key) {
        return (Boolean)super.remove(key, 0L, null, null, false, true);
    }

    public void removeEntry(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        long key = this.longKeyTable[index];
        super.remove(key, 0L, null, null, false, true);
    }

    public long get(int index) {
        this.checkRange(index);
        return this.longKeyTable[index];
    }

    public int getIndex(long value) {
        return this.getLookup(value);
    }

    public int getStartMatchCount(long[] array) {
        int i;
        for (i = 0; i < array.length && super.containsKey(array[i]); ++i) {
        }
        return i;
    }

    public int getOrderedStartMatchCount(long[] array) {
        int i;
        for (i = 0; i < array.length && i < this.size() && this.get(i) == array[i]; ++i) {
        }
        return i;
    }

    public boolean addAll(OrderedLongHashSet col) {
        int oldSize = this.size();
        for (int i = 0; i < oldSize; ++i) {
            long val = col.longValueTable[i];
            this.add(val);
        }
        return oldSize != this.size();
    }

    public long[] toArray() {
        int lookup = -1;
        long[] array = new long[this.size()];
        for (int i = 0; i < array.length; ++i) {
            long value;
            lookup = super.nextLookup(lookup);
            array[i] = value = (long)this.intKeyTable[lookup];
        }
        return array;
    }

    public PrimitiveIterator<Long> iterator() {
        return new BaseHashMap.BaseHashIterator(this, true);
    }

    private void checkRange(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

