/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class OrderedLongKeyHashMap<V>
extends BaseHashMap
implements Map<Long, V> {
    private Set<Long> keySet;
    private Collection<V> values;
    private Set<Map.Entry<Long, V>> entries;

    public OrderedLongKeyHashMap() {
        this(8);
    }

    public OrderedLongKeyHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 2, 3, false);
        this.isList = true;
    }

    public OrderedLongKeyHashMap(int initialCapacity, boolean hasThirdValue) throws IllegalArgumentException {
        super(initialCapacity, 2, 3, false);
        this.objectKeyTable = new Object[this.objectValueTable.length];
        this.isTwoObjectValue = true;
        this.isList = true;
        if (hasThirdValue) {
            this.objectValueTable2 = new Object[this.objectValueTable.length];
        }
        this.minimizeOnEmpty = true;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Long) {
            long longKey = (Long)key;
            return this.containsKey(longKey);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsKey(long key) {
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    @Override
    public V get(Object key) {
        if (key instanceof Long) {
            long longKey = (Long)key;
            return this.get(longKey);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public V get(long key) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return (V)this.objectValueTable[lookup];
        }
        return null;
    }

    public long getKeyAt(int index) {
        this.checkRange(index);
        return this.longKeyTable[index];
    }

    public V getValueAt(int index) {
        this.checkRange(index);
        return (V)this.objectValueTable[index];
    }

    public Object getSecondValueAt(int index) {
        this.checkRange(index);
        return this.objectKeyTable[index];
    }

    public Object getThirdValueAt(int index) {
        this.checkRange(index);
        return this.objectValueTable2[index];
    }

    public Object setValueAt(int index, Object value) {
        this.checkRange(index);
        Object oldValue = this.objectValueTable[index];
        this.objectValueTable[index] = value;
        return oldValue;
    }

    public Object setSecondValueAt(int index, Object value) {
        this.checkRange(index);
        Object oldValue = this.objectKeyTable[index];
        this.objectKeyTable[index] = value;
        return oldValue;
    }

    public Object setThirdValueAt(int index, Object value) {
        this.checkRange(index);
        Object oldValue = this.objectValueTable2[index];
        this.objectValueTable2[index] = value;
        return oldValue;
    }

    public boolean insert(int index, long key, V value) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int lookup = this.getLookup(key);
        if (lookup >= 0) {
            return false;
        }
        if (index < this.size()) {
            super.insertRow(index);
        }
        this.put(key, value);
        return true;
    }

    public boolean set(int index, long key, V value) throws IndexOutOfBoundsException {
        this.checkRange(index);
        if (this.keySet().contains(key) && this.getIndex(key) != index) {
            return false;
        }
        super.remove(this.longKeyTable[index], 0L, null, null, false, false);
        this.put(key, value);
        return true;
    }

    public boolean setKeyAt(int index, long key) throws IndexOutOfBoundsException {
        this.checkRange(index);
        Object value = this.objectValueTable[index];
        return this.set(index, key, value);
    }

    public int getIndex(long key) {
        return this.getLookup(key);
    }

    @Override
    public V put(Long key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        long longKey = key;
        return this.put(longKey, value);
    }

    @Override
    public V put(long key, V value) {
        return (V)super.addOrUpdate(key, 0L, null, value);
    }

    @Override
    public V remove(Object key) {
        if (key instanceof Long) {
            long longKey = (Long)key;
            return this.remove(longKey);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public V remove(long key) {
        Object returnValue = super.remove(key, 0L, null, null, false, true);
        return (V)returnValue;
    }

    public void removeEntry(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        long key = this.longKeyTable[index];
        super.remove(key, 0L, null, null, false, true);
    }

    @Override
    public int getLookup(long key) {
        return super.getLookup(key);
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> other) {
        Iterator it = other.keySet().iterator();
        while (it.hasNext()) {
            Long key = (Long)it.next();
            long longKey = key;
            this.put(longKey, other.get(key));
        }
    }

    public void putAll(LongKeyHashMap other) {
        PrimitiveIterator it = (PrimitiveIterator)other.keySet().iterator();
        while (it.hasNext()) {
            long key = it.nextLong();
            this.put(key, (V)other.get(key));
        }
    }

    public long[] keysToArray(long[] array) {
        return this.toLongArray(array, true);
    }

    public Object[] valuesToArray() {
        return this.toArray(false);
    }

    public <T> T[] valuesToArray(T[] array) {
        return this.toArray(array, false);
    }

    @Override
    public Set<Long> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet<Long>();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private void checkRange(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }

    private class Values<V>
    extends AbstractReadOnlyCollection<V> {
        private Values() {
        }

        @Override
        public PrimitiveIterator<V> iterator() {
            OrderedLongKeyHashMap orderedLongKeyHashMap = OrderedLongKeyHashMap.this;
            orderedLongKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(orderedLongKeyHashMap, false);
        }

        @Override
        public int size() {
            return OrderedLongKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            return OrderedLongKeyHashMap.this.toArray(false);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return OrderedLongKeyHashMap.this.toArray(array, false);
        }
    }

    private class KeySet<Long>
    extends AbstractReadOnlyCollection<Long>
    implements Set<Long> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            OrderedLongKeyHashMap orderedLongKeyHashMap = OrderedLongKeyHashMap.this;
            orderedLongKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(orderedLongKeyHashMap, true);
        }

        @Override
        public int size() {
            return OrderedLongKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(OrderedLongKeyHashMap.this, true);
        }

        @Override
        public Map.Entry<Long, V> next() {
            Long key = super.nextLong();
            Object value = OrderedLongKeyHashMap.this.objectValueTable[this.lookup];
            return new MapEntry<Long, Object>(key, value);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Long, V>>
    implements Set<Map.Entry<Long, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Long, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return OrderedLongKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

