/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import org.hsqldb.lib.HsqlArrayList;

public class StringUtil {
    public static String toZeroPaddedString(long value, int precision, int maxSize) {
        String s;
        StringBuilder sb = new StringBuilder();
        if (value < 0L) {
            value = -value;
        }
        if ((s = Long.toString(value)).length() > precision) {
            s = s.substring(precision);
        }
        for (int i = s.length(); i < precision; ++i) {
            sb.append('0');
        }
        sb.append(s);
        if (maxSize < precision) {
            sb.setLength(maxSize);
        }
        return sb.toString();
    }

    public static String toPaddedString(String source, int length, char pad, boolean trailing) {
        int len = source.length();
        if (len >= length) {
            return source;
        }
        StringBuilder sb = new StringBuilder(length);
        if (trailing) {
            sb.append(source);
        }
        for (int i = len; i < length; ++i) {
            sb.append(pad);
        }
        if (!trailing) {
            sb.append(source);
        }
        return sb.toString();
    }

    public static String toPaddedString(String source, int length, String pad, boolean trailing) {
        int len = source.length();
        if (len == length) {
            return source;
        }
        if (len > length) {
            if (trailing) {
                return source.substring(0, length);
            }
            return source.substring(len - length, len);
        }
        StringBuilder sb = new StringBuilder(length);
        int padedLength = source.length();
        int partLength = (length - padedLength) % pad.length();
        if (trailing) {
            sb.append(source);
        }
        while (padedLength + pad.length() <= length) {
            sb.append(pad);
            padedLength += pad.length();
        }
        sb.append(pad.substring(0, partLength));
        if (!trailing) {
            sb.append(source);
        }
        return sb.toString();
    }

    public static String toLowerSubset(String source, char substitute) {
        int len = source.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = source.charAt(i);
            if (!Character.isLetterOrDigit(ch)) {
                sb.append(substitute);
                continue;
            }
            if (i == 0 && Character.isDigit(ch)) {
                sb.append(substitute);
                continue;
            }
            sb.append(Character.toLowerCase(ch));
        }
        return sb.toString();
    }

    public static String arrayToString(Object array) {
        int len = Array.getLength(array);
        int last = len - 1;
        StringBuilder sb = new StringBuilder(2 * (len + 1));
        sb.append('{');
        for (int i = 0; i < len; ++i) {
            sb.append(Array.get(array, i));
            if (i == last) continue;
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }

    public static String getList(String[] s, String separator, String quote) {
        int len = s.length;
        StringBuilder sb = new StringBuilder(len * 16);
        for (int i = 0; i < len; ++i) {
            sb.append(quote);
            sb.append(s[i]);
            sb.append(quote);
            if (i + 1 >= len) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String getList(int[] s, String separator, String quote) {
        int len = s.length;
        StringBuilder sb = new StringBuilder(len * 8);
        for (int i = 0; i < len; ++i) {
            sb.append(quote);
            sb.append(s[i]);
            sb.append(quote);
            if (i + 1 >= len) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String getList(long[] s, String separator, String quote) {
        int len = s.length;
        StringBuilder sb = new StringBuilder(len * 8);
        for (int i = 0; i < len; ++i) {
            sb.append(quote);
            sb.append(s[i]);
            sb.append(quote);
            if (i + 1 >= len) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String getList(String[][] s, String separator, String quote) {
        int len = s.length;
        StringBuilder sb = new StringBuilder(len * 16);
        for (int i = 0; i < len; ++i) {
            sb.append(quote);
            sb.append(s[i][0]);
            sb.append(quote);
            if (i + 1 >= len) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static boolean isEmpty(String s) {
        int i;
        int n = i = s == null ? 0 : s.length();
        while (i > 0) {
            if (s.charAt(--i) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static int rightTrimSize(String s) {
        int i = s.length();
        while (i > 0) {
            if (s.charAt(--i) == ' ') continue;
            return i + 1;
        }
        return 0;
    }

    public static int skipSpaces(String s, int start) {
        int i;
        int limit = s.length();
        for (i = start; i < limit && s.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    public static String[] split(String s, String separator) {
        HsqlArrayList<String> list = new HsqlArrayList<String>();
        int currindex = 0;
        boolean more = true;
        while (more) {
            int nextindex = s.indexOf(separator, currindex);
            if (nextindex == -1) {
                nextindex = s.length();
                more = false;
            }
            list.add(s.substring(currindex, nextindex));
            currindex = nextindex + separator.length();
        }
        return list.toArray(new String[list.size()]);
    }
}

