/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.Iterator;

public class WrapperIterator<E>
implements Iterator<E> {
    private static final Object[] emptyelements = new Object[0];
    private Object[] elements;
    private int i;
    private boolean chained;
    private Iterator<E> it1;
    private Iterator<E> it2;
    private boolean notNull;

    public WrapperIterator() {
        this.elements = emptyelements;
    }

    public WrapperIterator(Object[] elements) {
        this.elements = elements;
    }

    public WrapperIterator(Object[] elements, boolean notNull) {
        this.elements = elements;
        this.notNull = notNull;
    }

    public WrapperIterator(Object element) {
        this.elements = new Object[]{element};
    }

    public WrapperIterator(Iterator<E> it1, Iterator<E> it2) {
        this.it1 = it1;
        this.it2 = it2;
        this.chained = true;
    }

    @Override
    public boolean hasNext() {
        if (this.chained) {
            if (this.it1 == null) {
                if (this.it2 == null) {
                    return false;
                }
                if (this.it2.hasNext()) {
                    return true;
                }
                this.it2 = null;
                return false;
            }
            if (this.it1.hasNext()) {
                return true;
            }
            this.it1 = null;
            return this.hasNext();
        }
        if (this.elements == null) {
            return false;
        }
        while (this.notNull && this.i < this.elements.length && this.elements[this.i] == null) {
            ++this.i;
        }
        if (this.i < this.elements.length) {
            return true;
        }
        this.elements = null;
        return false;
    }

    @Override
    public E next() {
        if (this.chained) {
            if (this.it1 == null) {
                if (this.it2 == null) {
                    throw new NoSuchElementException();
                }
                if (this.it2.hasNext()) {
                    return this.it2.next();
                }
                this.it2 = null;
                return this.next();
            }
            if (this.it1.hasNext()) {
                return this.it1.next();
            }
            this.it1 = null;
            return this.next();
        }
        if (this.hasNext()) {
            return (E)this.elements[this.i++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextInt() {
        throw new NoSuchElementException();
    }

    @Override
    public long nextLong() {
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new NoSuchElementException();
    }
}

