/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.java;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.Charset;

public final class JavaSystem {
    public static final Charset CS_ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset CS_US_ASCII = Charset.forName("US-ASCII");
    public static final Charset CS_UTF8 = Charset.forName("UTF-8");
    private static int javaVersion;

    public static int javaVersion() {
        return javaVersion;
    }

    public static long availableMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static long usedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static Throwable unmap(MappedByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (javaVersion > 8) {
            try {
                Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
                unsafeField.setAccessible(true);
                Object unsafe = unsafeField.get(null);
                Method invokeCleaner = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
                invokeCleaner.invoke(unsafe, buffer);
                return null;
            }
            catch (NoSuchMethodException unsafeClass) {
            }
            catch (NoSuchFieldException unsafeClass) {
            }
            catch (IllegalAccessException unsafeClass) {
            }
            catch (ClassNotFoundException unsafeClass) {
            }
            catch (InvocationTargetException e) {
                return e;
            }
            catch (Throwable t) {
                return t;
            }
        }
        try {
            Method cleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
            cleanerMethod.setAccessible(true);
            Object cleaner = cleanerMethod.invoke((Object)buffer, new Object[0]);
            Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
            cleanMethod.invoke(cleaner, new Object[0]);
            return null;
        }
        catch (NoSuchMethodException cleanerMethod) {
        }
        catch (IllegalAccessException cleanerMethod) {
        }
        catch (InvocationTargetException e) {
            return e;
        }
        catch (Throwable t) {
            return t;
        }
        try {
            Method freeMethod = buffer.getClass().getMethod("free", new Class[0]);
            freeMethod.setAccessible(true);
            freeMethod.invoke((Object)buffer, new Object[0]);
            return null;
        }
        catch (Throwable t) {
            return t;
        }
    }

    public static IOException toIOException(Throwable t) {
        if (t instanceof IOException) {
            return (IOException)t;
        }
        return new IOException(t);
    }

    static {
        try {
            String version = System.getProperty("java.specification.version", "6");
            if (version.startsWith("1.")) {
                version = version.substring(2);
            } else if (version.startsWith("0.")) {
                version = "6";
            }
            javaVersion = Integer.parseInt(version);
        }
        catch (Throwable t) {
            javaVersion = 11;
        }
    }
}

