/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import org.hsqldb.lib.InputStreamInterface;
import org.hsqldb.lib.InputStreamWrapper;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarGenerator;
import org.hsqldb.lib.tar.TarMalformatException;

public class DbBackup {
    protected File dbDir;
    protected File archiveFile;
    protected String instanceName;
    protected boolean overWrite = false;
    protected boolean abortUponModify = true;
    File[] componentFiles;
    InputStreamInterface[] componentStreams;
    boolean[] existList;
    boolean[] ignoreList;

    public DbBackup(File archiveFile, String dbPath) {
        this.archiveFile = archiveFile;
        File dbPathFile = new File(dbPath);
        this.dbDir = dbPathFile.getAbsoluteFile().getParentFile();
        this.instanceName = dbPathFile.getName();
        this.componentFiles = new File[]{new File(this.dbDir, this.instanceName + ".properties"), new File(this.dbDir, this.instanceName + ".script"), new File(this.dbDir, this.instanceName + ".data"), new File(this.dbDir, this.instanceName + ".backup"), new File(this.dbDir, this.instanceName + ".log"), new File(this.dbDir, this.instanceName + ".lobs")};
        this.componentStreams = new InputStreamInterface[this.componentFiles.length];
        this.existList = new boolean[this.componentFiles.length];
        this.ignoreList = new boolean[this.componentFiles.length];
    }

    public DbBackup(File archiveFile, String dbPath, boolean script) {
        this.archiveFile = archiveFile;
        File dbPathFile = new File(dbPath);
        this.dbDir = dbPathFile.getAbsoluteFile().getParentFile();
        this.instanceName = dbPathFile.getName();
        this.componentFiles = new File[]{new File(this.dbDir, this.instanceName + ".script")};
        this.componentStreams = new InputStreamInterface[this.componentFiles.length];
        this.existList = new boolean[this.componentFiles.length];
        this.ignoreList = new boolean[this.componentFiles.length];
        this.abortUponModify = false;
    }

    public void setStream(String fileExtension, InputStreamInterface is) {
        for (int i = 0; i < this.componentFiles.length; ++i) {
            if (!this.componentFiles[i].getName().endsWith(fileExtension)) continue;
            this.componentStreams[i] = is;
            break;
        }
    }

    public void setFileIgnore(String fileExtension) {
        for (int i = 0; i < this.componentFiles.length; ++i) {
            if (!this.componentFiles[i].getName().endsWith(fileExtension)) continue;
            this.ignoreList[i] = true;
            break;
        }
    }

    public void setOverWrite(boolean overWrite) {
        this.overWrite = overWrite;
    }

    public void setAbortUponModify(boolean abortUponModify) {
        this.abortUponModify = abortUponModify;
    }

    public boolean getOverWrite() {
        return this.overWrite;
    }

    public boolean getAbortUponModify() {
        return this.abortUponModify;
    }

    public void write() throws IOException, TarMalformatException {
        long startTime = new Date().getTime();
        this.checkEssentialFiles();
        TarGenerator generator = new TarGenerator(this.archiveFile, this.overWrite, DbBackup.generateBufferBlockValue(this.componentFiles));
        for (int i = 0; i < this.componentFiles.length; ++i) {
            boolean exists;
            boolean bl = exists = this.componentStreams[i] != null || this.componentFiles[i].exists();
            if (!exists || this.ignoreList[i]) continue;
            if (this.componentStreams[i] == null) {
                generator.queueEntry(this.componentFiles[i].getName(), this.componentFiles[i]);
                this.existList[i] = true;
                continue;
            }
            generator.queueEntry(this.componentFiles[i].getName(), this.componentStreams[i]);
        }
        generator.write();
        this.checkFilesNotChanged(startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAsFiles() throws IOException {
        int bufferSize = 512 * DbBackup.generateBufferBlockValue(this.componentFiles);
        byte[] writeBuffer = new byte[bufferSize];
        this.checkEssentialFiles();
        FileOutputStream fileOut = null;
        for (int i = 0; i < this.componentFiles.length; ++i) {
            try {
                int count;
                if (this.ignoreList[i] || !this.componentFiles[i].exists()) continue;
                File outFile = new File(this.archiveFile, this.componentFiles[i].getName());
                fileOut = new FileOutputStream(outFile);
                if (this.componentStreams[i] == null) {
                    this.componentStreams[i] = new InputStreamWrapper(new FileInputStream(this.componentFiles[i]));
                }
                InputStreamInterface instream = this.componentStreams[i];
                while ((count = instream.read(writeBuffer, 0, writeBuffer.length)) > 0) {
                    fileOut.write(writeBuffer, 0, count);
                }
                instream.close();
                fileOut.flush();
                fileOut.getFD().sync();
                continue;
            }
            finally {
                if (fileOut != null) {
                    fileOut.close();
                    fileOut = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void checkEssentialFiles() throws FileNotFoundException, IllegalStateException {
        String modifiedString;
        Properties p;
        block22: {
            if (!this.componentFiles[0].getName().endsWith(".properties")) {
                return;
            }
            for (int i = 0; i < 2; ++i) {
                boolean exists;
                boolean bl = exists = this.componentStreams[i] != null || this.componentFiles[i].exists();
                if (exists) continue;
                throw new FileNotFoundException(RB.file_missing.getString(this.componentFiles[i].getAbsolutePath()));
            }
            if (!this.abortUponModify) {
                return;
            }
            p = new Properties();
            FileInputStream fis = null;
            try {
                File propertiesFile2 = this.componentFiles[0];
                fis = new FileInputStream(propertiesFile2);
                p.load(fis);
            }
            catch (IOException propertiesFile2) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    break block22;
                }
                catch (IOException propertiesFile2) {
                    break block22;
                }
                finally {
                    fis = null;
                }
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        fis = null;
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        fis = null;
                        throw throwable;
                    }
                }
                catch (Throwable throwable2) {
                    fis = null;
                    throw throwable2;
                }
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException propertiesFile2) {
            }
            finally {
                fis = null;
            }
        }
        if ((modifiedString = p.getProperty("modified")) == null) return;
        if (!modifiedString.equalsIgnoreCase("yes")) {
            if (!modifiedString.equalsIgnoreCase("true")) return;
        }
        throw new IllegalStateException(RB.modified_property.getString(modifiedString));
    }

    void checkFilesNotChanged(long startTime) throws FileNotFoundException {
        if (!this.abortUponModify) {
            return;
        }
        try {
            for (int i = 0; i < this.componentFiles.length; ++i) {
                if (this.componentFiles[i].exists()) {
                    if (!this.existList[i]) {
                        throw new FileNotFoundException(RB.file_disappeared.getString(this.componentFiles[i].getAbsolutePath()));
                    }
                    if (this.componentFiles[i].lastModified() <= startTime) continue;
                    throw new FileNotFoundException(RB.file_changed.getString(this.componentFiles[i].getAbsolutePath()));
                }
                if (!this.existList[i]) continue;
                throw new FileNotFoundException(RB.file_appeared.getString(this.componentFiles[i].getAbsolutePath()));
            }
        }
        catch (IllegalStateException ise) {
            if (!this.archiveFile.delete()) {
                System.out.println(RB.cleanup_rmfail.getString(this.archiveFile.getAbsolutePath()));
            }
            throw ise;
        }
    }

    protected static int generateBufferBlockValue(File[] files) {
        long maxFileSize = 0L;
        for (int i = 0; i < files.length; ++i) {
            if (files[i] == null || files[i].length() <= maxFileSize) continue;
            maxFileSize = files[i].length();
        }
        int idealBlocks = (int)(maxFileSize / 5120L);
        if (idealBlocks < 1) {
            return 1;
        }
        if (idealBlocks > 40960) {
            return 40960;
        }
        return idealBlocks;
    }

    protected static int generateBufferBlockValue(File file) {
        return DbBackup.generateBufferBlockValue(new File[]{file});
    }
}

