/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.map;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.hsqldb.lib.ArrayCounter;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.map.HashIndex;

public class BaseHashMap {
    protected boolean isIntKey;
    protected boolean isLongKey;
    protected boolean isObjectKey;
    protected boolean isNoValue;
    protected boolean isIntValue;
    protected boolean isLongValue;
    protected boolean isObjectValue;
    protected boolean isMultiValue;
    protected boolean isTwoObjectValue;
    protected boolean isList;
    protected boolean isAccessCount;
    protected boolean isLastAccessCount;
    protected HashIndex hashIndex;
    protected int[] intKeyTable;
    protected Object[] objectKeyTable;
    protected long[] longKeyTable;
    protected int[] intValueTable;
    protected Object[] objectValueTable;
    protected long[] longValueTable;
    protected int accessMin;
    protected AtomicInteger accessCount;
    protected int[] accessTable;
    protected Object[] objectValueTable2;
    protected final float loadFactor;
    protected final int initialCapacity;
    protected int threshold;
    protected int maxCapacity;
    protected int purgePolicy = 0;
    protected boolean minimizeOnEmpty;
    protected ObjectComparator comparator = ObjectComparator.defaultComparator;
    protected boolean hasZeroKey;
    protected int zeroKeyIndex = -1;
    protected int zeroOrNullValueCount;
    protected static final int noKeyOrValue = 0;
    protected static final int intKeyOrValue = 1;
    protected static final int longKeyOrValue = 2;
    protected static final int objectKeyOrValue = 3;
    protected static final int NO_PURGE = 0;
    protected static final int PURGE_ALL = 1;
    protected static final int PURGE_HALF = 2;
    public static final int ACCESS_MAX = 0x7FEFFFFF;
    public static final Object[] emptyObjectArray = new Object[0];

    protected BaseHashMap(int initialCapacity, int keyType, int valueType, boolean hasAccessCount) throws IllegalArgumentException {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        initialCapacity = initialCapacity < 4 ? 4 : (int)ArrayUtil.getBinaryNormalisedCeiling(initialCapacity);
        this.loadFactor = 1.0f;
        this.initialCapacity = initialCapacity;
        this.threshold = initialCapacity;
        int hashtablesize = (int)((float)initialCapacity * this.loadFactor);
        if (hashtablesize < 4) {
            hashtablesize = 4;
        }
        this.hashIndex = new HashIndex(hashtablesize, initialCapacity, true);
        int arraySize = this.threshold;
        if (keyType == 1) {
            this.isIntKey = true;
            this.intKeyTable = new int[arraySize];
        } else if (keyType == 3) {
            this.isObjectKey = true;
            this.objectKeyTable = new Object[arraySize];
        } else {
            this.isLongKey = true;
            this.longKeyTable = new long[arraySize];
        }
        if (valueType == 1) {
            this.isIntValue = true;
            this.intValueTable = new int[arraySize];
        } else if (valueType == 3) {
            this.isObjectValue = true;
            this.objectValueTable = new Object[arraySize];
        } else if (valueType == 2) {
            this.isLongValue = true;
            this.longValueTable = new long[arraySize];
        } else {
            this.isNoValue = true;
        }
        this.isLastAccessCount = hasAccessCount;
        if (hasAccessCount) {
            this.accessTable = new int[arraySize];
            this.accessCount = new AtomicInteger();
        }
    }

    protected int getLookup(Object key) {
        Object current;
        int hash = this.comparator.hashCode(key);
        int lookup = this.hashIndex.getLookup(hash);
        while (lookup >= 0 && !this.comparator.equals(key, current = this.objectKeyTable[lookup])) {
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        return lookup;
    }

    protected int getLookup(Object key, int hash) {
        Object current;
        int lookup = this.hashIndex.getLookup(hash);
        while (lookup >= 0 && !this.comparator.equals(key, current = this.objectKeyTable[lookup])) {
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        return lookup;
    }

    protected int getLookup(int key) {
        int current;
        int hash = (int)((long)key >>> 32 ^ (long)key);
        int lookup = this.hashIndex.getLookup(hash);
        while (lookup >= 0 && key != (current = this.intKeyTable[lookup])) {
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        return lookup;
    }

    protected int getLookup(long key) {
        long current;
        int hash = (int)(key >>> 32 ^ key);
        int lookup = this.hashIndex.getLookup(hash);
        while (lookup >= 0 && key != (current = this.longKeyTable[lookup])) {
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        return lookup;
    }

    protected int getObjectLookup(long key) {
        long tempKey;
        int hash = (int)(key >>> 32 ^ key);
        int lookup = this.hashIndex.getLookup(hash);
        while (lookup >= 0 && (tempKey = this.comparator.longKey(this.objectKeyTable[lookup])) != key) {
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        return lookup;
    }

    protected PrimitiveIterator getMultiValuesIterator(Object key) {
        int lookup = this.getLookup(key);
        ValueCollectionIterator valuesIterator = new ValueCollectionIterator(key, lookup);
        return valuesIterator;
    }

    protected int multiValueElementCount(Object key) {
        int lookup = this.getLookup(key);
        if (lookup == -1) {
            return 0;
        }
        int count = 1;
        while ((lookup = this.hashIndex.getNextLookup(lookup)) != -1 && this.objectKeyTable[lookup].equals(key)) {
            ++count;
        }
        return count;
    }

    protected int multiValueKeyCount() {
        int count = 0;
        int lookup = -1;
        Object oldKey = null;
        int index = 0;
        while (index < this.hashIndex.hashTable.length) {
            if (this.hashIndex.hashTable[index] < 0) {
                ++index;
                continue;
            }
            if ((lookup = lookup < 0 ? this.hashIndex.hashTable[index] : this.hashIndex.getNextLookup(lookup)) < 0) {
                ++index;
                continue;
            }
            if (this.comparator.equals(oldKey, this.objectKeyTable[lookup])) continue;
            oldKey = this.objectKeyTable[lookup];
            ++count;
        }
        return count;
    }

    protected Object addOrUpdate(long longKey, long longValue, Object objectKey, Object objectValue) {
        int hash;
        if (this.isObjectKey) {
            if (objectKey == null) {
                return null;
            }
            hash = this.comparator.hashCode(objectKey);
        } else {
            hash = (int)(longKey >>> 32 ^ longKey);
        }
        int index = this.hashIndex.getHashIndex(hash);
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        Object returnValue = null;
        boolean matched = false;
        while (lookup >= 0) {
            if (this.isObjectKey) {
                matched = this.comparator.equals(this.objectKeyTable[lookup], objectKey);
            } else if (this.isIntKey) {
                matched = longKey == (long)this.intKeyTable[lookup];
            } else if (this.isLongKey) {
                boolean bl = matched = longKey == this.longKeyTable[lookup];
            }
            if (matched) break;
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (matched) {
            if (this.isNoValue) {
                return Boolean.FALSE;
            }
            if (this.isObjectValue) {
                returnValue = this.objectValueTable[lookup];
                this.objectValueTable[lookup] = objectValue;
                if (objectValue == null) {
                    if (returnValue != null) {
                        ++this.zeroOrNullValueCount;
                    }
                } else if (returnValue == null) {
                    --this.zeroOrNullValueCount;
                }
            } else if (this.isIntValue) {
                int existing = this.intValueTable[lookup];
                returnValue = existing;
                this.intValueTable[lookup] = (int)longValue;
                if (longValue == 0L) {
                    if (existing != 0) {
                        ++this.zeroOrNullValueCount;
                    }
                } else if (existing == 0) {
                    --this.zeroOrNullValueCount;
                }
            } else if (this.isLongValue) {
                long existing = this.longValueTable[lookup];
                returnValue = existing;
                this.longValueTable[lookup] = longValue;
                if (longValue == 0L) {
                    if (existing != 0L) {
                        ++this.zeroOrNullValueCount;
                    }
                } else if (existing == 0L) {
                    --this.zeroOrNullValueCount;
                }
            }
            if (this.isLastAccessCount) {
                this.accessTable[lookup] = this.accessCount.incrementAndGet();
            } else if (this.isAccessCount) {
                int n = lookup;
                this.accessTable[n] = this.accessTable[n] + 1;
            }
            return returnValue;
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addOrUpdate(longKey, longValue, objectKey, objectValue);
            }
            throw new NoSuchElementException("BaseHashMap");
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        if (this.isObjectKey) {
            this.objectKeyTable[lookup] = objectKey;
        } else if (this.isIntKey) {
            this.intKeyTable[lookup] = (int)longKey;
            if (longKey == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = lookup;
            }
        } else if (this.isLongKey) {
            this.longKeyTable[lookup] = longKey;
            if (longKey == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = lookup;
            }
        }
        if (this.isNoValue) {
            return Boolean.TRUE;
        }
        if (this.isObjectValue) {
            this.objectValueTable[lookup] = objectValue;
            if (objectValue == null) {
                ++this.zeroOrNullValueCount;
            }
        } else if (this.isIntValue) {
            this.intValueTable[lookup] = (int)longValue;
            if (longValue == 0L) {
                ++this.zeroOrNullValueCount;
            }
        } else if (this.isLongValue) {
            this.longValueTable[lookup] = longValue;
            if (longValue == 0L) {
                ++this.zeroOrNullValueCount;
            }
        }
        if (this.isLastAccessCount) {
            this.accessTable[lookup] = this.accessCount.incrementAndGet();
        } else if (this.isAccessCount) {
            this.accessTable[lookup] = 1;
        }
        return returnValue;
    }

    protected Object remove(long longKey, long longValue, Object objectKey, Object objectValue, boolean matchValue, boolean removeRow) {
        int hash;
        if (this.isObjectKey) {
            if (objectKey == null) {
                return null;
            }
            hash = this.comparator.hashCode(objectKey);
        } else {
            hash = (int)(longKey >>> 32 ^ longKey);
        }
        int index = this.hashIndex.getHashIndex(hash);
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        Object returnValue = null;
        while (lookup >= 0) {
            boolean matched = false;
            if (this.isObjectKey) {
                matched = this.comparator.equals(this.objectKeyTable[lookup], objectKey);
            } else if (this.isIntKey) {
                matched = longKey == (long)this.intKeyTable[lookup];
            } else if (this.isLongKey) {
                boolean bl = matched = longKey == this.longKeyTable[lookup];
            }
            if (matched) {
                if (!matchValue) break;
                if (this.isObjectValue) {
                    matched = ObjectComparator.defaultComparator.equals(this.objectValueTable[lookup], objectValue);
                } else if (this.isIntValue) {
                    matched = (long)this.intValueTable[lookup] == longValue;
                } else if (this.isLongKey) {
                    boolean bl = matched = this.longValueTable[lookup] == longValue;
                }
                if (matched) break;
                return null;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (lookup < 0) {
            if (this.isNoValue) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (this.isObjectKey) {
            this.objectKeyTable[lookup] = null;
        } else {
            if (longKey == 0L) {
                this.hasZeroKey = false;
                this.zeroKeyIndex = -1;
            }
            if (this.isIntKey) {
                this.intKeyTable[lookup] = 0;
            } else {
                this.longKeyTable[lookup] = 0L;
            }
        }
        if (this.isNoValue) {
            returnValue = Boolean.TRUE;
        } else if (this.isObjectValue) {
            returnValue = this.objectValueTable[lookup];
            this.objectValueTable[lookup] = null;
            if (returnValue == null) {
                --this.zeroOrNullValueCount;
            }
        } else if (this.isIntValue) {
            int existing = this.intValueTable[lookup];
            returnValue = existing;
            this.intValueTable[lookup] = 0;
            if (existing == 0) {
                --this.zeroOrNullValueCount;
            }
        } else if (this.isLongValue) {
            long existing = this.longValueTable[lookup];
            returnValue = existing;
            this.longValueTable[lookup] = 0L;
            if (existing == 0L) {
                --this.zeroOrNullValueCount;
            }
        }
        this.hashIndex.unlinkNode(index, lastLookup, lookup);
        if (this.accessTable != null) {
            this.accessTable[lookup] = 0;
        }
        if (this.isList && removeRow) {
            this.removeRow(lookup);
        }
        if (this.minimizeOnEmpty && this.hashIndex.elementCount == 0) {
            this.rehash(this.initialCapacity);
        }
        return returnValue;
    }

    protected boolean addMultiVal(long longKey, long longValue, Object objectKey, Object objectValue) {
        int hash;
        if (this.isObjectKey) {
            if (objectKey == null) {
                return false;
            }
            hash = this.comparator.hashCode(objectKey);
        } else {
            hash = (int)(longKey >>> 32 ^ longKey);
        }
        int index = this.hashIndex.getHashIndex(hash);
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        int matchedKey = -1;
        boolean matched = false;
        while (lookup >= 0) {
            if (this.isObjectKey) {
                matched = this.comparator.equals(this.objectKeyTable[lookup], objectKey);
            } else if (this.isIntKey) {
                matched = longKey == (long)this.intKeyTable[lookup];
            } else if (this.isLongKey) {
                boolean bl = matched = longKey == this.longKeyTable[lookup];
            }
            if (!matched) {
                if (matchedKey >= 0) break;
            } else {
                matchedKey = lookup;
                if (this.isObjectValue) {
                    matched = ObjectComparator.defaultComparator.equals(this.objectValueTable[lookup], objectValue);
                } else if (this.isIntValue) {
                    matched = longValue == (long)this.intValueTable[lookup];
                } else if (this.isLongValue) {
                    boolean bl = matched = longValue == this.longValueTable[lookup];
                }
                if (matched) {
                    return false;
                }
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addMultiVal(longKey, longValue, objectKey, objectValue);
            }
            throw new NoSuchElementException("BaseHashMap");
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        if (this.isObjectKey) {
            this.objectKeyTable[lookup] = objectKey;
        } else if (this.isIntKey) {
            this.intKeyTable[lookup] = (int)longKey;
            if (longKey == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = lookup;
            }
        } else if (this.isLongKey) {
            this.longKeyTable[lookup] = longKey;
            if (longKey == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = lookup;
            }
        }
        if (this.isObjectValue) {
            this.objectValueTable[lookup] = objectValue;
            if (objectValue == null) {
                ++this.zeroOrNullValueCount;
            }
        } else if (this.isIntValue) {
            this.intValueTable[lookup] = (int)longValue;
            if (longValue == 0L) {
                ++this.zeroOrNullValueCount;
            }
        } else if (this.isLongValue) {
            this.longValueTable[lookup] = longValue;
            if (longValue == 0L) {
                ++this.zeroOrNullValueCount;
            }
        }
        if (this.isLastAccessCount) {
            this.accessTable[lookup] = this.accessCount.incrementAndGet();
        } else if (this.isAccessCount) {
            this.accessTable[lookup] = 1;
        }
        return true;
    }

    protected Object removeMultiVal(long longKey, long longValue, Object objectKey, Object objectValue, boolean matchValue) {
        if (objectKey == null) {
            return null;
        }
        int hash = this.comparator.hashCode(objectKey);
        int index = this.hashIndex.getHashIndex(hash);
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        int matchedKey = -1;
        Object returnValue = null;
        while (lookup >= 0) {
            boolean matched = false;
            if (this.isObjectKey) {
                matched = this.comparator.equals(this.objectKeyTable[lookup], objectKey);
                if (!matched) {
                    if (matchedKey >= 0) break;
                } else {
                    matchedKey = lookup;
                    if (matchValue) {
                        matched = ObjectComparator.defaultComparator.equals(this.objectValueTable[lookup], objectValue);
                        if (matched) {
                            this.objectKeyTable[lookup] = null;
                            returnValue = this.objectValueTable[lookup];
                            this.objectValueTable[lookup] = null;
                            if (returnValue == null) {
                                --this.zeroOrNullValueCount;
                            }
                            this.hashIndex.unlinkNode(index, lastLookup, lookup);
                            return returnValue;
                        }
                    } else {
                        this.objectKeyTable[lookup] = null;
                        returnValue = this.objectValueTable[lookup];
                        this.objectValueTable[lookup] = null;
                        if (returnValue == null) {
                            --this.zeroOrNullValueCount;
                        }
                        if (lastLookup > lookup) {
                            // empty if block
                        }
                        this.hashIndex.unlinkNode(index, lastLookup, lookup);
                        if (lastLookup < 0) {
                            lookup = this.hashIndex.hashTable[index];
                            if (lookup < 0) {
                                break;
                            }
                        } else {
                            lookup = lastLookup;
                        }
                    }
                }
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        return returnValue;
    }

    protected Object removeObject(Object objectKey, boolean removeRow) {
        if (objectKey == null) {
            return null;
        }
        int hash = this.comparator.hashCode(objectKey);
        int index = this.hashIndex.getHashIndex(hash);
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        Object returnValue = null;
        while (lookup >= 0) {
            if (this.comparator.equals(this.objectKeyTable[lookup], objectKey)) {
                returnValue = this.objectKeyTable[lookup];
                this.objectKeyTable[lookup] = null;
                if (this.accessTable != null) {
                    this.accessTable[lookup] = 0;
                }
                this.hashIndex.unlinkNode(index, lastLookup, lookup);
                if (this.isObjectValue) {
                    returnValue = this.objectValueTable[lookup];
                    this.objectValueTable[lookup] = null;
                }
                if (removeRow) {
                    this.removeRow(lookup);
                }
                return returnValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        return returnValue;
    }

    protected Object addOrRemoveObject(long longKey, Object object, boolean remove) {
        int hash = (int)(longKey >>> 32 ^ longKey);
        int index = this.hashIndex.getHashIndex(hash);
        int lookup = this.hashIndex.getLookup(hash);
        int lastLookup = -1;
        Object returnValue = null;
        while (lookup >= 0) {
            if (this.comparator.longKey(this.objectKeyTable[lookup]) == longKey) {
                returnValue = this.objectKeyTable[lookup];
                break;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (lookup >= 0) {
            if (remove) {
                this.objectKeyTable[lookup] = null;
                this.hashIndex.unlinkNode(index, lastLookup, lookup);
                if (this.accessTable != null) {
                    this.accessTable[lookup] = 0;
                }
                if (this.minimizeOnEmpty && this.hashIndex.elementCount == 0) {
                    this.rehash(this.initialCapacity);
                }
            } else {
                this.objectKeyTable[lookup] = object;
                if (this.isLastAccessCount) {
                    this.accessTable[lookup] = this.accessCount.incrementAndGet();
                } else if (this.isAccessCount) {
                    int n = lookup;
                    this.accessTable[n] = this.accessTable[n] + 1;
                }
            }
            return returnValue;
        }
        if (remove) {
            return null;
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addOrRemoveObject(longKey, object, remove);
            }
            throw new NoSuchElementException("BaseHashMap");
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        this.objectKeyTable[lookup] = object;
        if (this.isLastAccessCount) {
            this.accessTable[lookup] = this.accessCount.incrementAndGet();
        } else if (this.isAccessCount) {
            this.accessTable[lookup] = 1;
        }
        return returnValue;
    }

    protected boolean reset() {
        if (this.maxCapacity == 0 || this.maxCapacity > this.threshold) {
            this.rehash(this.hashIndex.linkTable.length * 2);
            return true;
        }
        switch (this.purgePolicy) {
            case 1: {
                this.clear();
                return true;
            }
            case 2: {
                this.clearToHalf();
                return true;
            }
        }
        return false;
    }

    protected void rehash(int newCapacity) {
        int limitLookup = this.hashIndex.newNodePointer;
        boolean oldZeroKey = this.hasZeroKey;
        int oldZeroKeyIndex = this.zeroKeyIndex;
        if (newCapacity < this.hashIndex.elementCount) {
            return;
        }
        this.hashIndex.reset((int)((float)newCapacity * this.loadFactor), newCapacity);
        this.hasZeroKey = false;
        this.zeroKeyIndex = -1;
        this.zeroOrNullValueCount = 0;
        this.threshold = newCapacity;
        int lookup = -1;
        while ((lookup = this.nextLookup(lookup, limitLookup, oldZeroKey, oldZeroKeyIndex)) < limitLookup) {
            long longKey = 0L;
            long longValue = 0L;
            Object objectKey = null;
            Object objectValue = null;
            if (this.isObjectKey) {
                objectKey = this.objectKeyTable[lookup];
            } else {
                longKey = this.isIntKey ? (long)this.intKeyTable[lookup] : this.longKeyTable[lookup];
            }
            if (this.isObjectValue) {
                objectValue = this.objectValueTable[lookup];
            } else if (this.isIntValue) {
                longValue = this.intValueTable[lookup];
            } else if (this.isLongValue) {
                longValue = this.longValueTable[lookup];
            }
            if (this.isMultiValue) {
                this.addMultiVal(longKey, longValue, objectKey, objectValue);
            } else {
                this.addOrUpdate(longKey, longValue, objectKey, objectValue);
            }
            if (this.accessTable == null) continue;
            this.accessTable[this.hashIndex.elementCount - 1] = this.accessTable[lookup];
        }
        this.resizeElementArrays(this.hashIndex.newNodePointer, newCapacity);
    }

    private void resizeElementArrays(int dataLength, int newLength) {
        Object[] temp;
        int usedLength;
        int n = usedLength = newLength > dataLength ? dataLength : newLength;
        if (this.isIntKey) {
            temp = this.intKeyTable;
            this.intKeyTable = new int[newLength];
            System.arraycopy(temp, 0, this.intKeyTable, 0, usedLength);
        }
        if (this.isIntValue) {
            temp = this.intValueTable;
            this.intValueTable = new int[newLength];
            System.arraycopy(temp, 0, this.intValueTable, 0, usedLength);
        }
        if (this.isLongKey) {
            temp = this.longKeyTable;
            this.longKeyTable = new long[newLength];
            System.arraycopy(temp, 0, this.longKeyTable, 0, usedLength);
        }
        if (this.isLongValue) {
            temp = this.longValueTable;
            this.longValueTable = new long[newLength];
            System.arraycopy(temp, 0, this.longValueTable, 0, usedLength);
        }
        if (this.objectKeyTable != null) {
            temp = this.objectKeyTable;
            this.objectKeyTable = new Object[newLength];
            System.arraycopy(temp, 0, this.objectKeyTable, 0, usedLength);
        }
        if (this.isObjectValue) {
            temp = this.objectValueTable;
            this.objectValueTable = new Object[newLength];
            System.arraycopy(temp, 0, this.objectValueTable, 0, usedLength);
        }
        if (this.objectValueTable2 != null) {
            temp = this.objectValueTable2;
            this.objectValueTable2 = new Object[newLength];
            System.arraycopy(temp, 0, this.objectValueTable2, 0, usedLength);
        }
        if (this.accessTable != null) {
            temp = this.accessTable;
            this.accessTable = new int[newLength];
            System.arraycopy(temp, 0, this.accessTable, 0, usedLength);
        }
    }

    private void clearElementArrays(int from, int to) {
        if (this.intKeyTable != null) {
            Arrays.fill(this.intKeyTable, from, to, 0);
        } else if (this.longKeyTable != null) {
            Arrays.fill(this.longKeyTable, from, to, 0L);
        }
        if (this.objectKeyTable != null) {
            Arrays.fill(this.objectKeyTable, from, to, null);
        }
        if (this.intValueTable != null) {
            Arrays.fill(this.intValueTable, from, to, 0);
        } else if (this.longValueTable != null) {
            Arrays.fill(this.longValueTable, from, to, 0L);
        } else if (this.objectValueTable != null) {
            Arrays.fill(this.objectValueTable, from, to, null);
        }
        if (this.objectValueTable2 != null) {
            Arrays.fill(this.objectValueTable2, from, to, null);
        }
        if (this.accessTable != null) {
            Arrays.fill(this.accessTable, from, to, 0);
        }
    }

    void removeFromElementArrays(int size, int lookup) {
        Object[] array;
        if (this.isIntKey) {
            array = this.intKeyTable;
            System.arraycopy(array, lookup + 1, array, lookup, size - lookup - 1);
            this.intKeyTable[size - 1] = 0;
        } else if (this.isLongKey) {
            array = this.longKeyTable;
            System.arraycopy(array, lookup + 1, array, lookup, size - lookup - 1);
            this.longKeyTable[size - 1] = 0L;
        }
        if (this.objectKeyTable != null) {
            array = this.objectKeyTable;
            System.arraycopy(array, lookup + 1, array, lookup, size - lookup - 1);
            this.objectKeyTable[size - 1] = null;
        }
        if (this.isIntValue) {
            array = this.intValueTable;
            System.arraycopy(array, lookup + 1, array, lookup, size - lookup - 1);
            this.intValueTable[size - 1] = 0;
        } else if (this.isLongValue) {
            array = this.longValueTable;
            System.arraycopy(array, lookup + 1, array, lookup, size - lookup - 1);
            this.longValueTable[size - 1] = 0L;
        }
        if (this.isObjectValue) {
            array = this.objectValueTable;
            System.arraycopy(array, lookup + 1, array, lookup, size - lookup - 1);
            this.objectValueTable[size - 1] = null;
        }
        if (this.objectValueTable2 != null) {
            array = this.objectValueTable2;
            System.arraycopy(array, lookup + 1, array, lookup, size - lookup - 1);
            this.objectValueTable2[size - 1] = null;
        }
        if (this.accessTable != null) {
            array = this.accessTable;
            System.arraycopy(array, lookup + 1, array, lookup, size - lookup - 1);
            this.accessTable[size - 1] = 0;
        }
    }

    void insertIntoElementArrays(int size, int lookup) {
        Object[] array;
        if (this.isIntKey) {
            array = this.intKeyTable;
            System.arraycopy(array, lookup, array, lookup + 1, size - lookup);
            this.intKeyTable[lookup] = 0;
        } else if (this.isLongKey) {
            array = this.longKeyTable;
            System.arraycopy(array, lookup, array, lookup + 1, size - lookup);
            this.longKeyTable[lookup] = 0L;
        }
        if (this.objectKeyTable != null) {
            array = this.objectKeyTable;
            System.arraycopy(array, lookup, array, lookup + 1, size - lookup);
            this.objectKeyTable[lookup] = null;
        }
        if (this.isIntValue) {
            array = this.intValueTable;
            System.arraycopy(array, lookup, array, lookup + 1, size - lookup);
            this.intValueTable[lookup] = 0;
        } else if (this.isLongValue) {
            array = this.longValueTable;
            System.arraycopy(array, lookup, array, lookup + 1, size - lookup);
            this.longValueTable[lookup] = 0L;
        }
        if (this.isObjectValue) {
            array = this.objectValueTable;
            System.arraycopy(array, lookup, array, lookup + 1, size - lookup);
            this.objectValueTable[lookup] = null;
        }
        if (this.objectValueTable2 != null) {
            array = this.objectValueTable2;
            System.arraycopy(array, lookup, array, lookup + 1, size - lookup);
            this.objectValueTable2[lookup] = null;
        }
        if (this.accessTable != null) {
            array = this.accessTable;
            System.arraycopy(array, lookup, array, lookup + 1, size - lookup);
            this.accessTable[lookup] = 0;
        }
    }

    int nextLookup(int lookup, int limitLookup, boolean hasZeroKey, int zeroKeyIndex) {
        ++lookup;
        while (lookup < limitLookup) {
            if (this.isObjectKey) {
                if (this.objectKeyTable[lookup] != null) {
                    return lookup;
                }
            } else if (this.isIntKey) {
                if (this.intKeyTable[lookup] != 0) {
                    return lookup;
                }
                if (hasZeroKey && lookup == zeroKeyIndex) {
                    return lookup;
                }
            } else {
                if (this.longKeyTable[lookup] != 0L) {
                    return lookup;
                }
                if (hasZeroKey && lookup == zeroKeyIndex) {
                    return lookup;
                }
            }
            ++lookup;
        }
        return lookup;
    }

    protected int nextLookup(int lookup) {
        ++lookup;
        while (lookup < this.hashIndex.newNodePointer) {
            if (this.isObjectKey) {
                if (this.objectKeyTable[lookup] != null) {
                    return lookup;
                }
            } else if (this.isIntKey) {
                if (this.intKeyTable[lookup] != 0) {
                    return lookup;
                }
                if (this.hasZeroKey && lookup == this.zeroKeyIndex) {
                    return lookup;
                }
            } else {
                if (this.longKeyTable[lookup] != 0L) {
                    return lookup;
                }
                if (this.hasZeroKey && lookup == this.zeroKeyIndex) {
                    return lookup;
                }
            }
            ++lookup;
        }
        return -1;
    }

    protected void removeRow(int lookup) {
        int size = this.hashIndex.newNodePointer;
        if (size == 0) {
            return;
        }
        this.hashIndex.removeEmptyNode(lookup);
        this.removeFromElementArrays(size, lookup);
    }

    protected void insertRow(int lookup) {
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
        }
        if (lookup == this.hashIndex.elementCount) {
            return;
        }
        int size = this.hashIndex.newNodePointer;
        if (size == 0) {
            return;
        }
        this.insertIntoElementArrays(size, lookup);
        this.hashIndex.insertEmptyNode(lookup);
    }

    public void clear() {
        if (this.hashIndex.modified) {
            if (this.accessCount != null) {
                this.accessCount.set(0);
            }
            this.accessMin = 0;
            this.hasZeroKey = false;
            this.zeroKeyIndex = -1;
            this.zeroOrNullValueCount = 0;
            this.clearElementArrays(0, this.hashIndex.newNodePointer);
            this.hashIndex.clear();
            if (this.minimizeOnEmpty) {
                this.rehash(this.initialCapacity);
            }
        }
    }

    protected int getAccessCountCeiling(int count, int margin) {
        return ArrayCounter.rank(this.accessTable, this.hashIndex.newNodePointer, count, this.accessMin, this.accessCount.get(), margin);
    }

    protected void setAccessCountFloor(int count) {
        this.accessMin = count;
    }

    private void clearToHalf() {
        int count = this.threshold >> 1;
        int margin = this.threshold >> 8;
        if (margin < 64) {
            margin = 64;
        }
        int maxlookup = this.hashIndex.newNodePointer;
        int accessBase = this.getAccessCountCeiling(count, margin);
        for (int lookup = 0; lookup < maxlookup; ++lookup) {
            Object o = this.objectKeyTable[lookup];
            if (o == null || this.accessTable[lookup] >= accessBase) continue;
            this.removeObject(o, false);
        }
        this.accessMin = accessBase;
        if (this.hashIndex.elementCount > this.threshold - margin) {
            this.clear();
        }
    }

    protected void resetAccessCount() {
        int accessMax = this.accessCount.get();
        if (accessMax > 0 && accessMax < 0x7FEFFFFF) {
            return;
        }
        int limit = this.hashIndex.getNewNodePointer();
        accessMax = 0;
        this.accessMin = Integer.MAX_VALUE;
        for (int i = 0; i < limit; ++i) {
            int access = this.accessTable[i];
            if (access == 0) continue;
            this.accessTable[i] = access = (access >>> 2) + 1;
            if (access > accessMax) {
                accessMax = access;
                continue;
            }
            if (access >= this.accessMin) continue;
            this.accessMin = access;
        }
        if (this.accessMin > accessMax) {
            this.accessMin = accessMax;
        }
        this.accessCount.set(accessMax);
    }

    protected int capacity() {
        return this.hashIndex.linkTable.length;
    }

    public int size() {
        return this.hashIndex.elementCount;
    }

    public boolean isEmpty() {
        return this.hashIndex.elementCount == 0;
    }

    protected boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        if (this.hashIndex.elementCount == 0) {
            return false;
        }
        int lookup = this.getLookup(key, this.comparator.hashCode(key));
        return lookup != -1;
    }

    protected boolean containsKey(int key) {
        if (this.hashIndex.elementCount == 0) {
            return false;
        }
        int lookup = this.getLookup(key);
        return lookup != -1;
    }

    protected boolean containsKey(long key) {
        if (this.hashIndex.elementCount == 0) {
            return false;
        }
        int lookup = this.getLookup(key);
        return lookup != -1;
    }

    protected boolean containsValue(Object value) {
        int lookup;
        if (this.hashIndex.elementCount == 0) {
            return false;
        }
        if (value == null) {
            for (lookup = 0; lookup < this.hashIndex.newNodePointer; ++lookup) {
                if (this.objectValueTable[lookup] != null) continue;
                if (this.isObjectKey) {
                    if (this.objectKeyTable[lookup] == null) continue;
                    return true;
                }
                if (this.isIntKey) {
                    if (this.intKeyTable[lookup] != 0) {
                        return true;
                    }
                    if (!this.hasZeroKey || lookup != this.zeroKeyIndex) continue;
                    return true;
                }
                if (this.longKeyTable[lookup] != 0L) {
                    return true;
                }
                if (!this.hasZeroKey || lookup != this.zeroKeyIndex) continue;
                return true;
            }
        } else {
            while (lookup < this.hashIndex.newNodePointer) {
                if (value.equals(this.objectValueTable[lookup])) {
                    return true;
                }
                ++lookup;
            }
        }
        return false;
    }

    protected boolean containsValue(int value) {
        if (value == 0) {
            return this.zeroOrNullValueCount > 0;
        }
        for (int lookup = 0; lookup < this.hashIndex.newNodePointer; ++lookup) {
            if (this.intValueTable[lookup] != value) continue;
            return true;
        }
        return false;
    }

    protected boolean containsValue(long value) {
        if (value == 0L) {
            return this.zeroOrNullValueCount > 0;
        }
        for (int lookup = 0; lookup < this.hashIndex.newNodePointer; ++lookup) {
            if (this.longValueTable[lookup] != value) continue;
            return true;
        }
        return false;
    }

    protected Object[] toArray(boolean keys) {
        Object[] array = new Object[this.size()];
        return this.toArray(array, keys);
    }

    protected <T> T[] multiValueKeysToArray(T[] array) {
        int size = this.multiValueKeyCount();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        MultiValueKeyIterator it = new MultiValueKeyIterator();
        int index = 0;
        while (it.hasNext()) {
            array[index] = it.next();
            ++index;
        }
        return array;
    }

    protected <T> T[] toArray(T[] array, boolean keys) {
        if (array.length < this.size()) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size());
        }
        int limit = this.hashIndex.getNewNodePointer();
        int index = 0;
        Object[] table = keys ? this.objectKeyTable : this.objectValueTable;
        for (int i = 0; i < limit; ++i) {
            Object o = table[i];
            if (o == null) continue;
            array[index++] = o;
        }
        return array;
    }

    protected int[] toIntArray(int[] array, boolean keys) {
        if (array.length < this.size()) {
            array = new int[this.size()];
        }
        BaseHashIterator it = new BaseHashIterator(keys);
        for (int i = 0; i < array.length; ++i) {
            int value;
            array[i] = value = it.nextInt();
        }
        return array;
    }

    protected long[] toLongArray(long[] array, boolean keys) {
        if (array.length < this.size()) {
            array = new long[this.size()];
        }
        BaseHashIterator it = new BaseHashIterator(keys);
        for (int i = 0; i < array.length; ++i) {
            long value;
            array[i] = value = (long)it.nextInt();
        }
        return array;
    }

    public BaseHashMap clone() {
        BaseHashMap copy = null;
        try {
            copy = (BaseHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        copy.hashIndex = this.hashIndex.clone();
        if (this.intKeyTable != null) {
            copy.intKeyTable = (int[])this.intKeyTable.clone();
        }
        if (this.objectKeyTable != null) {
            copy.objectKeyTable = (Object[])this.objectKeyTable.clone();
        }
        if (this.longKeyTable != null) {
            copy.longKeyTable = (long[])this.longKeyTable.clone();
        }
        if (this.intValueTable != null) {
            copy.intValueTable = (int[])this.intValueTable.clone();
        }
        if (this.objectValueTable != null) {
            copy.objectValueTable = (Object[])this.objectValueTable.clone();
        }
        if (this.longValueTable != null) {
            copy.longValueTable = (long[])this.longValueTable.clone();
        }
        if (this.accessTable != null) {
            copy.accessTable = (int[])this.accessTable.clone();
        }
        if (this.objectValueTable2 != null) {
            copy.objectValueTable2 = (Object[])this.objectValueTable2.clone();
        }
        return copy;
    }

    BaseHashMap duplicate() {
        return null;
    }

    protected class BaseHashIterator
    implements PrimitiveIterator {
        protected boolean keys;
        protected int lookup = -1;
        protected int counter;
        protected boolean removed;

        public BaseHashIterator() {
        }

        public BaseHashIterator(boolean keys) {
            this.keys = keys;
            if (!keys && BaseHashMap.this.isNoValue) {
                throw new RuntimeException("Hash Iterator");
            }
        }

        public void reset() {
            this.lookup = -1;
            this.counter = 0;
            this.removed = false;
        }

        @Override
        public boolean hasNext() {
            return this.counter < BaseHashMap.this.hashIndex.elementCount;
        }

        @Override
        public Object next() throws NoSuchElementException {
            if (this.keys) {
                if (BaseHashMap.this.isIntKey) {
                    return this.nextInt();
                }
                if (BaseHashMap.this.isLongKey) {
                    return this.nextLong();
                }
            } else {
                if (BaseHashMap.this.isIntValue) {
                    return this.nextInt();
                }
                if (BaseHashMap.this.isLongValue) {
                    return this.nextLong();
                }
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                if (this.keys) {
                    return BaseHashMap.this.objectKeyTable[this.lookup];
                }
                return BaseHashMap.this.objectValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public int nextInt() throws NoSuchElementException {
            if (this.keys && !BaseHashMap.this.isIntKey || !this.keys && !BaseHashMap.this.isIntValue) {
                throw new NoSuchElementException("Hash Iterator");
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                if (this.keys) {
                    return BaseHashMap.this.intKeyTable[this.lookup];
                }
                return BaseHashMap.this.intValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public long nextLong() throws NoSuchElementException {
            if (this.keys && !BaseHashMap.this.isLongKey || !this.keys && !BaseHashMap.this.isLongValue) {
                throw new NoSuchElementException("Hash Iterator");
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                return this.keys ? BaseHashMap.this.longKeyTable[this.lookup] : BaseHashMap.this.longValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public void remove() throws NoSuchElementException {
            if (this.removed) {
                throw new NoSuchElementException("Hash Iterator");
            }
            --this.counter;
            this.removed = true;
            if (BaseHashMap.this.isObjectKey) {
                if (BaseHashMap.this.isMultiValue) {
                    BaseHashMap.this.removeMultiVal(0L, 0L, BaseHashMap.this.objectKeyTable[this.lookup], BaseHashMap.this.objectValueTable[this.lookup], true);
                } else {
                    BaseHashMap.this.remove(0L, 0L, BaseHashMap.this.objectKeyTable[this.lookup], null, false, true);
                }
            } else if (BaseHashMap.this.isIntKey) {
                BaseHashMap.this.remove(BaseHashMap.this.intKeyTable[this.lookup], 0L, null, null, false, true);
            } else {
                BaseHashMap.this.remove(BaseHashMap.this.longKeyTable[this.lookup], 0L, null, null, false, true);
            }
            if (BaseHashMap.this.isList) {
                --this.lookup;
            }
        }

        public int getAccessCount() {
            if (this.removed || BaseHashMap.this.accessTable == null) {
                throw new NoSuchElementException();
            }
            return BaseHashMap.this.accessTable[this.lookup];
        }

        public void setAccessCount(int count) {
            if (this.removed || BaseHashMap.this.accessTable == null) {
                throw new NoSuchElementException();
            }
            BaseHashMap.this.accessTable[this.lookup] = count;
        }

        public int getLookup() {
            return this.lookup;
        }
    }

    protected class MultiValueKeyIterator
    implements PrimitiveIterator {
        int index = 0;
        int lookup = -1;
        boolean removed;
        Object oldKey;

        public MultiValueKeyIterator() {
            if (BaseHashMap.this.hashIndex.elementCount > 0) {
                this.toNextLookup();
            }
        }

        private void toNextLookup() {
            while (this.index < BaseHashMap.this.hashIndex.hashTable.length) {
                if (BaseHashMap.this.hashIndex.hashTable[this.index] < 0) {
                    ++this.index;
                    continue;
                }
                this.lookup = this.lookup < 0 ? BaseHashMap.this.hashIndex.hashTable[this.index] : BaseHashMap.this.hashIndex.getNextLookup(this.lookup);
                if (this.lookup < 0) {
                    ++this.index;
                    continue;
                }
                if (BaseHashMap.this.comparator.equals(this.oldKey, BaseHashMap.this.objectKeyTable[this.lookup])) continue;
            }
        }

        @Override
        public boolean hasNext() {
            return this.lookup != -1;
        }

        @Override
        public Object next() throws NoSuchElementException {
            if (this.lookup < 0) {
                throw new NoSuchElementException("Hash Iterator");
            }
            Object value = BaseHashMap.this.objectKeyTable[this.lookup];
            this.toNextLookup();
            this.oldKey = value;
            return value;
        }

        @Override
        public int nextInt() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public long nextLong() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public void remove() throws NoSuchElementException {
            BaseHashMap.this.removeMultiVal(0L, 0L, this.oldKey, null, false);
            this.oldKey = null;
        }
    }

    protected class ValueCollectionIterator
    implements PrimitiveIterator {
        int lookup = -1;
        Object key;

        ValueCollectionIterator(Object key, int lookup) {
            this.key = key;
            this.lookup = lookup;
        }

        @Override
        public boolean hasNext() {
            return this.lookup != -1;
        }

        @Override
        public Object next() throws NoSuchElementException {
            Object nextKey;
            if (this.lookup == -1) {
                throw new NoSuchElementException();
            }
            Object value = BaseHashMap.this.objectValueTable[this.lookup];
            this.lookup = BaseHashMap.this.hashIndex.getNextLookup(this.lookup);
            if (this.lookup != -1 && !BaseHashMap.this.comparator.equals(nextKey = BaseHashMap.this.objectKeyTable[this.lookup], this.key)) {
                this.lookup = -1;
            }
            return value;
        }

        @Override
        public int nextInt() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public long nextLong() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public void remove() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }
    }
}

